/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class ConfigAppearance_p {
    private static final String SKIN_FILENAME_FILTER = "^.*\\.css$";

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        serverObjects prop = new serverObjects();
        Switchboard sb = (Switchboard)env;
        String skinPath = new File(env.getDataPath(), env.getConfig("skinPath", "DATA/SKINS")).toString();
        prop.put("currentskin", "");
        prop.put("status", "0");
        List<String> skinFiles = FileUtils.getDirListing(skinPath, SKIN_FILENAME_FILTER);
        if (skinFiles == null) {
            return prop;
        }
        if (post != null) {
            String selectedSkin = post.get("skin");
            if (post.containsKey("use_button") && selectedSkin != null && skinFiles.contains(selectedSkin)) {
                ConfigAppearance_p.changeSkin(sb, skinPath, selectedSkin);
            }
            if (post.containsKey("delete_button") && skinFiles.contains(selectedSkin)) {
                File skinfile = new File(skinPath, selectedSkin);
                FileUtils.deletedelete(skinfile);
            }
            if (post.containsKey("install_button")) {
                Iterator<String> iterator;
                String url = post.get("url");
                try {
                    DigestURL digestURL = new DigestURL(url);
                    iterator = FileUtils.strings(digestURL.get(ClientIdentification.yacyInternetCrawlerAgent, null, null));
                }
                catch (IOException iOException) {
                    prop.put("status", "1");
                    prop.put("status_url", url);
                    return prop;
                }
                try {
                    File file = new File(skinPath, url.substring(url.lastIndexOf(47), url.length()));
                    BufferedWriter bw = new BufferedWriter(new PrintWriter(new FileWriter(file)));
                    while (iterator.hasNext()) {
                        bw.write(iterator.next() + "\n");
                    }
                    bw.close();
                }
                catch (IOException iOException) {
                    prop.put("status", "2");
                    return prop;
                }
                if (post.containsKey("use_skin") && "on".equals(post.get("use_skin", ""))) {
                    ConfigAppearance_p.changeSkin(sb, skinPath, url.substring(url.lastIndexOf(47), url.length()));
                }
            }
            if (post.containsKey("set_colors")) {
                if (skinFiles.contains(selectedSkin)) {
                    ConfigAppearance_p.changeSkin(sb, skinPath, selectedSkin);
                }
                for (Map.Entry entry2 : post.entrySet()) {
                    if (!((String)entry2.getKey()).startsWith("color_")) continue;
                    env.setConfig((String)entry2.getKey(), "#" + (String)entry2.getValue());
                }
            }
        }
        String currentSkin = env.getConfig("currentSkin", "default");
        prop.putHTML("currentskin", currentSkin);
        skinFiles = FileUtils.getDirListing(skinPath, SKIN_FILENAME_FILTER);
        Collections.sort(skinFiles);
        int count = 0;
        for (String string : skinFiles) {
            if (!string.endsWith(".css")) continue;
            String skinName = string.substring(0, string.length() - 4);
            prop.put("skinlist_" + count + "_file", string);
            prop.put("skinlist_" + count + "_name", skinName);
            prop.put("skinlist_" + count + "_selected", skinName.equals(currentSkin) ? 1L : 0L);
            ++count;
        }
        prop.put("skinlist", count);
        Iterator<String> iterator = env.configKeys();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (!string.startsWith("color_")) continue;
            prop.put(string, env.getConfig(string, "#000000").substring(1));
        }
        return prop;
    }

    private static boolean changeSkin(Switchboard sb, String skinPath, String skin) {
        File htdocsDir = new File(sb.getDataPath("htDocsPath", "DATA/HTDOCS"), "env");
        File styleFile = new File(htdocsDir, "style.css");
        File skinFile = new File(skinPath, skin);
        styleFile.getParentFile().mkdirs();
        try {
            Files.copy((File)skinFile, (File)styleFile);
            sb.setConfig("currentSkin", skin.substring(0, skin.length() - 4));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

