/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.HeaderFramework;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.data.Cache;
import net.yacy.crawler.retrieval.Response;
import net.yacy.document.ImageParser;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.server.servletProperties;

public class CacheResource_p {
    public static Object respond(RequestHeader header, serverObjects post, serverSwitch env) {
        String charsetName;
        DigestURL url;
        Switchboard sb = (Switchboard)env;
        servletProperties prop = new servletProperties();
        prop.put("resource", new byte[0]);
        if (post == null) {
            return prop;
        }
        boolean load = post.getBoolean("load");
        String u = post.get("url", "");
        try {
            url = new DigestURL(u);
        }
        catch (MalformedURLException e) {
            ConcurrentLog.logException(e);
            return prop;
        }
        byte[] resource = Cache.getContent(url.hash());
        HeaderFramework responseHeader = null;
        if (resource == null) {
            if (load) {
                try {
                    Response response = sb.loader.load(sb.loader.request(url, false, true), CacheStrategy.NOCACHE, Integer.MAX_VALUE, null, ClientIdentification.yacyInternetCrawlerAgent);
                    responseHeader = response.getResponseHeader();
                    resource = response.getContent();
                }
                catch (IOException e) {
                    return prop;
                }
            } else {
                return prop;
            }
        }
        if (header.get("EXT", "html").equals("png")) {
            return ImageParser.parse(u, resource);
        }
        if (responseHeader == null) {
            responseHeader = Cache.getResponseHeader(url.hash());
        }
        if ((charsetName = responseHeader.getCharacterEncoding()) != null && !charsetName.equalsIgnoreCase(StandardCharsets.UTF_8.name())) {
            Charset decoderCharset = Charset.isSupported(charsetName) ? Charset.forName(charsetName) : StandardCharsets.UTF_8;
            CharBuffer cb = decoderCharset.decode(ByteBuffer.wrap(resource));
            ByteBuffer x = StandardCharsets.UTF_16.encode(cb);
            prop.put("resource", x.asCharBuffer().toString());
        } else {
            prop.put("resource", resource);
        }
        return prop;
    }
}

