/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.BlogBoard;
import net.yacy.data.BlogBoardComments;
import net.yacy.data.MessageBoard;
import net.yacy.data.UserDB;
import net.yacy.htroot.Blog;
import net.yacy.peers.Network;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class BlogComments {
    private static final String DEFAULT_PAGE = "blog_default";

    public static String dateString(Date date) {
        return Blog.dateString(date);
    }

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        boolean hasRights = sb.verifyAuthentication(header);
        prop.put("mode_admin", hasRights ? "1" : "0");
        if (post == null) {
            post = new serverObjects();
            post.put("page", DEFAULT_PAGE);
        }
        if (!hasRights) {
            UserDB.Entry userentry = sb.userDB.proxyAuth(header);
            if (userentry != null && userentry.hasRight(UserDB.AccessRight.BLOG_RIGHT)) {
                hasRights = true;
            } else if (post.containsKey("login")) {
                prop.authenticationRequired();
            }
        }
        String pagename = post.get("page", DEFAULT_PAGE);
        String ip = post.get("CLIENTIP", "localhost");
        String strAuthor = post.get("author", "anonymous");
        if ("anonymous".equals(strAuthor) && ((strAuthor = sb.blogDB.guessAuthor(ip)) == null || strAuthor.isEmpty())) {
            strAuthor = sb.peers.mySeed() == null ? "anonymous" : sb.peers.mySeed().get("Name", "anonymous");
        }
        byte[] author = UTF8.getBytes(strAuthor);
        BlogBoard.BlogEntry page = sb.blogDB.readBlogEntry(pagename);
        boolean pageExists = sb.blogDB.contains(pagename);
        prop.put("mode_allow", page.getCommentMode() == 0 ? 0L : 1L);
        if (post.containsKey("submit") && page.getCommentMode() != 0 && pageExists && !"".equals(post.get("content", ""))) {
            if ("".equals(post.get("subject", ""))) {
                post.putHTML("subject", "no title");
            }
            byte[] content = UTF8.getBytes(post.get("content", ""));
            Date date = null;
            String StrSubject = post.get("subject", "");
            byte[] subject = UTF8.getBytes(StrSubject);
            String commentID = String.valueOf(System.currentTimeMillis());
            BlogBoard.BlogEntry blogEntry = sb.blogDB.readBlogEntry(pagename);
            blogEntry.addComment(commentID);
            sb.blogDB.writeBlogEntry(blogEntry);
            sb.blogCommentDB.write(sb.blogCommentDB.newEntry(commentID, subject, author, ip, date, content));
            prop.putHTML("LOCATION", "BlogComments.html?page=" + pagename);
            MessageBoard.entry msgEntry = sb.messageDB.newEntry("blogComment", strAuthor, sb.peers.mySeed().hash, sb.peers.mySeed().getName(), sb.peers.mySeed().hash, "new blog comment: " + UTF8.String(blogEntry.getSubject()), content);
            sb.messageDB.write(msgEntry);
            BlogComments.messageForwardingViaEmail(sb, msgEntry);
            File notifierSource = new File(sb.getAppPath(), sb.getConfig("htRootPath", "htroot") + "/env/grafics/message.gif");
            File notifierDest = new File(sb.getDataPath("htDocsPath", "DATA/HTDOCS"), "notifier.gif");
            try {
                Files.copy((File)notifierSource, (File)notifierDest);
            }
            catch (IOException e) {
                ConcurrentLog.severe("MESSAGE", "NEW MESSAGE ARRIVED! (error: " + e.getMessage() + ")");
            }
        }
        if (hasRights && post.containsKey("delete") && post.containsKey("page") && post.containsKey("comment") && page.removeComment(post.get("comment"))) {
            sb.blogCommentDB.delete(post.get("comment"));
        }
        if (hasRights && post.containsKey("allow") && post.containsKey("page") && post.containsKey("comment")) {
            BlogBoardComments.CommentEntry entry2 = sb.blogCommentDB.read(post.get("comment"));
            entry2.allow();
            sb.blogCommentDB.write(entry2);
        }
        if (post.containsKey("preview") && page.getCommentMode() != 0) {
            prop.put("mode", "1");
            prop.putHTML("mode_pageid", pagename);
            prop.putHTML("mode_allow_pageid", pagename);
            prop.putHTML("mode_author", UTF8.String(author));
            prop.putHTML("mode_allow_author", UTF8.String(author));
            prop.putHTML("mode_subject", post.get("subject", ""));
            prop.put("mode_date", BlogComments.dateString(new Date()));
            prop.putWiki("mode_page", post.get("content", ""));
            prop.put("mode_page-code", post.get("content", ""));
        } else {
            prop.put("mode", "0");
            if (DEFAULT_PAGE.equals(pagename)) {
                prop.put("LOCATION", "Blog.html");
            } else {
                prop.put("mode_pageid", page.getKey());
                prop.putHTML("mode_allow_pageid", pagename);
                prop.putHTML("mode_subject", UTF8.String(page.getSubject()));
                prop.putHTML("mode_author", UTF8.String(page.getAuthor()));
                prop.putHTML("mode_allow_author", UTF8.String(author));
                prop.put("mode_comments", page.getCommentsSize());
                prop.put("mode_date", BlogComments.dateString(page.getDate()));
                prop.putWiki("mode_page", page.getPage());
                if (hasRights) {
                    prop.put("mode_admin", "1");
                    prop.put("mode_admin_pageid", page.getKey());
                }
                Iterator<String> i = page.getComments().iterator();
                int commentMode = page.getCommentMode();
                boolean xml = post.containsKey("xml");
                int count = 0;
                int start = post.getInt("start", 0);
                int num = post.getInt("num", 10);
                if (xml) {
                    num = 0;
                }
                if (start < 0) {
                    start = 0;
                }
                int nextstart = start + num;
                int prevstart = start - num;
                while (i.hasNext() && count < num) {
                    String pageid = i.next();
                    if (start > 0) {
                        --start;
                        continue;
                    }
                    BlogBoardComments.CommentEntry entry3 = sb.blogCommentDB.read(pageid);
                    if (commentMode == 2 && !hasRights && !entry3.isAllowed()) continue;
                    prop.put("mode", "0");
                    prop.put("mode_entries_" + count + "_pageid", entry3.getKey());
                    if (!xml) {
                        prop.putHTML("mode_entries_" + count + "_subject", UTF8.String(entry3.getSubject()));
                        prop.putHTML("mode_entries_" + count + "_author", UTF8.String(entry3.getAuthor()));
                        prop.putWiki("mode_entries_" + count + "_page", entry3.getPage());
                    } else {
                        prop.putHTML("mode_entries_" + count + "_subject", UTF8.String(entry3.getSubject()));
                        prop.putHTML("mode_entries_" + count + "_author", UTF8.String(entry3.getAuthor()));
                        prop.put("mode_entries_" + count + "_page", entry3.getPage());
                        prop.put("mode_entries_" + count + "_timestamp", entry3.getTimestamp());
                    }
                    prop.put("mode_entries_" + count + "_date", BlogComments.dateString(entry3.getDate()));
                    prop.put("mode_entries_" + count + "_ip", entry3.getIp());
                    if (hasRights) {
                        prop.put("mode_entries_" + count + "_admin", "1");
                        prop.put("mode_entries_" + count + "_admin_pageid", page.getKey());
                        prop.put("mode_entries_" + count + "_admin_commentid", pageid);
                        if (page.getCommentMode() == 2 && !entry3.isAllowed()) {
                            prop.put("mode_entries_" + count + "_admin_moderate", "1");
                            prop.put("mode_entries_" + count + "_admin_moderate_pageid", page.getKey());
                            prop.put("mode_entries_" + count + "_admin_moderate_commentid", pageid);
                        }
                    } else {
                        prop.put("mode_entries_" + count + "_admin", 0L);
                    }
                    ++count;
                }
                prop.put("mode_entries", count);
                if (i.hasNext()) {
                    prop.put("mode_moreentries", "1");
                    prop.put("mode_moreentries_start", nextstart);
                    prop.put("mode_moreentries_num", num);
                    prop.put("mode_moreentries_pageid", page.getKey());
                } else {
                    prop.put("mode_moreentries", "0");
                }
                if (start > 1) {
                    prop.put("mode_preventries", "1");
                    if (prevstart < 0) {
                        prevstart = 0;
                    }
                    prop.put("mode_preventries_start", prevstart);
                    prop.put("mode_preventries_num", num);
                    prop.put("mode_preventries_pageid", page.getKey());
                } else {
                    prop.put("mode_preventries", "0");
                }
            }
        }
        return prop;
    }

    private static void messageForwardingViaEmail(Switchboard sb, MessageBoard.entry msgEntry) {
        try {
            if (!sb.getConfigBool("msgForwardingEnabled", false)) {
                return;
            }
            String sendMailTo = sb.getConfig("msgForwardingTo", "root@localhost").trim();
            String sendMailStr = sb.getConfig("msgForwardingCmd", "/usr/bin/sendmail") + " " + sendMailTo;
            String[] sendMail = CommonPattern.SPACE.split(sendMailStr.trim());
            StringBuilder emailTxt = new StringBuilder();
            emailTxt.append("To: ").append(sendMailTo).append("\nFrom: ").append("yacy@").append(sb.peers.mySeed().getName()).append("\nSubject: [YaCy] ").append(msgEntry.subject().replace('\n', ' ')).append("\nDate: ").append(msgEntry.date()).append("\n").append("\nMessage from: ").append(msgEntry.author()).append("/").append(msgEntry.authorHash()).append("\nMessage to:   ").append(msgEntry.recipient()).append("/").append(msgEntry.recipientHash()).append("\nCategory:     ").append(msgEntry.category()).append("\n===================================================================\n").append(UTF8.String(msgEntry.message()));
            Process process = Runtime.getRuntime().exec(sendMail);
            PrintWriter email = new PrintWriter(process.getOutputStream());
            email.print(new String(emailTxt));
            email.close();
        }
        catch (Exception e) {
            Network.log.warn("message: message forwarding via email failed. ", e);
        }
    }
}

