/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser.images;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.lang.GeoLocation;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.GpsDirectory;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.imageio.ImageIO;
import net.yacy.cora.document.id.AnchorURL;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.document.AbstractParser;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.VocabularyScraper;
import net.yacy.document.parser.html.ImageEntry;
import net.yacy.kelondro.util.FileUtils;

public class genericImageParser
extends AbstractParser
implements Parser {
    public genericImageParser() {
        super("Generic Image Parser");
        this.SUPPORTED_EXTENSIONS.add("jpe");
        this.SUPPORTED_MIME_TYPES.add("image/jpg");
        try {
            this.SUPPORTED_EXTENSIONS.addAll(Arrays.asList(ImageIO.getReaderFileSuffixes()));
            this.SUPPORTED_MIME_TYPES.addAll(Arrays.asList(ImageIO.getReaderMIMETypes()));
        }
        catch (NoSuchMethodError e) {
            ConcurrentLog.logException(e);
        }
    }

    @Override
    public Document[] parse(DigestURL location, String mimeType, String charset, VocabularyScraper scraper, int timezoneOffset, InputStream source) throws Parser.Failure, InterruptedException {
        ImageInfo ii = null;
        String title = null;
        String author = null;
        String keywords = null;
        ArrayList<String> descriptions = new ArrayList<String>();
        String filename = location.getFileName();
        String ext = MultiProtocolURL.getFileExtension(filename);
        double gpslat = 0.0;
        double gpslon = 0.0;
        if (mimeType.equals("image/jpeg") || ext.equals("jpg") || ext.equals("jpeg") || ext.equals("jpe")) {
            byte[] b;
            try {
                b = FileUtils.read(source);
                if (b.length < 3 || b[0] != -1 || b[1] != -40 || b[2] != -1) {
                    throw new Parser.Failure("File has no jpeg signature", location);
                }
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
                throw new Parser.Failure(e.getMessage(), location);
            }
            ii = this.parseJavaImage(location, new ByteArrayInputStream(b));
            try {
                String description;
                Metadata metadata = JpegMetadataReader.readMetadata((InputStream)new ByteArrayInputStream(b));
                Iterator directories = metadata.getDirectories().iterator();
                HashMap<String, String> props = new HashMap<String, String>();
                while (directories.hasNext()) {
                    Directory directory = (Directory)directories.next();
                    if (directory instanceof GpsDirectory) {
                        GeoLocation geoloc = ((GpsDirectory)directory).getGeoLocation();
                        if (geoloc == null) continue;
                        gpslat = geoloc.getLatitude();
                        gpslon = geoloc.getLongitude();
                        continue;
                    }
                    for (Tag tag : directory.getTags()) {
                        if (tag.getTagName().startsWith("Unknown")) continue;
                        props.put(tag.getTagName(), tag.getDescription());
                        ii.info.append(tag.getTagName() + ": " + tag.getDescription() + " .\n");
                    }
                }
                title = (String)props.get("Image Description");
                if (title == null || title.isEmpty()) {
                    title = (String)props.get("Headline");
                }
                if (title == null || title.isEmpty()) {
                    title = (String)props.get("Object Name");
                }
                if ((author = (String)props.get("Artist")) == null || author.isEmpty()) {
                    author = (String)props.get("Writer/Editor");
                }
                if (author == null || author.isEmpty()) {
                    author = (String)props.get("By-line");
                }
                if (author == null || author.isEmpty()) {
                    author = (String)props.get("Credit");
                }
                if (author == null || author.isEmpty()) {
                    author = (String)props.get("Make");
                }
                if ((keywords = (String)props.get("Keywords")) == null || keywords.isEmpty()) {
                    keywords = (String)props.get("Category");
                }
                if (keywords == null || keywords.isEmpty()) {
                    keywords = (String)props.get("Supplemental Category(s)");
                }
                if ((description = (String)props.get("Caption/Abstract")) != null && description.length() > 0) {
                    descriptions.add("Abstract: " + description);
                }
                if ((description = (String)props.get("Country/Primary Location")) != null && description.length() > 0) {
                    descriptions.add("Location: " + description);
                }
                if ((description = (String)props.get("Province/State")) != null && description.length() > 0) {
                    descriptions.add("State: " + description);
                }
                if ((description = (String)props.get("Copyright Notice")) != null && description.length() > 0) {
                    descriptions.add("Copyright: " + description);
                }
            }
            catch (Throwable metadata) {}
        } else {
            ii = this.parseJavaImage(location, source);
        }
        HashSet<String> languages = new HashSet<String>();
        LinkedHashMap<DigestURL, ImageEntry> images = new LinkedHashMap<DigestURL, ImageEntry>();
        String infoString = ii.info.toString();
        images.put(ii.location, new ImageEntry(ii.location, "", ii.width, ii.height, -1L));
        if (title == null || title.isEmpty()) {
            title = MultiProtocolURL.unescape(filename);
        }
        return new Document[]{new Document(location, mimeType, StandardCharsets.UTF_8.name(), this, languages, keywords == null ? new String[]{} : keywords.split(keywords.indexOf(44) > 0 ? "," : " "), genericImageParser.singleList(title), author == null ? "" : author, location.getHost(), new String[0], descriptions, gpslon, gpslat, infoString, null, null, images, false, new Date())};
    }

    @Override
    public Set<String> supportedMimeTypes() {
        return this.SUPPORTED_MIME_TYPES;
    }

    @Override
    public Set<String> supportedExtensions() {
        return this.SUPPORTED_EXTENSIONS;
    }

    private ImageInfo parseJavaImage(DigestURL location, InputStream sourceStream) throws Parser.Failure {
        BufferedImage image = null;
        try {
            ImageIO.setUseCache(false);
            image = ImageIO.read(sourceStream);
        }
        catch (Throwable e) {
            throw new Parser.Failure(e.getMessage(), location);
        }
        if (image == null) {
            throw new Parser.Failure("ImageIO returned NULL", location);
        }
        return this.parseJavaImage(location, image);
    }

    private ImageInfo parseJavaImage(DigestURL location, BufferedImage image) {
        ImageInfo ii = new ImageInfo(location);
        ii.image = image;
        ii.height = ii.image.getHeight();
        ii.width = ii.image.getWidth();
        String[] propNames = ii.image.getPropertyNames();
        if (propNames == null) {
            propNames = new String[]{};
        }
        ii.info.append("\n");
        for (String propName : propNames) {
            ii.info.append(propName).append(" = ").append(ii.image.getProperty(propName)).append(" .\n");
        }
        ii.info.append("width").append(": ").append(Integer.toString(ii.width)).append(" .\n");
        ii.info.append("height").append(": ").append(Integer.toString(ii.height)).append(" .\n");
        return ii;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String[] names = ImageIO.getReaderFileSuffixes();
        System.out.print("supported file extension:");
        for (int i = 0; i < names.length; ++i) {
            System.out.print(" " + names[i]);
        }
        System.out.println();
        String[] mime = ImageIO.getReaderMIMETypes();
        System.out.print("supported mime types:    ");
        for (int i = 0; i < mime.length; ++i) {
            System.out.print(" " + mime[i]);
        }
        System.out.println();
        File image = new File(args[0]);
        genericImageParser parser = new genericImageParser();
        FileInputStream inStream = null;
        try {
            AnchorURL uri = new AnchorURL("http://localhost/" + image.getName());
            inStream = new FileInputStream(image);
            Document[] document = parser.parse(uri, "image/" + MultiProtocolURL.getFileExtension(uri.getFileName()), StandardCharsets.UTF_8.name(), new VocabularyScraper(), 0, inStream);
            System.out.println(document[0].toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (Parser.Failure e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ConcurrentLog.shutdown();
        }
    }

    private class ImageInfo {
        public DigestURL location;
        public BufferedImage image;
        public StringBuilder info;
        public int height;
        public int width;

        public ImageInfo(DigestURL location) {
            this.location = location;
            this.image = null;
            this.info = new StringBuilder();
            this.height = -1;
            this.width = -1;
        }
    }
}

