/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.importer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.GZIPInputStream;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.AnchorURL;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.http.HTTPClient;
import net.yacy.cora.util.ByteBuffer;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.NumberTools;
import net.yacy.data.wiki.WikiCode;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.TextParser;
import net.yacy.document.VocabularyScraper;
import net.yacy.document.importer.Importer;
import net.yacy.document.parser.html.TagValency;
import net.yacy.kelondro.util.NamePrefixThreadFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

public class MediawikiImporter
extends Thread
implements Importer {
    private static final String textstart = "<text";
    private static final String textend = "</text>";
    private static final String pagestart = "<page>";
    private static final String pageend = "</page>";
    private static final byte[] pagestartb = UTF8.getBytes("<page>");
    private static final byte[] pageendb = UTF8.getBytes("</page>");
    private static final int docspermbinxmlbz2 = 800;
    public static Importer job;
    public MultiProtocolURL sourcefile;
    public File targetdir;
    public int count;
    private long start;
    private final long docsize;
    private final int approxdocs;
    private String hostport;
    private String urlStub;
    private String errorMessage;

    public MediawikiImporter(MultiProtocolURL sourcefile, File targetdir) {
        super("MediawikiImporter(" + String.valueOf(sourcefile) != null ? sourcefile.toNormalform(true) : "null sourcefile)");
        this.sourcefile = sourcefile;
        this.docsize = sourcefile.length();
        this.approxdocs = (int)(this.docsize * 800L / 1024L / 1024L);
        this.targetdir = targetdir;
        this.count = 0;
        this.start = 0L;
        this.hostport = null;
        this.urlStub = null;
        this.errorMessage = null;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public String source() {
        return this.sourcefile.toNormalform(true);
    }

    @Override
    public String status() {
        return this.errorMessage != null ? this.errorMessage : "";
    }

    @Override
    public int speed() {
        if (this.count == 0) {
            return 0;
        }
        return (int)((long)this.count / Math.max(1L, this.runningTime()));
    }

    @Override
    public long remainingTime() {
        return Math.max(0, this.approxdocs - this.count) / Math.max(1, this.speed());
    }

    @Override
    public long runningTime() {
        return (System.currentTimeMillis() - this.start) / 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        BufferedReader reader;
        wikiparserrecord poison;
        ArrayBlockingQueue<wikiparserrecord> out;
        block46: {
            this.start = System.currentTimeMillis();
            int threads = Math.max(2, Runtime.getRuntime().availableProcessors() - 1);
            out = new ArrayBlockingQueue<wikiparserrecord>(threads * 10);
            poison = this.newRecord();
            reader = null;
            try {
                String t;
                String targetstub = this.sourcefile.getFileName();
                int p = targetstub.lastIndexOf("\\.");
                if (p > 0) {
                    targetstub = targetstub.substring(0, p);
                }
                FilterInputStream is = new BufferedInputStream(this.sourcefile.getInputStream(ClientIdentification.yacyInternetCrawlerAgent), 0x100000);
                if (this.sourcefile.getFileName().endsWith(".bz2")) {
                    is = new BZip2CompressorInputStream((InputStream)is);
                } else if (this.sourcefile.getFileName().endsWith(".gz")) {
                    is = new GZIPInputStream(is);
                }
                reader = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8), 0x400000);
                StringBuilder sb = new StringBuilder();
                boolean page = false;
                boolean text = false;
                String title = null;
                ArrayBlockingQueue<wikiparserrecord> in = new ArrayBlockingQueue<wikiparserrecord>(threads * 10);
                ExecutorService service = Executors.newCachedThreadPool(new NamePrefixThreadFactory(MediawikiImporter.class.getSimpleName() + ".convertConsumer"));
                convertConsumer[] consumers = new convertConsumer[threads];
                Future[] consumerResults = (Future[])Array.newInstance(Future.class, threads);
                for (int i = 0; i < threads; ++i) {
                    consumers[i] = new convertConsumer(in, out, poison);
                    consumerResults[i] = service.submit(consumers[i]);
                }
                convertWriter writer = new convertWriter(out, poison, this.targetdir, targetstub);
                Future<Integer> writerResult = service.submit(writer);
                while ((t = reader.readLine()) != null) {
                    wikiparserrecord record;
                    int q;
                    p = t.indexOf("<base>", 0);
                    if (p >= 0 && (q = t.indexOf("</base>", p)) > 0) {
                        this.urlStub = t.substring(p + 6, q);
                        if (!this.urlStub.endsWith("/") && (q = this.urlStub.lastIndexOf(47)) > 0) {
                            this.urlStub = this.urlStub.substring(0, q + 1);
                        }
                        DigestURL uri = new DigestURL(this.urlStub);
                        this.hostport = uri.getHost();
                        if (uri.getPort() == 80) continue;
                        this.hostport = this.hostport + ":" + uri.getPort();
                        continue;
                    }
                    if (t.indexOf(pagestart) >= 0) {
                        page = true;
                        continue;
                    }
                    p = t.indexOf(textstart);
                    if (p >= 0) {
                        text = page;
                        q = t.indexOf(62, p + textstart.length());
                        if (q <= 0) continue;
                        int u = t.indexOf(textend, q + 1);
                        if (u > q) {
                            sb.append(t.substring(q + 1, u));
                            ConcurrentLog.info("WIKITRANSLATION", "[INJECT] Title: " + title);
                            if (sb.length() == 0) {
                                ConcurrentLog.info("WIKITRANSLATION", "ERROR: " + title + " has empty content");
                                continue;
                            }
                            record = this.newRecord(this.hostport, this.urlStub, title, sb);
                            try {
                                in.put(record);
                                ++this.count;
                            }
                            catch (InterruptedException e1) {
                                ConcurrentLog.logException(e1);
                            }
                            sb = new StringBuilder(200);
                            continue;
                        }
                        sb.append(t.substring(q + 1));
                        continue;
                    }
                    if (t.indexOf(textend) >= 0) {
                        text = false;
                        ConcurrentLog.info("WIKITRANSLATION", "[INJECT] Title: " + title);
                        if (sb.length() == 0) {
                            ConcurrentLog.info("WIKITRANSLATION", "ERROR: " + title + " has empty content");
                            continue;
                        }
                        record = this.newRecord(this.hostport, this.urlStub, title, sb);
                        try {
                            in.put(record);
                            ++this.count;
                        }
                        catch (InterruptedException e1) {
                            ConcurrentLog.logException(e1);
                        }
                        sb = new StringBuilder(200);
                        continue;
                    }
                    if (t.indexOf(pageend) >= 0) {
                        page = false;
                        continue;
                    }
                    p = t.indexOf("<title>", 0);
                    if (p >= 0) {
                        title = t.substring(p + 7);
                        q = title.indexOf("</title>", 0);
                        if (q < 0) continue;
                        title = title.substring(0, q);
                        continue;
                    }
                    if (!text) continue;
                    sb.append(t);
                    sb.append('\n');
                }
                try {
                    int i;
                    for (i = 0; i < threads; ++i) {
                        in.put(poison);
                    }
                    for (i = 0; i < threads; ++i) {
                        consumerResults[i].get(10000L, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Exception e) {
                    this.errorMessage = e.getMessage();
                    ConcurrentLog.logException(e);
                }
                finally {
                    out.put(poison);
                    writerResult.get(10000L, TimeUnit.MILLISECONDS);
                }
                if (reader == null) break block46;
            }
            catch (Exception e) {
                this.errorMessage = e.getMessage();
                ConcurrentLog.logException(e);
                return;
            }
            try {
                reader.close();
            }
            catch (IOException e) {
                ConcurrentLog.warn("WIKITRANSLATION", "Could not close dump reader : " + e.getMessage());
            }
        }
        try {
            out.put(poison);
            return;
        }
        catch (InterruptedException e) {
            return;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    ConcurrentLog.warn("WIKITRANSLATION", "Could not close dump reader : " + e.getMessage());
                }
            }
            try {
                out.put(poison);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void checkIndex(File mediawikixml) {
        File idx2 = MediawikiImporter.idxFromMediawikiXML(mediawikixml);
        if (idx2.exists()) {
            return;
        }
        new indexMaker(mediawikixml).start();
    }

    public static File idxFromMediawikiXML(File mediawikixml) {
        return new File(mediawikixml.getAbsolutePath() + ".idx.xml");
    }

    public static void createIndex(File dumpFile) throws IOException {
        PositionAwareReader in = new PositionAwareReader(dumpFile);
        indexProducer producer = new indexProducer(100, MediawikiImporter.idxFromMediawikiXML(dumpFile));
        wikiConsumer consumer = new wikiConsumer(100, producer);
        ExecutorService service = Executors.newCachedThreadPool(new NamePrefixThreadFactory(MediawikiImporter.class.getSimpleName() + ".createIndex"));
        Future<Integer> producerResult = service.submit(consumer);
        Future<Integer> consumerResult = service.submit(producer);
        service.shutdown();
        while (in.seek(pagestartb)) {
            long start = in.pos() - 6L;
            in.resetBuffer();
            if (!in.seek(pageendb)) break;
            long stop = in.pos();
            consumer.consume(new wikiraw(in.bytes(), start, stop));
            in.resetBuffer();
        }
        try {
            consumer.consume(wikiConsumer.poison);
            try {
                consumerResult.get(5000L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            producer.consume(indexProducer.poison);
            if (!consumerResult.isDone()) {
                consumerResult.get();
            }
            producerResult.get();
        }
        catch (InterruptedException e) {
            ConcurrentLog.logException(e);
            return;
        }
        catch (ExecutionException e) {
            ConcurrentLog.logException(e);
            return;
        }
        in.close();
    }

    public wikiparserrecord newRecord() {
        return new wikiparserrecord(null, null, null, null);
    }

    public wikiparserrecord newRecord(String hostport, String urlStub, String title, StringBuilder sb) {
        return new wikiparserrecord(hostport, urlStub, title, sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(File f, long start, int len) {
        byte[] b = new byte[len];
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(f, "r");
            raf.seek(start);
            raf.read(b);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                    try {
                        raf.getChannel().close();
                    }
                    catch (IOException iOException) {}
                }
                catch (IOException iOException) {}
            }
        }
        return b;
    }

    public static wikisourcerecord find(String title, File f) throws IOException {
        PositionAwareReader in = new PositionAwareReader(f);
        String m = "<title>" + title + "</title>";
        while (in.seek(UTF8.getBytes("<page "))) {
            long start = in.pos() - 6L;
            in.resetBuffer();
            if (!in.seek(pageendb)) break;
            String s = UTF8.String(in.bytes());
            in.resetBuffer();
            if (s.indexOf(m) < 0) continue;
            int p = s.indexOf("start=\"", 0);
            if (p < 0) {
                return null;
            }
            int q = s.indexOf(34, (p += 7) + 1);
            if (q < 0) {
                return null;
            }
            start = NumberTools.parseLongDecSubstring(s, p, q);
            p = s.indexOf("length=\"", q);
            if (p < 0) {
                return null;
            }
            q = s.indexOf(34, (p += 8) + 1);
            if (q < 0) {
                return null;
            }
            int length = NumberTools.parseIntDecSubstring(s, p, q);
            return new wikisourcerecord(title, start, start + (long)length);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] s) {
        block23: {
            if (s.length == 0) {
                System.out.println("usage:");
                System.out.println(" -index <wikipedia-dump>");
                System.out.println(" -read  <start> <len> <idx-file>");
                System.out.println(" -find  <title> <wikipedia-dump>");
                System.out.println(" -convert <wikipedia-dump-xml.bz2> <convert-target-dir>");
                ConcurrentLog.shutdown();
                return;
            }
            try {
                if (s[0].equals("-convert")) {
                    if (s.length < 3) {
                        System.out.println("usage:");
                        System.out.println(" -convert <wikipedia-dump-xml.bz2> <convert-target-dir>");
                        ConcurrentLog.shutdown();
                        return;
                    }
                    File targetdir = new File(s[2]);
                    try {
                        MediawikiImporter mi = new MediawikiImporter(new MultiProtocolURL(s[1]), targetdir);
                        mi.start();
                        mi.join();
                    }
                    catch (InterruptedException e) {
                        ConcurrentLog.logException(e);
                    }
                    catch (MalformedURLException e) {
                        ConcurrentLog.logException(e);
                    }
                }
                if (s[0].equals("-index")) {
                    try {
                        MediawikiImporter.createIndex(new File(s[1]));
                    }
                    catch (IOException e) {
                        ConcurrentLog.logException(e);
                    }
                }
                if (s[0].equals("-read")) {
                    long start = Integer.parseInt(s[1]);
                    int len = Integer.parseInt(s[2]);
                    System.out.println(UTF8.String(MediawikiImporter.read(new File(s[3]), start, len)));
                }
                if (!s[0].equals("-find")) break block23;
                try {
                    wikisourcerecord w = MediawikiImporter.find(s[1], new File(s[2] + ".idx.xml"));
                    if (w == null) {
                        ConcurrentLog.info("WIKITRANSLATION", "not found");
                        break block23;
                    }
                    System.out.println(UTF8.String(MediawikiImporter.read(new File(s[2]), w.start, (int)(w.end - w.start))));
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
            finally {
                try {
                    HTTPClient.closeConnectionManager();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ConcurrentLog.shutdown();
            }
        }
    }

    public class wikiparserrecord {
        public String title;
        String source;
        String html;
        String hostport;
        String urlStub;
        AnchorURL url;
        Document document;

        public wikiparserrecord(String hostport, String urlStub, String title, StringBuilder sb) {
            this.title = title;
            this.hostport = hostport;
            this.urlStub = urlStub;
            this.source = sb == null ? null : sb.toString();
        }

        public void genHTML() throws IOException {
            try {
                WikiCode wparser = new WikiCode();
                this.html = wparser.transform(this.hostport, this.source);
            }
            catch (Exception e) {
                ConcurrentLog.logException(e);
                throw new IOException(e.getMessage());
            }
        }

        public void genDocument() throws Parser.Failure {
            try {
                this.url = new AnchorURL(this.urlStub + this.title);
                Document[] parsed = TextParser.parseSource((DigestURL)this.url, "text/html", StandardCharsets.UTF_8.name(), TagValency.EVAL, new HashSet<String>(), new VocabularyScraper(), 0, 1, UTF8.getBytes(this.html), null);
                this.document = Document.mergeDocuments(this.url, "text/html", parsed);
                this.document.setTitle(this.title);
            }
            catch (MalformedURLException e1) {
                ConcurrentLog.logException(e1);
            }
        }

        public void writeXML(OutputStreamWriter os) throws IOException {
            this.document.writeXML(os);
        }
    }

    private static class convertConsumer
    implements Callable<Integer> {
        private final BlockingQueue<wikiparserrecord> in;
        private final BlockingQueue<wikiparserrecord> out;
        private final wikiparserrecord poison;

        public convertConsumer(BlockingQueue<wikiparserrecord> in, BlockingQueue<wikiparserrecord> out, wikiparserrecord poison) {
            this.poison = poison;
            this.in = in;
            this.out = out;
        }

        @Override
        public Integer call() {
            try {
                while (true) {
                    wikiparserrecord record;
                    if ((record = this.in.take()) == this.poison) {
                        ConcurrentLog.info("WIKITRANSLATION", "convertConsumer / got poison");
                        break;
                    }
                    try {
                        record.genHTML();
                        record.genDocument();
                        this.out.put(record);
                    }
                    catch (RuntimeException e) {
                        ConcurrentLog.logException(e);
                    }
                    catch (Parser.Failure e) {
                        ConcurrentLog.logException(e);
                    }
                    catch (IOException e) {
                        ConcurrentLog.logException(e);
                    }
                }
            }
            catch (InterruptedException e) {
                ConcurrentLog.logException(e);
            }
            ConcurrentLog.info("WIKITRANSLATION", "*** convertConsumer has terminated");
            return 0;
        }
    }

    private static class convertWriter
    implements Callable<Integer> {
        private final BlockingQueue<wikiparserrecord> in;
        private final wikiparserrecord poison;
        private OutputStreamWriter osw;
        private final String targetstub;
        private final File targetdir;
        private int fc;
        private int rc;
        private String outputfilename;

        public convertWriter(BlockingQueue<wikiparserrecord> in, wikiparserrecord poison, File targetdir, String targetstub) {
            this.poison = poison;
            this.in = in;
            this.osw = null;
            this.targetdir = targetdir;
            this.targetstub = targetstub;
            this.fc = 0;
            this.rc = 0;
            this.outputfilename = null;
        }

        @Override
        public Integer call() {
            try {
                while (true) {
                    wikiparserrecord record;
                    if ((record = this.in.take()) == this.poison) {
                        ConcurrentLog.info("WIKITRANSLATION", "convertConsumer / got poison");
                        break;
                    }
                    if (this.osw == null) {
                        this.outputfilename = this.targetstub + "." + this.fc + ".xml.prt";
                        this.osw = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(new File(this.targetdir, this.outputfilename))), StandardCharsets.UTF_8);
                        this.osw.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<surrogates xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:yacy=\"http://yacy.net/\" xmlns:geo=\"http://www.w3.org/2003/01/geo/wgs84_pos#\">\n");
                    }
                    ConcurrentLog.info("WIKITRANSLATION", "[CONSUME] Title: " + record.title);
                    record.document.writeXML(this.osw);
                    ++this.rc;
                    if (this.rc < 10000) continue;
                    this.osw.write("</surrogates>\n");
                    this.osw.close();
                    CallSite finalfilename = this.targetstub + "." + this.fc + ".xml";
                    new File(this.targetdir, this.outputfilename).renameTo(new File(this.targetdir, (String)((Object)finalfilename)));
                    this.rc = 0;
                    ++this.fc;
                    this.outputfilename = this.targetstub + "." + this.fc + ".xml.prt";
                    this.osw = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(new File(this.targetdir, this.outputfilename))), StandardCharsets.UTF_8);
                    this.osw.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<surrogates xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:yacy=\"http://yacy.net/\" xmlns:geo=\"http://www.w3.org/2003/01/geo/wgs84_pos#\">\n");
                }
            }
            catch (InterruptedException e) {
                ConcurrentLog.logException(e);
            }
            catch (UnsupportedEncodingException e) {
                ConcurrentLog.logException(e);
            }
            catch (FileNotFoundException e) {
                ConcurrentLog.logException(e);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
            finally {
                try {
                    if (this.osw != null) {
                        this.osw.write("</surrogates>\n");
                        this.osw.close();
                        String finalfilename = this.targetstub + "." + this.fc + ".xml";
                        new File(this.targetdir, this.outputfilename).renameTo(new File(this.targetdir, finalfilename));
                    }
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
            ConcurrentLog.info("WIKITRANSLATION", "*** convertWriter has terminated");
            return 0;
        }
    }

    public static class indexMaker
    extends Thread {
        File mediawikixml;

        public indexMaker(File mediawikixml) {
            super("MediawikiImporter.indexMaker " + String.valueOf(mediawikixml) != null ? mediawikixml.getName() : "");
            this.mediawikixml = mediawikixml;
        }

        @Override
        public void run() {
            try {
                MediawikiImporter.createIndex(this.mediawikixml);
            }
            catch (IOException iOException) {
            }
            catch (Exception e) {
                ConcurrentLog.logException(e);
            }
        }
    }

    private static class PositionAwareReader {
        private final InputStream is;
        private long seekpos;
        private ByteBuffer bb;

        public PositionAwareReader(File dumpFile) throws FileNotFoundException {
            this.is = new BufferedInputStream(new FileInputStream(dumpFile), 65536);
            this.seekpos = 0L;
            this.bb = new ByteBuffer();
        }

        public void resetBuffer() {
            if (this.bb.length() > 10240) {
                this.bb = new ByteBuffer();
            } else {
                this.bb.clear();
            }
        }

        public boolean seek(byte[] pattern) throws IOException {
            int c;
            int pp = 0;
            while ((c = this.is.read()) >= 0) {
                ++this.seekpos;
                this.bb.append(c);
                pp = pattern[pp] == c ? ++pp : 0;
                if (pp != pattern.length) continue;
                return true;
            }
            return false;
        }

        public long pos() {
            return this.seekpos;
        }

        public byte[] bytes() {
            return this.bb.getBytes();
        }

        public synchronized void close() {
            try {
                this.is.close();
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
    }

    private static class indexProducer
    implements Callable<Integer> {
        private final BlockingQueue<wikisourcerecord> entries;
        PrintWriter out;
        protected static wikisourcerecord poison = new wikisourcerecord("", 0L, 0L);
        int count;

        public indexProducer(int bufferCount, File indexFile) throws IOException {
            this.entries = new ArrayBlockingQueue<wikisourcerecord>(bufferCount);
            this.out = new PrintWriter(new BufferedWriter(new FileWriter(indexFile)));
            this.count = 0;
            this.out.println("<index>");
        }

        public void consume(wikisourcerecord b) {
            try {
                this.entries.put(b);
            }
            catch (InterruptedException e) {
                ConcurrentLog.logException(e);
            }
        }

        @Override
        public Integer call() {
            try {
                while (true) {
                    wikisourcerecord r;
                    if ((r = this.entries.take()) == poison) {
                        ConcurrentLog.info("WIKITRANSLATION", "producer / got poison");
                        break;
                    }
                    this.out.println("  <page start=\"" + r.start + "\" length=\"" + (r.end - r.start) + "\">");
                    this.out.println("    <title>" + r.title + "</title>");
                    this.out.println("  </page>");
                    ConcurrentLog.info("WIKITRANSLATION", "producer / record start: " + r.start + ", title : " + r.title);
                    ++this.count;
                }
            }
            catch (InterruptedException e) {
                ConcurrentLog.logException(e);
            }
            this.entries.clear();
            this.out.println("</index>");
            this.out.close();
            return this.count;
        }
    }

    private static class wikiConsumer
    implements Callable<Integer> {
        private final BlockingQueue<wikiraw> entries;
        protected static wikiraw poison = new wikiraw(new byte[0], 0L, 0L);
        private final indexProducer producer;
        private int count;

        public wikiConsumer(int bufferCount, indexProducer producer) {
            this.entries = new ArrayBlockingQueue<wikiraw>(bufferCount);
            this.producer = producer;
            this.count = 0;
        }

        public void consume(wikiraw b) {
            try {
                this.entries.put(b);
            }
            catch (InterruptedException e) {
                ConcurrentLog.logException(e);
            }
        }

        @Override
        public Integer call() {
            try {
                while (true) {
                    wikiraw c;
                    if ((c = this.entries.take()) == poison) {
                        ConcurrentLog.info("WIKITRANSLATION", "consumer / got poison");
                        break;
                    }
                    try {
                        wikisourcerecord r = new wikisourcerecord(c.b, c.start, c.end);
                        this.producer.consume(r);
                        ConcurrentLog.info("WIKITRANSLATION", "consumer / record start: " + r.start + ", title : " + r.title);
                        ++this.count;
                    }
                    catch (RuntimeException runtimeException) {}
                }
            }
            catch (InterruptedException e) {
                ConcurrentLog.logException(e);
            }
            this.entries.clear();
            return this.count;
        }
    }

    private static class wikiraw {
        public long start;
        public long end;
        public byte[] b;

        public wikiraw(byte[] b, long start, long end) {
            this.b = b;
            this.start = start;
            this.end = end;
        }
    }

    public static class wikisourcerecord {
        public long start;
        public long end;
        public String title;

        public wikisourcerecord(String title, long start, long end) {
            this.title = title;
            this.start = start;
            this.end = end;
        }

        public wikisourcerecord(byte[] chunk, long start, long end) {
            int t1;
            String s = UTF8.String(chunk);
            int t0 = s.indexOf("<title>", 0);
            if (t0 >= 0) {
                t1 = s.indexOf("</title>", t0);
                if (t1 < 0) {
                    throw new RuntimeException("no title end in record");
                }
            } else {
                throw new RuntimeException("no title start in record");
            }
            this.title = s.substring(t0 + 7, t1);
            this.start = start;
            this.end = end;
        }
    }
}

