/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.yacy.cora.date.ISO8601Formatter;
import net.yacy.cora.document.analysis.Classification;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.AnchorURL;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.lod.vocabulary.Tagging;
import net.yacy.cora.util.ByteBuffer;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.retrieval.Request;
import net.yacy.document.LibraryProvider;
import net.yacy.document.Parser;
import net.yacy.document.SentenceReader;
import net.yacy.document.parser.html.ContentScraper;
import net.yacy.document.parser.html.IconEntry;
import net.yacy.document.parser.html.ImageEntry;
import net.yacy.kelondro.util.FileUtils;

public class Document {
    private DigestURL source;
    private final String mimeType;
    private final String charset;
    private final Set<String> keywords;
    private List<String> titles;
    private final StringBuilder creator;
    private final String publisher;
    private final List<String> sections;
    private final List<String> descriptions;
    private Object text;
    private final Collection<AnchorURL> anchors;
    private final LinkedHashMap<DigestURL, String> rss;
    private final LinkedHashMap<DigestURL, ImageEntry> images;
    private LinkedHashMap<AnchorURL, String> audiolinks;
    private LinkedHashMap<AnchorURL, String> videolinks;
    private LinkedHashMap<AnchorURL, String> applinks;
    private LinkedHashMap<AnchorURL, String> hyperlinks;
    private LinkedHashMap<DigestURL, String> inboundlinks;
    private LinkedHashMap<DigestURL, String> outboundlinks;
    private Map<DigestURL, IconEntry> icons;
    private Set<DigestURL> linkedDataTypes;
    private boolean resorted;
    private final Set<String> languages;
    private boolean indexingDenied;
    private final double lon;
    private final double lat;
    private final Parser parserObject;
    private Object scraperObject;
    private final Map<String, Set<String>> generic_facets;
    private final Date lastModified;
    private int crawldepth;
    private boolean partiallyParsed;
    public static final String CANONICAL_MARKER = "canonical";
    public static final String IFRAME_MARKER = "iframe";
    public static final String FRAME_MARKER = "frame";
    public static final String EMBED_MARKER = "embed";

    public Document(DigestURL location, String mimeType, String charset, Parser parserObject, Set<String> languages, String[] keywords, List<String> titles, String author, String publisher, String[] sections, List<String> abstrcts, double lon, double lat, Object text, Collection<AnchorURL> anchors, LinkedHashMap<DigestURL, String> rss, LinkedHashMap<DigestURL, ImageEntry> images, boolean indexingDenied, Date lastModified) {
        this.source = location;
        this.mimeType = mimeType == null ? "application/octet-stream" : mimeType;
        this.charset = charset;
        this.parserObject = parserObject;
        this.keywords = new LinkedHashSet<String>();
        if (keywords != null) {
            Collections.addAll(this.keywords, keywords);
        }
        this.titles = titles == null ? new ArrayList(1) : titles;
        this.creator = author == null ? new StringBuilder(0) : new StringBuilder(author);
        this.sections = new LinkedList<String>();
        if (sections != null) {
            Collections.addAll(this.sections, sections);
        }
        ArrayList arrayList = this.descriptions = abstrcts == null ? new ArrayList() : abstrcts;
        if (lat >= -90.0 && lat <= 90.0 && lon >= -180.0 && lon <= 180.0) {
            this.lon = lon;
            this.lat = lat;
        } else {
            this.lon = 0.0;
            this.lat = 0.0;
        }
        this.anchors = anchors == null ? new ArrayList(0) : anchors;
        this.rss = rss == null ? new LinkedHashMap(0) : rss;
        this.images = images == null ? new LinkedHashMap() : images;
        this.publisher = publisher;
        this.hyperlinks = null;
        this.audiolinks = null;
        this.videolinks = null;
        this.applinks = null;
        this.icons = new HashMap<DigestURL, IconEntry>();
        this.linkedDataTypes = new HashSet<DigestURL>();
        this.resorted = false;
        this.inboundlinks = null;
        this.outboundlinks = null;
        this.languages = languages;
        this.indexingDenied = indexingDenied;
        this.text = text == null ? "" : text;
        this.generic_facets = new HashMap<String, Set<String>>();
        this.lastModified = lastModified == null ? new Date() : lastModified;
        this.crawldepth = 999;
        this.scraperObject = null;
        this.partiallyParsed = false;
    }

    public Classification.ContentDomain getContentDomain() {
        Classification.ContentDomain contentDomain = Classification.getContentDomainFromMime(this.mimeType);
        if (contentDomain != Classification.ContentDomain.ALL) {
            return contentDomain;
        }
        return this.dc_source().getContentDomainFromExt();
    }

    public Parser getParserObject() {
        return this.parserObject;
    }

    public Object getScraperObject() {
        return this.scraperObject;
    }

    public void setScraperObject(Object scraper) {
        if (this.scraperObject != null) {
            if (this.scraperObject instanceof ContentScraper) {
                ((ContentScraper)this.scraperObject).close();
            }
            this.scraperObject = null;
        }
        this.scraperObject = scraper;
    }

    public AnchorURL getCanonical() {
        Object scraper = this.getScraperObject();
        if (!(scraper instanceof ContentScraper)) {
            return null;
        }
        ContentScraper html = (ContentScraper)scraper;
        AnchorURL canonical = html.getCanonical();
        return canonical;
    }

    public Set<String> getContentLanguages() {
        return this.languages;
    }

    public String getFileName() {
        return this.source.getFileName();
    }

    public Map<String, Set<String>> getGenericFacets() {
        return this.generic_facets;
    }

    public boolean isPartiallyParsed() {
        return this.partiallyParsed;
    }

    public void setPartiallyParsed(boolean partiallyParsed) {
        this.partiallyParsed = partiallyParsed;
    }

    public String dc_language() {
        if (this.languages == null) {
            return null;
        }
        if (this.languages.isEmpty()) {
            return null;
        }
        if (this.languages.size() == 1) {
            return this.languages.iterator().next();
        }
        if (this.languages.contains(this.source.language())) {
            return this.source.language();
        }
        return this.languages.iterator().next();
    }

    public String dc_title() {
        return this.titles == null || this.titles.size() == 0 ? "" : this.titles.iterator().next();
    }

    public List<String> titles() {
        return this.titles;
    }

    public void setTitle(String title) {
        this.titles = new ArrayList<String>();
        if (title != null) {
            this.titles.add(title);
        }
    }

    public String dc_creator() {
        return this.creator == null ? "" : this.creator.toString();
    }

    public void addTags(Set<String> tags) {
        for (String s : tags) {
            if (s == null || s.isEmpty()) continue;
            this.keywords.add(s);
        }
    }

    protected void addMetatags(Map<String, Set<Tagging.Metatag>> tags) {
        this.generic_facets.putAll(Document.computeGenericFacets(tags));
    }

    public static Map<String, Set<String>> computeGenericFacets(Map<String, Set<Tagging.Metatag>> tags) {
        HashMap<String, Set<String>> gf = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<Tagging.Metatag>> e : tags.entrySet()) {
            Tagging vocabulary = LibraryProvider.autotagging.getVocabulary(e.getKey());
            if (vocabulary == null) continue;
            HashSet<String> objects = new HashSet<String>();
            for (Tagging.Metatag s : e.getValue()) {
                objects.add(s.getObject());
            }
            gf.put(vocabulary.getName(), objects);
        }
        return gf;
    }

    public Set<String> dc_subject() {
        return this.keywords;
    }

    public String dc_subject(char separator) {
        if (this.keywords.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(this.keywords.size() * 8);
        for (String s : this.keywords) {
            sb.append(s).append(separator);
        }
        return sb.substring(0, sb.length() - 1);
    }

    public String[] dc_description() {
        if (this.descriptions == null) {
            return new String[0];
        }
        return this.descriptions.toArray(new String[this.descriptions.size()]);
    }

    public String dc_publisher() {
        return this.publisher == null ? "" : this.publisher;
    }

    public String dc_format() {
        return this.mimeType;
    }

    public String dc_identifier() {
        return this.source.toNormalform(true);
    }

    public DigestURL dc_source() {
        return this.source;
    }

    public void rewrite_dc_source(Pattern pattern, String replacement) {
        String u = this.source.toNormalform(false);
        Matcher m = pattern.matcher(u);
        if (m.matches()) {
            u = m.replaceAll(replacement);
            try {
                DigestURL du;
                this.source = du = new DigestURL(u);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public String getCharset() {
        return this.charset;
    }

    public String[] getSectionTitles() {
        if (this.sections == null) {
            return new String[]{this.dc_title()};
        }
        return this.sections.toArray(new String[this.sections.size()]);
    }

    public InputStream getTextStream() {
        try {
            if (this.text == null) {
                return new ByteArrayInputStream(UTF8.getBytes(""));
            }
            if (this.text instanceof String) {
                return new ByteArrayInputStream(UTF8.getBytes((String)this.text));
            }
            if (this.text instanceof InputStream) {
                return (InputStream)this.text;
            }
            if (this.text instanceof File) {
                return new BufferedInputStream(new FileInputStream((File)this.text));
            }
            if (this.text instanceof byte[]) {
                return new ByteArrayInputStream((byte[])this.text);
            }
            if (this.text instanceof ByteArrayOutputStream) {
                return new ByteArrayInputStream(((ByteArrayOutputStream)this.text).toByteArray());
            }
            assert (false) : this.text.getClass().toString();
            return null;
        }
        catch (Exception e) {
            ConcurrentLog.logException(e);
            return new ByteArrayInputStream(UTF8.getBytes(""));
        }
    }

    public String getTextString() {
        try {
            if (this.text == null) {
                this.text = "";
            } else if (this.text instanceof InputStream) {
                this.text = UTF8.String(FileUtils.read((InputStream)this.text));
            } else if (this.text instanceof File) {
                this.text = UTF8.String(FileUtils.read((File)this.text));
            } else if (this.text instanceof byte[]) {
                this.text = UTF8.String((byte[])this.text);
            } else if (this.text instanceof ByteArrayOutputStream) {
                this.text = UTF8.String(((ByteArrayOutputStream)this.text).toByteArray());
            }
            assert (this.text instanceof String) : this.text.getClass().toString();
            return (String)this.text;
        }
        catch (Exception e) {
            ConcurrentLog.logException(e);
            return "";
        }
    }

    public long getTextLength() {
        try {
            if (this.text == null) {
                return -1L;
            }
            if (this.text instanceof String) {
                return ((String)this.text).length();
            }
            if (this.text instanceof InputStream) {
                return ((InputStream)this.text).available();
            }
            if (this.text instanceof File) {
                return ((File)this.text).length();
            }
            if (this.text instanceof byte[]) {
                return ((byte[])this.text).length;
            }
            if (this.text instanceof ByteArrayOutputStream) {
                return ((ByteArrayOutputStream)this.text).size();
            }
            assert (false) : this.text.getClass().toString();
            return -1L;
        }
        catch (Exception e) {
            ConcurrentLog.logException(e);
            return -1L;
        }
    }

    public List<StringBuilder> getSentences(boolean pre) {
        SentenceReader sr = new SentenceReader(this.getTextString(), pre);
        ArrayList<StringBuilder> sentences = new ArrayList<StringBuilder>();
        while (sr.hasNext()) {
            sentences.add(sr.next());
        }
        return sentences;
    }

    public Collection<AnchorURL> getAnchors() {
        return this.anchors;
    }

    public LinkedHashMap<DigestURL, String> getRSS() {
        return this.rss;
    }

    public Map<AnchorURL, String> getHyperlinks() {
        if (!this.resorted) {
            this.resortLinks();
        }
        return this.hyperlinks;
    }

    public Map<AnchorURL, String> getAudiolinks() {
        if (!this.resorted) {
            this.resortLinks();
        }
        return this.audiolinks;
    }

    public Map<AnchorURL, String> getVideolinks() {
        if (!this.resorted) {
            this.resortLinks();
        }
        return this.videolinks;
    }

    public LinkedHashMap<DigestURL, ImageEntry> getImages() {
        if (!this.resorted) {
            this.resortLinks();
        }
        return this.images;
    }

    public Map<AnchorURL, String> getApplinks() {
        if (!this.resorted) {
            this.resortLinks();
        }
        return this.applinks;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public double lon() {
        return this.lon;
    }

    public double lat() {
        return this.lat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resortLinks() {
        if (this.resorted) {
            return;
        }
        Document document = this;
        synchronized (document) {
            if (this.resorted) {
                return;
            }
            String ext = null;
            String thishost = this.source.getHost();
            this.inboundlinks = new LinkedHashMap();
            this.outboundlinks = new LinkedHashMap();
            this.hyperlinks = new LinkedHashMap();
            this.videolinks = new LinkedHashMap();
            this.audiolinks = new LinkedHashMap();
            this.applinks = new LinkedHashMap();
            HashMap<AnchorURL, ImageEntry> collectedImages = new HashMap<AnchorURL, ImageEntry>();
            for (Map.Entry<DigestURL, ImageEntry> entry2 : this.images.entrySet()) {
                if (entry2.getKey() != null && entry2.getKey().getHost() != null && entry2.getKey().getHost().equals(thishost)) {
                    this.inboundlinks.put(entry2.getKey(), "image");
                    continue;
                }
                this.outboundlinks.put(entry2.getKey(), "image");
            }
            for (AnchorURL url : this.anchors) {
                int qpos;
                boolean nofollow;
                if (url == null) continue;
                String u = url.toNormalform(true);
                String name = url.getNameProperty();
                if (url.getProtocol().equals("mailto")) continue;
                boolean noindex = url.getRelProperty().toLowerCase(Locale.ROOT).indexOf("noindex", 0) >= 0;
                boolean bl = nofollow = url.getRelProperty().toLowerCase(Locale.ROOT).indexOf("nofollow", 0) >= 0;
                if (thishost == null && url.getHost() == null || thishost != null && url.getHost() != null && (url.getHost().endsWith(thishost) || thishost.startsWith("www.") && url.getHost().endsWith(thishost.substring(4)))) {
                    this.inboundlinks.put(url, "anchor" + (noindex ? " noindex" : "") + (nofollow ? " nofollow" : ""));
                } else {
                    this.outboundlinks.put(url, "anchor" + (noindex ? " noindex" : "") + (nofollow ? " nofollow" : ""));
                }
                int extpos = u.lastIndexOf(46);
                if (extpos > 0 && Classification.isMediaExtension(ext = (qpos = u.indexOf(63)) >= 0 && qpos > extpos ? u.substring(extpos + 1, qpos).toLowerCase(Locale.ROOT) : u.substring(extpos + 1).toLowerCase(Locale.ROOT))) {
                    if (Classification.isImageExtension(ext)) {
                        collectedImages.put(url, new ImageEntry(url, name, -1, -1, -1L));
                    } else if (Classification.isAudioExtension(ext)) {
                        this.audiolinks.put(url, name);
                    } else if (Classification.isVideoExtension(ext)) {
                        this.videolinks.put(url, name);
                    } else if (Classification.isApplicationExtension(ext)) {
                        this.applinks.put(url, name);
                    }
                }
                this.hyperlinks.put(url, name);
            }
            this.images.putAll(collectedImages);
            this.hyperlinks.putAll(Document.allReflinks(this.images.values()));
            this.hyperlinks.putAll(Document.allReflinks(this.audiolinks.keySet()));
            this.hyperlinks.putAll(Document.allReflinks(this.videolinks.keySet()));
            this.hyperlinks.putAll(Document.allReflinks(this.applinks.keySet()));
            this.resorted = true;
        }
    }

    public static Map<MultiProtocolURL, String> allSubpaths(Collection<?> links) {
        String u;
        MultiProtocolURL url;
        HashSet<String> h = new HashSet<String>();
        Iterator<Object> i = links.iterator();
        while (i.hasNext()) {
            try {
                Object o = i.next();
                if (o instanceof MultiProtocolURL) {
                    url = (MultiProtocolURL)o;
                } else if (o instanceof String) {
                    url = new MultiProtocolURL((String)o);
                } else if (o instanceof ImageEntry) {
                    url = ((ImageEntry)o).url();
                } else {
                    assert (false);
                    continue;
                }
                u = url.toNormalform(true);
                if (u.endsWith("/")) {
                    u = u.substring(0, u.length() - 1);
                }
                int pos = u.lastIndexOf(47);
                while (pos > 8) {
                    int l = u.length();
                    u = u.substring(0, pos + 1);
                    h.add(u);
                    u = u.substring(0, pos);
                    assert (u.length() < l) : "u = " + u;
                    pos = u.lastIndexOf(47);
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
        }
        i = h.iterator();
        HashMap<MultiProtocolURL, String> v = new HashMap<MultiProtocolURL, String>();
        while (i.hasNext()) {
            u = (String)i.next();
            try {
                url = new MultiProtocolURL(u);
                v.put(url, "sub");
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return v;
    }

    private static Map<AnchorURL, String> allReflinks(Collection<?> links) {
        HashMap<AnchorURL, String> v = new HashMap<AnchorURL, String>();
        Iterator<?> i = links.iterator();
        AnchorURL url = null;
        while (i.hasNext()) {
            try {
                url = null;
                Object o = i.next();
                if (o instanceof AnchorURL) {
                    url = (AnchorURL)o;
                } else if (o instanceof String) {
                    url = new AnchorURL((String)o);
                } else if (o instanceof ImageEntry) {
                    url = new AnchorURL(((ImageEntry)o).url());
                } else if (o instanceof IconEntry) {
                    url = new AnchorURL(((IconEntry)o).getUrl());
                } else {
                    assert (false);
                    continue;
                }
                Object u = url.toNormalform(true);
                int pos = ((String)u).toLowerCase(Locale.ROOT).indexOf("http://", 7);
                if (pos > 0) {
                    i.remove();
                    u = ((String)u).substring(pos);
                    while ((pos = ((String)u).toLowerCase(Locale.ROOT).indexOf("http://", 7)) > 0) {
                        u = ((String)u).substring(pos);
                    }
                    url = new AnchorURL((String)u);
                    if (v.containsKey(url)) continue;
                    v.put(url, "ref");
                    continue;
                }
                pos = ((String)u).toLowerCase(Locale.ROOT).indexOf("https://", 7);
                if (pos > 0) {
                    i.remove();
                    u = ((String)u).substring(pos);
                    while ((pos = ((String)u).toLowerCase(Locale.ROOT).indexOf("https://", 7)) > 0) {
                        u = ((String)u).substring(pos);
                    }
                    url = new AnchorURL((String)u);
                    if (v.containsKey(url)) continue;
                    v.put(url, "ref");
                    continue;
                }
                pos = ((String)u).toLowerCase(Locale.ROOT).indexOf("/www.", 11);
                if (pos <= 0) continue;
                i.remove();
                u = url.getProtocol() + ":/" + ((String)u).substring(pos);
                while ((pos = ((String)u).toLowerCase(Locale.ROOT).indexOf("/www.", 11)) > 0) {
                    u = url.getProtocol() + ":/" + ((String)u).substring(pos);
                }
                AnchorURL addurl = new AnchorURL((String)u);
                if (v.containsKey(addurl)) continue;
                v.put(addurl, "ref");
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubDocuments(Document[] docs) throws IOException {
        for (Document doc : docs) {
            this.sections.addAll(doc.sections);
            this.titles.addAll(doc.titles());
            this.keywords.addAll(doc.dc_subject());
            for (String d : doc.dc_description()) {
                this.descriptions.add(d);
            }
            if (!(this.text instanceof ByteArrayOutputStream)) {
                this.text = new ByteArrayOutputStream();
            }
            InputStream textStream = doc.getTextStream();
            try {
                FileUtils.copy(textStream, (OutputStream)((ByteArrayOutputStream)this.text));
            }
            finally {
                try {
                    if (textStream != null) {
                        textStream.close();
                    }
                }
                catch (IOException e) {
                    ConcurrentLog.warn("DOCUMENT", "Could not close text input stream");
                }
            }
            this.anchors.addAll(doc.getAnchors());
            this.rss.putAll(doc.getRSS());
            this.images.putAll(doc.getImages());
        }
    }

    public Map<DigestURL, IconEntry> getIcons() {
        return this.icons;
    }

    public void setIcons(Map<DigestURL, IconEntry> icons) {
        this.icons = icons != null ? icons : new HashMap<DigestURL, IconEntry>();
    }

    public Set<DigestURL> getLinkedDataTypes() {
        return this.linkedDataTypes;
    }

    public void setLinkedDataTypes(Set<DigestURL> linkedDataTypes) {
        if (linkedDataTypes != null) {
            this.linkedDataTypes = linkedDataTypes;
        } else {
            this.linkedDataTypes.clear();
        }
    }

    public int inboundLinkNofollowCount() {
        if (this.inboundlinks == null) {
            this.resortLinks();
        }
        if (this.inboundlinks == null) {
            return 0;
        }
        int c = 0;
        for (String tag : this.inboundlinks.values()) {
            if (!tag.contains("nofollow")) continue;
            ++c;
        }
        return c;
    }

    public int outboundLinkNofollowCount() {
        if (this.outboundlinks == null) {
            this.resortLinks();
        }
        if (this.outboundlinks == null) {
            return 0;
        }
        int c = 0;
        for (String tag : this.outboundlinks.values()) {
            if (!tag.contains("nofollow")) continue;
            ++c;
        }
        return c;
    }

    public LinkedHashMap<DigestURL, String> inboundLinks() {
        if (this.inboundlinks == null) {
            this.resortLinks();
        }
        return this.inboundlinks == null ? null : this.inboundlinks;
    }

    public LinkedHashMap<DigestURL, String> outboundLinks() {
        if (this.outboundlinks == null) {
            this.resortLinks();
        }
        return this.outboundlinks == null ? null : this.outboundlinks;
    }

    public boolean indexingDenied() {
        return this.indexingDenied;
    }

    public void setIndexingDenied(boolean indexingDenied) {
        this.indexingDenied = indexingDenied;
    }

    public void setDepth(int depth) {
        this.crawldepth = depth;
    }

    public int getDepth() {
        return this.crawldepth;
    }

    public void writeXML(Writer os) throws IOException {
        String language;
        String subject;
        String publisher;
        os.write("<record>\n");
        String title = this.dc_title();
        if (title != null && title.length() > 0) {
            os.write("<dc:title><![CDATA[" + title + "]]></dc:title>\n");
        }
        os.write("<dc:identifier>" + this.dc_identifier() + "</dc:identifier>\n");
        String creator = this.dc_creator();
        if (creator != null && creator.length() > 0) {
            os.write("<dc:creator><![CDATA[" + creator + "]]></dc:creator>\n");
        }
        if ((publisher = this.dc_publisher()) != null && publisher.length() > 0) {
            os.write("<dc:publisher><![CDATA[" + publisher + "]]></dc:publisher>\n");
        }
        if ((subject = this.dc_subject(';')) != null && subject.length() > 0) {
            os.write("<dc:subject><![CDATA[" + subject + "]]></dc:subject>\n");
        }
        if (this.text != null) {
            os.write("<dc:description><![CDATA[");
            os.write(this.getTextString());
            os.write("]]></dc:description>\n");
        }
        if ((language = this.dc_language()) != null && language.length() > 0) {
            os.write("<dc:language>" + this.dc_language() + "</dc:language>\n");
        }
        os.write("<dc:date>" + ISO8601Formatter.FORMATTER.format(this.getLastModified()) + "</dc:date>\n");
        if (this.lon != 0.0 && this.lat != 0.0) {
            os.write("<geo:Point><geo:long>" + this.lon + "</geo:long><geo:lat>" + this.lat + "</geo:lat></geo:Point>\n");
        }
        os.write("</record>\n");
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8);
            this.writeXML(osw);
            ((Writer)osw).close();
            return UTF8.String(baos.toByteArray());
        }
        catch (UnsupportedEncodingException e1) {
            return "";
        }
        catch (IOException e) {
            return "";
        }
    }

    public synchronized void close() {
        if (this.text == null) {
            return;
        }
        if (this.text instanceof InputStream) {
            try {
                ((InputStream)this.text).close();
            }
            catch (Exception exception) {
            }
            finally {
                this.text = null;
            }
        }
        if (this.text instanceof File) {
            try {
                FileUtils.deletedelete((File)this.text);
            }
            catch (Exception exception) {
            }
            finally {
                this.text = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document mergeDocuments(DigestURL location, String globalMime, Document[] docs) {
        if (docs == null || docs.length == 0) {
            return null;
        }
        if (docs.length == 1) {
            return docs[0];
        }
        long docTextLength = 0L;
        ByteBuffer content = new ByteBuffer();
        StringBuilder authors = new StringBuilder(80);
        StringBuilder publishers = new StringBuilder(80);
        StringBuilder subjects = new StringBuilder(80);
        ArrayList<String> descriptions = new ArrayList<String>();
        LinkedHashSet<String> titles = new LinkedHashSet<String>();
        LinkedHashSet sectionTitles = new LinkedHashSet();
        ArrayList<AnchorURL> anchors = new ArrayList<AnchorURL>();
        LinkedHashMap<DigestURL, String> rss = new LinkedHashMap<DigestURL, String>();
        LinkedHashMap<DigestURL, ImageEntry> images = new LinkedHashMap<DigestURL, ImageEntry>();
        HashSet<String> languages = new HashSet<String>();
        double lon = 0.0;
        double lat = 0.0;
        boolean indexingDenied = false;
        boolean partiallyParsed = false;
        Date date = null;
        String charset = null;
        int mindepth = 999;
        for (Document doc : docs) {
            String subject;
            String publisher;
            String author;
            if (doc == null) continue;
            if (charset == null) {
                charset = doc.charset;
            }
            if ((author = doc.dc_creator()).length() > 0) {
                if (authors.length() > 0) {
                    authors.append(",");
                }
                authors.append(author);
            }
            if ((publisher = doc.dc_publisher()).length() > 0) {
                if (publishers.length() > 0) {
                    publishers.append(",");
                }
                publishers.append(publisher);
            }
            if ((subject = doc.dc_subject(',')).length() > 0) {
                if (subjects.length() > 0) {
                    subjects.append(",");
                }
                subjects.append(subject);
            }
            titles.addAll(doc.titles());
            Collections.addAll(sectionTitles, doc.getSectionTitles());
            Collections.addAll(descriptions, doc.dc_description());
            if (doc.getTextLength() > 0L) {
                if (docTextLength > 0L) {
                    content.write('\n');
                }
                InputStream textStream = doc.getTextStream();
                try {
                    docTextLength += FileUtils.copy(textStream, (OutputStream)content);
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
                finally {
                    try {
                        if (textStream != null) {
                            textStream.close();
                        }
                    }
                    catch (IOException e) {
                        ConcurrentLog.warn("DOCUMENT", "Could not close text input stream");
                    }
                }
            }
            anchors.addAll(doc.getAnchors());
            rss.putAll(doc.getRSS());
            images.putAll(doc.getImages());
            if (doc.lon() != 0.0 && doc.lat() != 0.0) {
                lon = doc.lon();
                lat = doc.lat();
            }
            if (date == null || doc.lastModified.after(date)) {
                date = doc.lastModified;
            }
            if (doc.getDepth() < mindepth) {
                mindepth = doc.getDepth();
            }
            if (doc.dc_language() != null) {
                languages.add(doc.dc_language());
            }
            indexingDenied |= doc.indexingDenied;
            partiallyParsed |= doc.isPartiallyParsed();
        }
        for (Document doc : docs) {
            Object scraper = doc.getScraperObject();
            if (!(scraper instanceof ContentScraper)) continue;
            ContentScraper html = (ContentScraper)scraper;
            html.close();
            doc.scraperObject = null;
        }
        ArrayList<String> titlesa = new ArrayList<String>(titles);
        Document newDoc = new Document(location, globalMime, charset, null, languages, subjects.toString().split(" |,"), titlesa, authors.toString(), publishers.toString(), sectionTitles.toArray(new String[sectionTitles.size()]), descriptions, lon, lat, content.getBytes(), anchors, rss, images, indexingDenied, date);
        newDoc.setDepth(mindepth);
        newDoc.setPartiallyParsed(partiallyParsed);
        return newDoc;
    }

    public static Map<AnchorURL, String> getHyperlinks(Document[] documents, boolean includeNofollow) {
        HashMap<AnchorURL, String> result = new HashMap<AnchorURL, String>();
        for (Document d : documents) {
            AnchorURL canonical;
            if (includeNofollow) {
                result.putAll(d.getHyperlinks());
            } else {
                for (Map.Entry<AnchorURL, String> entry2 : d.getHyperlinks().entrySet()) {
                    if (entry2.getKey().attachedNofollow()) continue;
                    result.put(entry2.getKey(), entry2.getValue());
                }
            }
            Object scraper = d.getScraperObject();
            if (!(scraper instanceof ContentScraper)) continue;
            ContentScraper html = (ContentScraper)scraper;
            String refresh = html.getRefreshPath();
            if (refresh != null && refresh.length() > 0) {
                try {
                    result.put(new AnchorURL(refresh), "refresh");
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if ((canonical = html.getCanonical()) != null) {
                result.put(canonical, CANONICAL_MARKER);
            }
            for (AnchorURL u : html.getFrames()) {
                result.put(u, FRAME_MARKER);
            }
            for (AnchorURL u : html.getIFrames()) {
                result.put(u, IFRAME_MARKER);
            }
            for (AnchorURL u : html.getEmbeds().keySet()) {
                result.put(u, EMBED_MARKER);
            }
        }
        return result;
    }

    public static Map<DigestURL, String> getImagelinks(Document[] documents) {
        HashMap<DigestURL, String> result = new HashMap<DigestURL, String>();
        for (Document d : documents) {
            for (ImageEntry imageReference : d.getImages().values()) {
                result.put(imageReference.url(), Document.description(d, imageReference.alt()));
            }
        }
        return result;
    }

    public static Map<DigestURL, String> getAudiolinks(Document[] documents) {
        HashMap<DigestURL, String> result = new HashMap<DigestURL, String>();
        for (Document d : documents) {
            for (Map.Entry<AnchorURL, String> e : d.audiolinks.entrySet()) {
                result.put(e.getKey(), Document.description(d, e.getValue()));
            }
        }
        return result;
    }

    public static Map<DigestURL, String> getVideolinks(Document[] documents) {
        HashMap<DigestURL, String> result = new HashMap<DigestURL, String>();
        for (Document d : documents) {
            for (Map.Entry<AnchorURL, String> e : d.videolinks.entrySet()) {
                result.put(e.getKey(), Document.description(d, e.getValue()));
            }
        }
        return result;
    }

    public static Map<DigestURL, String> getApplinks(Document[] documents) {
        HashMap<DigestURL, String> result = new HashMap<DigestURL, String>();
        for (Document d : documents) {
            for (Map.Entry<AnchorURL, String> e : d.applinks.entrySet()) {
                result.put(e.getKey(), Document.description(d, e.getValue()));
            }
        }
        return result;
    }

    private static final String description(Document d, String tagname) {
        if (tagname == null || tagname.isEmpty()) {
            tagname = d.source.toTokens();
        }
        StringBuilder sb = new StringBuilder(60);
        sb.append(d.dc_title());
        if (d.dc_description().length > 0 && !d.dc_description()[0].equals(d.dc_title()) && sb.length() < Request.descrLength - tagname.length()) {
            sb.append(' ');
            sb.append(d.dc_description()[0]);
        }
        if (sb.length() < Request.descrLength - tagname.length()) {
            sb.append(' ');
            sb.append(d.dc_subject(','));
        }
        if (tagname.length() > 0) {
            if (sb.length() > Request.descrLength - tagname.length() - 3) {
                if (tagname.length() > Request.descrLength) {
                    sb.setLength(0);
                    sb.append(tagname.substring(0, Request.descrLength));
                } else {
                    sb.setLength(Request.descrLength - tagname.length());
                    sb.append(" - ");
                    sb.append(tagname);
                }
            } else {
                sb.append(" - ");
                sb.append(tagname);
            }
        }
        return sb.toString().trim();
    }
}

