/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.util;

import java.util.Date;
import net.yacy.cora.util.Memory;

public class SpaceExceededException
extends Exception {
    private static final long serialVersionUID = 9059516027929222151L;
    private final String forUsage;
    private final long neededRAM;
    private final long availableRAM;
    private final long time = System.currentTimeMillis();

    public SpaceExceededException(long neededRAM, String forUsage) {
        super(Long.toString(neededRAM) + " bytes needed for " + forUsage + ": " + Memory.available() + " free at " + new Date().toString());
        this.availableRAM = Memory.available();
        this.neededRAM = neededRAM;
        this.forUsage = forUsage;
    }

    public SpaceExceededException(long neededRAM, String forUsage, Throwable t) {
        super(Long.toString(neededRAM) + " bytes needed for " + forUsage + ": " + Memory.available() + " free at " + new Date().toString(), t);
        this.availableRAM = Memory.available();
        this.neededRAM = neededRAM;
        this.forUsage = forUsage;
    }

    public String getUsage() {
        return this.forUsage;
    }

    public long getNeededRAM() {
        return this.neededRAM;
    }

    public long getAvailableRAM() {
        return this.availableRAM;
    }

    public long getTime() {
        return this.time;
    }
}

