/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.util;

import java.io.IOException;
import java.io.InputStream;
import net.yacy.cora.protocol.http.HTTPClient;

public class HTTPInputStream
extends InputStream {
    private HTTPClient httpClient;
    private InputStream contentStream;

    public HTTPInputStream(HTTPClient httpClient) throws IOException {
        if (httpClient == null) {
            throw new IllegalArgumentException("httpClient is null");
        }
        this.httpClient = httpClient;
        this.contentStream = httpClient.getContentstream();
        if (this.contentStream == null) {
            throw new IOException("content stream is null");
        }
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    @Override
    public int read() throws IOException {
        return this.contentStream.read();
    }

    public int hashCode() {
        return this.contentStream.hashCode();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.contentStream.read(b);
    }

    public boolean equals(Object obj) {
        return this.contentStream.equals(obj);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.contentStream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.contentStream.skip(n);
    }

    public String toString() {
        return this.contentStream.toString();
    }

    @Override
    public int available() throws IOException {
        return this.contentStream.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.contentStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.contentStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.contentStream.markSupported();
    }
}

