/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.storage;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import net.yacy.cora.document.encoding.UTF8;

public class KeyList
implements Iterable<String> {
    private static final Object _obj = new Object();
    private final Map<String, Object> keys = new ConcurrentHashMap<String, Object>();
    private final RandomAccessFile raf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyList(File file) throws IOException {
        if (file.exists()) {
            InputStream is = new FileInputStream(file);
            if (file.getName().endsWith(".gz")) {
                is = new GZIPInputStream(is);
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String l;
                while ((l = reader.readLine()) != null) {
                    if (l.isEmpty() || l.charAt(0) == '#') continue;
                    l = l.trim().toLowerCase();
                    this.keys.put(l, _obj);
                }
            }
        }
        this.raf = new RandomAccessFile(file, "rw");
    }

    public void clear() throws IOException {
        this.raf.setLength(0L);
        this.keys.clear();
    }

    public int size() {
        return this.keys.size();
    }

    public boolean contains(String key) {
        return this.keys.containsKey(key.trim().toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String key) throws IOException {
        if (this.keys.containsKey(key)) {
            return;
        }
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            if (this.keys.containsKey(key)) {
                return;
            }
            this.keys.put(key, _obj);
            this.raf.seek(this.raf.length());
            this.raf.write(UTF8.getBytes(key));
            this.raf.writeByte(10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.raf.close();
        }
    }

    public static void main(String[] args) {
        try {
            KeyList kl = new KeyList(new File("/tmp/test"));
            kl.add("eins");
            kl.add("zwei");
            kl.add("drei");
            System.out.println(kl.contains("eins") ? "drin" : "nicht");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.keys.keySet().iterator();
    }
}

