/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.protocol.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.message.BasicHeader;

public class GzipCompressingEntity
extends HttpEntityWrapper {
    public GzipCompressingEntity(HttpEntity entity) {
        super(entity);
    }

    public Header getContentEncoding() {
        return new BasicHeader("Content-Encoding", "gzip");
    }

    public long getContentLength() {
        return -1L;
    }

    public boolean isChunked() {
        return true;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        if (outstream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        GZIPOutputStream gzip = new GZIPOutputStream(outstream, 65536){
            {
                this.def.setLevel(1);
            }
        };
        this.wrappedEntity.writeTo((OutputStream)gzip);
        gzip.finish();
    }
}

