/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.protocol;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import net.yacy.cora.protocol.HeaderFramework;
import org.apache.http.Header;

public class ResponseHeader
extends HeaderFramework {
    private static final long serialVersionUID = 0L;
    private Date date_cache_Date = null;
    private Date date_cache_Expires = null;
    private Date date_cache_LastModified = null;
    private List<Cookie> cookieStore;

    public ResponseHeader(int statusCode) {
        this.put("STATUS_CODE", Integer.toString(statusCode));
    }

    public ResponseHeader(int statusCode, Header[] headers) {
        this.put("STATUS_CODE", Integer.toString(statusCode));
        for (Header h : headers) {
            this.add(h.getName(), h.getValue());
        }
    }

    public ResponseHeader(Map<String, String> othermap) {
        super(othermap);
    }

    public int getStatusCode() {
        String statuscode = (String)this.get("STATUS_CODE");
        if (statuscode == null) {
            return 200;
        }
        try {
            return Integer.parseInt(statuscode);
        }
        catch (NumberFormatException e) {
            return 200;
        }
    }

    public Date date() {
        if (this.date_cache_Date != null) {
            return this.date_cache_Date;
        }
        Date d = this.headerDate("Date");
        Date now = new Date();
        this.date_cache_Date = d == null ? now : (d.after(now) ? now : d);
        return this.date_cache_Date;
    }

    public Date expires() {
        if (this.date_cache_Expires != null) {
            return this.date_cache_Expires;
        }
        this.date_cache_Expires = this.headerDate("Expires");
        return this.date_cache_Expires;
    }

    public Date lastModified() {
        if (this.date_cache_LastModified != null) {
            return this.date_cache_LastModified;
        }
        Date d = this.headerDate("Last-Modified");
        Date now = new Date();
        this.date_cache_LastModified = d == null ? this.date() : (d.after(now) ? now : d);
        return this.date_cache_LastModified;
    }

    public long age() {
        Date lm = this.lastModified();
        Date now = new Date();
        return now.getTime() - lm.getTime();
    }

    public boolean gzip() {
        return this.containsKey("Content-Encoding") && ((String)this.get("Content-Encoding")).toUpperCase().startsWith("GZIP");
    }

    public String getXRobotsTag() {
        String x_robots_tag = this.get("X-Robots-Tag", "");
        if (x_robots_tag.isEmpty()) {
            x_robots_tag = this.get("X-Robots", "");
        }
        return x_robots_tag.toLowerCase();
    }

    public void setCookie(String name, String value, Integer maxage, String path, String domain, boolean secure) {
        if (!name.isEmpty()) {
            if (this.cookieStore == null) {
                this.cookieStore = new ArrayList<Cookie>();
            }
            Cookie c = new Cookie(name, value);
            if (maxage != null && maxage >= 0) {
                c.setMaxAge(maxage.intValue());
            }
            if (path != null) {
                c.setPath(path);
            }
            if (domain != null) {
                c.setDomain(domain);
            }
            if (secure) {
                c.setSecure(secure);
            }
            this.cookieStore.add(c);
        }
    }

    public void setCookie(String name, String value) {
        this.setCookie(name, value, null, null, null, false);
    }

    public List<Cookie> getCookiesEntries() {
        return this.cookieStore;
    }
}

