/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.order;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import net.yacy.cora.order.AbstractOrder;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.Order;
import net.yacy.cora.order.StringOrder;

public final class NaturalOrder
extends AbstractOrder<byte[]>
implements ByteOrder,
Comparator<byte[]>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 7170913936645013046L;
    public static final ByteOrder naturalOrder = new NaturalOrder(true);
    public static final Comparator<String> naturalComparator = new StringOrder(naturalOrder);

    public NaturalOrder(boolean ascending) {
        this.asc = ascending;
        this.zero = null;
    }

    @Override
    public boolean wellformed(byte[] a) {
        return true;
    }

    @Override
    public boolean wellformed(byte[] a, int astart, int alength) {
        return true;
    }

    @Override
    public final Order<byte[]> clone() {
        NaturalOrder o = new NaturalOrder(this.asc);
        o.rotate((byte[])this.zero);
        return o;
    }

    public static ByteOrder orderBySignature(String signature) {
        ByteOrder oo = null;
        if (oo == null) {
            oo = NaturalOrder.bySignature(signature);
        }
        if (oo == null) {
            oo = Base64Order.bySignature(signature);
        }
        if (oo == null) {
            oo = new NaturalOrder(true);
        }
        return oo;
    }

    public static final ByteOrder bySignature(String signature) {
        if (signature.equals("nd")) {
            return new NaturalOrder(false);
        }
        if (signature.equals("nu")) {
            return new NaturalOrder(true);
        }
        return null;
    }

    @Override
    public final String signature() {
        if (!this.asc) {
            return "nd";
        }
        if (this.asc) {
            return "nu";
        }
        return null;
    }

    private static final long cardinalI(byte[] key, int off, int len) {
        long c = 0L;
        int lim = off + Math.min(8, len);
        int lim8 = off + 8;
        while (off < lim) {
            c = c << 8 | (long)key[off++] & 0xFFL;
        }
        while (off++ < lim8) {
            c <<= 8;
        }
        return c >>>= 1;
    }

    @Override
    public final long cardinal(byte[] key) {
        if (this.zero == null) {
            return NaturalOrder.cardinalI(key, 0, key.length);
        }
        long zeroCardinal = NaturalOrder.cardinalI((byte[])this.zero, 0, ((byte[])this.zero).length);
        long keyCardinal = NaturalOrder.cardinalI(key, 0, key.length);
        if (keyCardinal > zeroCardinal) {
            return keyCardinal - zeroCardinal;
        }
        return Long.MAX_VALUE - keyCardinal + zeroCardinal;
    }

    @Override
    public long cardinal(byte[] key, int off, int len) {
        if (this.zero == null) {
            return NaturalOrder.cardinalI(key, off, len);
        }
        long zeroCardinal = NaturalOrder.cardinalI((byte[])this.zero, 0, ((byte[])this.zero).length);
        long keyCardinal = NaturalOrder.cardinalI(key, off, len);
        if (keyCardinal > zeroCardinal) {
            return keyCardinal - zeroCardinal;
        }
        return Long.MAX_VALUE - keyCardinal + zeroCardinal;
    }

    public static final byte[] encodeLong(long c, int length) {
        byte[] b = new byte[length];
        while (length > 0) {
            b[--length] = (byte)(c & 0xFFL);
            c >>= 8;
        }
        return b;
    }

    public static final void encodeLong(long c, byte[] b, int offset, int length) {
        assert (offset + length <= b.length);
        while (length > 0) {
            b[--length + offset] = (byte)(c & 0xFFL);
            c >>= 8;
        }
    }

    public static final long decodeLong(byte[] s) {
        if (s == null) {
            return 0L;
        }
        long c = 0L;
        int p = 0;
        while (p < s.length) {
            c = c << 8 | (long)s[p++] & 0xFFL;
        }
        return c;
    }

    public static final long decodeLong(byte[] s, int offset, int length) {
        if (s == null) {
            return 0L;
        }
        long c = 0L;
        int m = Math.min(s.length, offset + length);
        while (offset < m) {
            c = c << 8 | (long)s[offset++] & 0xFFL;
        }
        return c;
    }

    private static final int sig(int x) {
        return x > 0 ? 1 : (x < 0 ? -1 : 0);
    }

    @Override
    public final int compare(byte[] a, byte[] b) {
        if (a.length == b.length) {
            return this.asc ? this.compare0(a, b, a.length) : this.compare0(b, 0, a, 0, a.length);
        }
        int length = Math.min(a.length, b.length);
        if (this.asc) {
            int c = this.compare0(a, b, length);
            if (c != 0) {
                return c;
            }
            return a.length > b.length ? 1 : -1;
        }
        int c = this.compare0(b, a, length);
        if (c != 0) {
            return c;
        }
        return a.length > b.length ? -1 : 1;
    }

    @Override
    public final int compare(byte[] a, byte[] b, int length) {
        return this.asc ? this.compare0(a, b, length) : this.compare0(b, a, length);
    }

    @Override
    public final int compare(byte[] a, int aoffset, byte[] b, int boffset, int length) {
        return this.asc ? this.compare0(a, aoffset, b, boffset, length) : this.compare0(b, boffset, a, aoffset, length);
    }

    private final int compare0(byte[] a, byte[] b, int length) {
        int bz;
        if (this.zero == null) {
            return NaturalOrder.compares(a, b, length);
        }
        assert (length == ((byte[])this.zero).length);
        int az = NaturalOrder.compares(a, (byte[])this.zero, length);
        if (az == (bz = NaturalOrder.compares(b, (byte[])this.zero, length))) {
            return NaturalOrder.compares(a, b, length);
        }
        return NaturalOrder.sig(az - bz);
    }

    private final int compare0(byte[] a, int aoffset, byte[] b, int boffset, int length) {
        int bz;
        if (this.zero == null) {
            return NaturalOrder.compares(a, aoffset, b, boffset, length);
        }
        assert (length == ((byte[])this.zero).length);
        int az = NaturalOrder.compares(a, aoffset, (byte[])this.zero, 0, length);
        if (az == (bz = NaturalOrder.compares(b, boffset, (byte[])this.zero, 0, length))) {
            return NaturalOrder.compares(a, aoffset, b, boffset, length);
        }
        return NaturalOrder.sig(az - bz);
    }

    @Override
    public final boolean equal(byte[] a, byte[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        int astart = 0;
        int bstart = 0;
        int length = a.length;
        while (length-- != 0) {
            if (a[astart++] == b[bstart++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean equal(byte[] a, int astart, byte[] b, int bstart, int length) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        while (length-- != 0) {
            if (a[astart++] == b[bstart++]) continue;
            return false;
        }
        return true;
    }

    private static final int compares(byte[] a, byte[] b, int length) {
        for (int i = 0; i < length; ++i) {
            int aa = 0xFF & a[i];
            int bb = 0xFF & b[i];
            if (aa > bb) {
                return 1;
            }
            if (aa >= bb) continue;
            return -1;
        }
        return 0;
    }

    private static final int compares(byte[] a, int aoffset, byte[] b, int boffset, int length) {
        for (int i = 0; i < length; ++i) {
            int aa = 0xFF & a[i + aoffset];
            int bb = 0xFF & b[i + boffset];
            if (aa > bb) {
                return 1;
            }
            if (aa >= bb) continue;
            return -1;
        }
        return 0;
    }

    public static final String arrayList(byte[] b, int start, int length) {
        if (b == null) {
            return "NULL";
        }
        if (b.length == 0) {
            return "[]";
        }
        length = Math.min(length, b.length - start);
        StringBuilder sb = new StringBuilder(b.length * 4);
        sb.append('[').append(Integer.toString(b[start])).append(',');
        for (int i = 1; i < length; ++i) {
            sb.append(' ').append(Integer.toString(b[start + i])).append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    public static final String table(byte[] b, int linewidth) {
        if (b == null) {
            return "NULL";
        }
        if (b.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(b.length * 4);
        for (int i = 0; i < b.length; ++i) {
            if (i % linewidth == 0) {
                sb.append('\n').append("# ").append(Integer.toHexString(i)).append(": ");
            } else {
                sb.append(',');
            }
            sb.append(' ').append(Integer.toString(0xFF & b[i]));
            if (i >= 65535) break;
        }
        sb.append('\n');
        return sb.toString();
    }

    public static Iterator<Long> LongIterator(Iterator<byte[]> b256Iterator) {
        return new LongIter(b256Iterator);
    }

    public static void main(String[] args) {
        byte[] t = new byte[12];
        for (int i = 0; i < 12; ++i) {
            t[i] = -1;
        }
        t[0] = 127;
        NaturalOrder o = new NaturalOrder(true);
        System.out.println(o.partition(t, 16));
    }

    public static class LongIter
    implements Iterator<Long> {
        private final Iterator<byte[]> b256Iterator;

        public LongIter(Iterator<byte[]> b256Iterator) {
            this.b256Iterator = b256Iterator;
        }

        @Override
        public boolean hasNext() {
            return this.b256Iterator.hasNext();
        }

        @Override
        public Long next() {
            byte[] b = this.b256Iterator.next();
            assert (b != null);
            if (b == null) {
                return null;
            }
            return NaturalOrder.decodeLong(b);
        }

        @Override
        public void remove() {
            this.b256Iterator.remove();
        }
    }
}

