/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.lod;

import java.util.HashMap;
import java.util.Map;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.lod.Vocabulary;
import net.yacy.cora.lod.vocabulary.Rdf;

public class Node
extends HashMap<String, byte[]>
implements Map<String, byte[]> {
    private static final long serialVersionUID = -6715118942251224832L;
    public static final String SUBJECT = "rdf:about";
    private final Rdf type;

    public Node(Rdf type) {
        this.type = type;
    }

    public Node(Rdf type, byte[] subject) {
        this(type);
        this.put(SUBJECT, subject);
    }

    public Node(Rdf type, Map<String, byte[]> set) {
        this(type);
        this.putAll(set);
    }

    public Rdf getType() {
        return this.type;
    }

    public boolean isBlank() {
        return !this.containsKey(SUBJECT);
    }

    public byte[] getSubject() {
        return (byte[])this.get(SUBJECT);
    }

    public void setSubject(byte[] subject) {
        this.put(SUBJECT, subject);
    }

    public byte[] getObject(Vocabulary predicate) {
        return (byte[])this.get(predicate.getPredicate());
    }

    public byte[] setObject(Vocabulary predicate, byte[] object) {
        return this.put(predicate.getPredicate(), object);
    }

    public byte[] removePredicate(Vocabulary predicate) {
        return (byte[])this.remove(predicate.getPredicate());
    }

    public byte[] toObject() {
        StringBuilder sb = new StringBuilder(this.size() * 50);
        sb.append("<");
        sb.append(this.type.getPredicate());
        byte[] subject = (byte[])this.get(SUBJECT);
        if (subject != null) {
            sb.append(" rdf:about=\"").append(UTF8.String(subject)).append('\"');
        }
        sb.append(">\n");
        for (Map.Entry entry2 : this.entrySet()) {
            if (((String)entry2.getKey()).equals(SUBJECT)) continue;
            sb.append('<').append((String)entry2.getKey()).append('>');
            sb.append(UTF8.String((byte[])entry2.getValue()));
            sb.append("</").append((String)entry2.getKey()).append(">\n");
        }
        sb.append("</");
        sb.append(this.type.getPredicate());
        sb.append(">\n");
        return UTF8.getBytes(sb);
    }
}

