/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.language.synonyms;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import net.yacy.cora.storage.Files;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;

public class SynonymLibrary {
    private static final ConcurrentLog log = new ConcurrentLog(SynonymLibrary.class.getName());
    private static final Map<String, List<Set<String>>> lib = new HashMap<String, List<Set<String>>>();

    public static void init(File path) {
        lib.clear();
        if (!path.exists() || !path.isDirectory()) {
            return;
        }
        String[] files = path.list();
        HashMap<String, String> distinctWords = new HashMap<String, String>();
        for (String f : files) {
            File ff = new File(path, f);
            try {
                String line;
                BlockingQueue<String> list2 = Files.concurentLineReader(ff);
                while ((line = list2.take()) != "__@POISON__") {
                    if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                    if (line.charAt(line.length() - 1) == '}') {
                        line = line.substring(0, line.length() - 1);
                    }
                    if (line.charAt(0) == '{') {
                        line = line.substring(1);
                    }
                    String[] words = CommonPattern.COMMA.split(line);
                    HashSet<String> synonyms = new HashSet<String>(words.length);
                    HashSet<String> keys = new HashSet<String>(words.length);
                    for (String word : words) {
                        if ((word = word.trim()).length() < 2) continue;
                        String lowCaseWord = word.toLowerCase();
                        String kownWord = (String)distinctWords.get(lowCaseWord);
                        if (kownWord != null) {
                            lowCaseWord = kownWord;
                        } else {
                            distinctWords.put(lowCaseWord, lowCaseWord);
                        }
                        synonyms.add(lowCaseWord);
                        keys.add(lowCaseWord.substring(0, 2));
                    }
                    for (String key : keys) {
                        List<Set<String>> symsetlist = lib.get(key);
                        if (symsetlist == null) {
                            symsetlist = new ArrayList<Set<String>>();
                            lib.put(key, symsetlist);
                        }
                        symsetlist.add(synonyms);
                    }
                }
            }
            catch (Throwable e) {
                log.warn("cannot read stemming file " + f, e);
            }
        }
    }

    public static int size() {
        return lib.size();
    }

    public static Set<String> getSynonyms(String word) {
        if (word == null) {
            return null;
        }
        if ((word = word.toLowerCase().trim()).length() < 2) {
            return null;
        }
        String key = word.substring(0, 2);
        List<Set<String>> symsetlist = lib.get(key);
        if (symsetlist == null) {
            return null;
        }
        for (Set<String> symset : symsetlist) {
            if (!symset.contains(word)) continue;
            HashSet<String> returnSet = new HashSet<String>();
            for (String synonym : symset) {
                if (synonym.equals(word)) continue;
                returnSet.add(synonym);
            }
            return returnSet;
        }
        return null;
    }
}

