/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.language.synonyms;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.geo.Locations;
import net.yacy.cora.lod.vocabulary.Tagging;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.document.ProbabilisticClassifier;
import org.apache.commons.lang3.StringUtils;

public class AutotaggingLibrary {
    private static final ConcurrentLog log = new ConcurrentLog(AutotaggingLibrary.class.getName());
    private static final Object PRESENT = new Object();
    private final File autotaggingPath;
    private final Map<String, Tagging> vocabularies;
    private final Map<String, Object> allTags;

    public AutotaggingLibrary(File autotaggingPath) {
        String[] files;
        this.vocabularies = new ConcurrentHashMap<String, Tagging>();
        this.autotaggingPath = autotaggingPath;
        this.allTags = new ConcurrentHashMap<String, Object>();
        if (this.autotaggingPath == null || !this.autotaggingPath.exists()) {
            return;
        }
        for (String f : files = this.autotaggingPath.list()) {
            if (!f.endsWith(".vocabulary")) continue;
            try {
                File ff = new File(this.autotaggingPath, f);
                String vocName = ff.getName();
                vocName = vocName.substring(0, vocName.length() - 11);
                Tagging voc = new Tagging(vocName, ff);
                this.vocabularies.put(vocName, voc);
                for (String t : voc.tags()) {
                    this.allTags.put(t, PRESENT);
                }
            }
            catch (IOException e) {
                log.warn(e.getMessage(), e);
            }
        }
    }

    protected AutotaggingLibrary(Map<String, Tagging> vocabularies) {
        this.vocabularies = vocabularies != null ? vocabularies : new ConcurrentHashMap<String, Tagging>();
        this.allTags = new ConcurrentHashMap<String, Object>();
        this.autotaggingPath = null;
        for (Tagging voc : this.vocabularies.values()) {
            for (String t : voc.tags()) {
                this.allTags.put(t, PRESENT);
            }
        }
    }

    public File getVocabularyFile(String name) {
        return new File(this.autotaggingPath, name + ".vocabulary");
    }

    public void deleteVocabulary(String name) {
        Tagging v = this.vocabularies.remove(name);
        if (v == null || v.getFile() == null) {
            return;
        }
        v.getFile().delete();
    }

    public Tagging getVocabulary(String name) {
        return this.vocabularies.get(name);
    }

    public Set<String> getVocabularyNames() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.vocabularies.keySet());
        return names;
    }

    public Collection<Tagging> getVocabularies() {
        return this.vocabularies.values();
    }

    public Set<String> allTags() {
        return this.allTags.keySet();
    }

    public void addVocabulary(Tagging voc) {
        this.vocabularies.put(voc.getName(), voc);
        for (String t : voc.tags()) {
            this.allTags.put(t, PRESENT);
        }
    }

    public void addPlaces(Locations locations) {
        if (locations.isEmpty()) {
            return;
        }
        Tagging voc = new Tagging("Locations", locations);
        try {
            voc.setObjectspace("http://dbpedia.org/resource/");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.vocabularies.put("Locations", voc);
        for (String t : voc.tags()) {
            this.allTags.put(t, PRESENT);
        }
    }

    public void removePlaces() {
        this.vocabularies.remove("Locations");
    }

    public int size() {
        return this.vocabularies.size();
    }

    public boolean isEmpty() {
        return this.vocabularies.isEmpty();
    }

    public int getMaxWordsInTerm() {
        return 4;
    }

    public Tagging.Metatag getTagFromTerm(Set<String> vocabularies, String term) {
        if (this.vocabularies.isEmpty()) {
            return null;
        }
        term = Tagging.normalizeTerm(term);
        for (String vocabularyName : vocabularies) {
            Tagging.Metatag tag;
            Tagging t = this.vocabularies.get(vocabularyName);
            if (t == null || t.isMatchFromLinkedData() || (tag = t.getMetatagFromSynonym(term)) == null) continue;
            return tag;
        }
        return null;
    }

    public Set<Tagging.Metatag> getTagsFromTermURL(DigestURL termURL) {
        HashSet<Tagging.Metatag> tags = new HashSet<Tagging.Metatag>();
        if (termURL == null || this.vocabularies.isEmpty()) {
            return tags;
        }
        String termURLStr = termURL.toNormalform(false);
        String termNamespace = null;
        String term = termURL.getRef();
        if (term == null) {
            int lastPathSeparatorPos;
            term = termURL.getFileName();
            if (StringUtils.isNotEmpty((CharSequence)term) && (lastPathSeparatorPos = termURLStr.lastIndexOf("/")) > 0) {
                termNamespace = termURLStr.substring(0, lastPathSeparatorPos + 1);
            }
        } else {
            int fragmentPos = termURLStr.indexOf("#");
            if (fragmentPos > 0) {
                termNamespace = termURLStr.substring(0, fragmentPos + 1);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)term) && termNamespace != null) {
            String alternativeTermNamespace = termURL.isHTTP() ? "https" + termNamespace.substring("http".length()) : (termURL.isHTTPS() ? "http" + termNamespace.substring("https".length()) : null);
            for (Tagging vocabulary : this.vocabularies.values()) {
                Tagging.Metatag tag;
                if (vocabulary == null || !vocabulary.isMatchFromLinkedData() || !termNamespace.equals(vocabulary.getObjectspace()) && (alternativeTermNamespace == null || !alternativeTermNamespace.equals(vocabulary.getObjectspace())) || (tag = vocabulary.getMetatagFromTerm(term)) == null) continue;
                tags.add(tag);
            }
        }
        return tags;
    }

    public Tagging.Metatag metatag(String vocName, String term) {
        Tagging tagging = this.vocabularies.get(vocName);
        if (tagging == null && ProbabilisticClassifier.getContextNames().contains(vocName)) {
            tagging = new Tagging(vocName);
        }
        if (tagging == null) {
            return null;
        }
        return tagging.getMetatagFromTerm(Tagging.decodeMaskname(term));
    }
}

