/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.logic;

import net.yacy.cora.federate.solr.SchemaDeclaration;
import net.yacy.cora.federate.solr.logic.Literal;
import net.yacy.cora.federate.solr.logic.Term;
import org.apache.solr.common.SolrDocument;

public class BooleanLiteral
extends Literal
implements Term {
    private SchemaDeclaration key;
    private boolean value;

    public BooleanLiteral(SchemaDeclaration key, boolean value) {
        this.key = key;
        this.value = value;
    }

    public Object clone() {
        return new BooleanLiteral(this.key, this.value);
    }

    @Override
    public boolean equals(Object otherTerm) {
        if (!(otherTerm instanceof BooleanLiteral)) {
            return false;
        }
        BooleanLiteral o = (BooleanLiteral)otherTerm;
        return this.key.equals(o.key) && this.value == o.value;
    }

    public int hashCode() {
        return this.key.hashCode() + (this.value ? 1 : 0);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.key.getSolrFieldName());
        sb.append(':').append(this.value ? "true" : "false");
        return sb.toString();
    }

    @Override
    public boolean matches(SolrDocument doc) {
        Object v = doc.getFieldValue(this.key.getSolrFieldName());
        if (v == null) {
            return false;
        }
        return v.toString().matches(this.value ? "true" : "false");
    }
}

