/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.instance;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.yacy.cora.federate.solr.connector.ShardSelection;
import net.yacy.cora.federate.solr.instance.ResponseAccumulator;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.StreamingResponseCallback;
import org.apache.solr.client.solrj.beans.DocumentObjectBinder;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;

public class ServerShard
extends SolrClient {
    private static final long serialVersionUID = -3524175189049786312L;
    private static final UpdateResponse _dummyOKResponse = new UpdateResponse();
    private final ShardSelection shards;
    private final boolean writeEnabled;

    public ServerShard(ArrayList<SolrClient> server, ShardSelection.Method method, boolean writeEnabled) {
        this.shards = new ShardSelection(server, method);
        this.writeEnabled = writeEnabled;
    }

    public UpdateResponse add(Collection<SolrInputDocument> docs) throws SolrServerException, IOException {
        if (!this.writeEnabled) {
            return _dummyOKResponse;
        }
        UpdateResponse ur = null;
        for (SolrInputDocument doc : docs) {
            ur = this.shards.server4write(doc).add(doc);
        }
        return ur;
    }

    public UpdateResponse add(Collection<SolrInputDocument> docs, int commitWithinMs) throws SolrServerException, IOException {
        if (!this.writeEnabled) {
            return _dummyOKResponse;
        }
        UpdateResponse ur = null;
        for (SolrInputDocument doc : docs) {
            ur = this.shards.server4write(doc).add(doc, commitWithinMs);
        }
        return ur;
    }

    public UpdateResponse addBeans(Collection<?> beans) throws SolrServerException, IOException {
        if (!this.writeEnabled) {
            return _dummyOKResponse;
        }
        UpdateResponse ur = null;
        for (SolrClient s : this.shards) {
            ur = s.addBeans(beans);
        }
        return ur;
    }

    public UpdateResponse addBeans(Collection<?> beans, int commitWithinMs) throws SolrServerException, IOException {
        if (!this.writeEnabled) {
            return _dummyOKResponse;
        }
        UpdateResponse ur = null;
        for (SolrClient s : this.shards) {
            ur = s.addBeans(beans, commitWithinMs);
        }
        return ur;
    }

    public UpdateResponse add(SolrInputDocument doc) throws SolrServerException, IOException {
        if (!this.writeEnabled) {
            return _dummyOKResponse;
        }
        return this.shards.server4write(doc).add(doc);
    }

    public UpdateResponse add(SolrInputDocument doc, int commitWithinMs) throws SolrServerException, IOException {
        if (!this.writeEnabled) {
            return _dummyOKResponse;
        }
        return this.shards.server4write(doc).add(doc, commitWithinMs);
    }

    public UpdateResponse addBean(Object obj) throws IOException, SolrServerException {
        if (!this.writeEnabled) {
            return _dummyOKResponse;
        }
        UpdateResponse ur = null;
        for (SolrClient s : this.shards) {
            ur = s.addBean(obj);
        }
        return ur;
    }

    public UpdateResponse addBean(Object obj, int commitWithinMs) throws IOException, SolrServerException {
        if (!this.writeEnabled) {
            return _dummyOKResponse;
        }
        UpdateResponse ur = null;
        for (SolrClient s : this.shards) {
            ur = s.addBean(obj, commitWithinMs);
        }
        return ur;
    }

    public UpdateResponse commit() throws SolrServerException, IOException {
        if (!this.writeEnabled) {
            return _dummyOKResponse;
        }
        UpdateResponse ur = null;
        for (SolrClient s : this.shards) {
            ur = s.commit();
        }
        return ur;
    }

    public UpdateResponse optimize() throws SolrServerException, IOException {
        if (!this.writeEnabled) {
            return _dummyOKResponse;
        }
        UpdateResponse ur = null;
        for (SolrClient s : this.shards) {
            ur = s.optimize();
        }
        return ur;
    }

    public UpdateResponse commit(boolean waitFlush, boolean waitSearcher) throws SolrServerException, IOException {
        if (!this.writeEnabled) {
            return _dummyOKResponse;
        }
        UpdateResponse ur = null;
        for (SolrClient s : this.shards) {
            ur = s.commit(waitFlush, waitSearcher);
        }
        return ur;
    }

    public UpdateResponse commit(boolean waitFlush, boolean waitSearcher, boolean softCommit) throws SolrServerException, IOException {
        if (!this.writeEnabled) {
            return _dummyOKResponse;
        }
        UpdateResponse ur = null;
        for (SolrClient s : this.shards) {
            ur = s.commit(waitFlush, waitSearcher, softCommit);
        }
        return ur;
    }

    public UpdateResponse optimize(boolean waitFlush, boolean waitSearcher) throws SolrServerException, IOException {
        if (!this.writeEnabled) {
            return _dummyOKResponse;
        }
        UpdateResponse ur = null;
        for (SolrClient s : this.shards) {
            ur = s.optimize(waitFlush, waitSearcher);
        }
        return ur;
    }

    public UpdateResponse optimize(boolean waitFlush, boolean waitSearcher, int maxSegments) throws SolrServerException, IOException {
        if (!this.writeEnabled) {
            return _dummyOKResponse;
        }
        UpdateResponse ur = null;
        for (SolrClient s : this.shards) {
            ur = s.optimize(waitFlush, waitSearcher, maxSegments);
        }
        return ur;
    }

    public UpdateResponse rollback() throws SolrServerException, IOException {
        if (!this.writeEnabled) {
            return _dummyOKResponse;
        }
        UpdateResponse ur = null;
        for (SolrClient s : this.shards) {
            ur = s.rollback();
        }
        return ur;
    }

    public UpdateResponse deleteById(String id) throws SolrServerException, IOException {
        if (!this.writeEnabled) {
            return _dummyOKResponse;
        }
        UpdateResponse ur = null;
        for (SolrClient s : this.shards.server4read()) {
            ur = s.deleteById(id);
        }
        return ur;
    }

    public UpdateResponse deleteById(String id, int commitWithinMs) throws SolrServerException, IOException {
        if (!this.writeEnabled) {
            return _dummyOKResponse;
        }
        UpdateResponse ur = null;
        for (SolrClient s : this.shards.server4read()) {
            ur = s.deleteById(id, commitWithinMs);
        }
        return ur;
    }

    public UpdateResponse deleteById(List<String> ids) throws SolrServerException, IOException {
        if (!this.writeEnabled) {
            return _dummyOKResponse;
        }
        UpdateResponse ur = null;
        for (SolrClient s : this.shards.server4read()) {
            ur = s.deleteById(ids);
        }
        return ur;
    }

    public UpdateResponse deleteById(List<String> ids, int commitWithinMs) throws SolrServerException, IOException {
        if (!this.writeEnabled) {
            return _dummyOKResponse;
        }
        UpdateResponse ur = null;
        for (SolrClient s : this.shards.server4read()) {
            ur = s.deleteById(ids, commitWithinMs);
        }
        return ur;
    }

    public UpdateResponse deleteByQuery(String query2) throws SolrServerException, IOException {
        if (!this.writeEnabled) {
            return _dummyOKResponse;
        }
        UpdateResponse ur = null;
        for (SolrClient s : this.shards.server4read()) {
            ur = s.deleteByQuery(query2);
        }
        return ur;
    }

    public UpdateResponse deleteByQuery(String query2, int commitWithinMs) throws SolrServerException, IOException {
        if (!this.writeEnabled) {
            return _dummyOKResponse;
        }
        UpdateResponse ur = null;
        for (SolrClient s : this.shards.server4read()) {
            ur = s.deleteByQuery(query2, commitWithinMs);
        }
        return ur;
    }

    public SolrPingResponse ping() throws SolrServerException, IOException {
        for (SolrClient s : this.shards) {
            SolrPingResponse spr = s.ping();
            if (spr == null) continue;
            return spr;
        }
        return null;
    }

    public QueryResponse query(final SolrParams params) throws SolrServerException, IOException {
        List<SolrClient> qs = this.shards.server4read();
        if (qs.size() == 1) {
            return qs.get(0).query(params);
        }
        final ConcurrentLinkedQueue<QueryResponse> qrl = new ConcurrentLinkedQueue<QueryResponse>();
        ArrayList<1> t = new ArrayList<1>();
        for (final SolrClient solrClient : qs) {
            Thread t0 = new Thread(this, "ServerShard.query/1(" + params.toString() + ")"){
                final /* synthetic */ ServerShard this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public void run() {
                    QueryResponse rsp;
                    try {
                        rsp = solrClient.query(params);
                    }
                    catch (Throwable e) {
                        return;
                    }
                    qrl.add(rsp);
                }
            };
            t0.start();
            t.add(t0);
        }
        for (Thread thread : t) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        return ResponseAccumulator.combineResponses(qrl);
    }

    public QueryResponse query(final SolrParams params, final SolrRequest.METHOD method) throws SolrServerException, IOException {
        List<SolrClient> qs = this.shards.server4read();
        if (qs.size() == 1) {
            return qs.get(0).query(params, method);
        }
        final ConcurrentLinkedQueue<QueryResponse> qrl = new ConcurrentLinkedQueue<QueryResponse>();
        ArrayList<2> t = new ArrayList<2>();
        for (final SolrClient solrClient : qs) {
            Thread t0 = new Thread(this, "ServerShard.query/2(" + params.toString() + ")"){
                final /* synthetic */ ServerShard this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public void run() {
                    QueryResponse rsp;
                    try {
                        rsp = solrClient.query(params, method);
                    }
                    catch (Throwable e) {
                        return;
                    }
                    qrl.add(rsp);
                }
            };
            t0.start();
            t.add(t0);
        }
        for (Thread thread : t) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        return ResponseAccumulator.combineResponses(qrl);
    }

    public QueryResponse queryAndStreamResponse(SolrParams params, StreamingResponseCallback callback) throws SolrServerException, IOException {
        throw new UnsupportedOperationException("stream response not possible with shards");
    }

    public NamedList<Object> request(SolrRequest request, String collection) throws SolrServerException, IOException {
        ResponseAccumulator acc = new ResponseAccumulator();
        for (SolrClient s : this.shards.server4read()) {
            acc.addResponse((NamedList<Object>)s.request(request, collection));
        }
        return acc.getAccumulatedResponse();
    }

    public DocumentObjectBinder getBinder() {
        for (SolrClient s : this.shards) {
            DocumentObjectBinder db = s.getBinder();
            if (db == null) continue;
            return db;
        }
        return null;
    }

    public void close() throws IOException {
        for (SolrClient s : this.shards) {
            try {
                s.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        _dummyOKResponse.setElapsedTime(0L);
        _dummyOKResponse.setResponse(new NamedList());
    }
}

