/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.instance;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.yacy.cora.federate.solr.connector.EmbeddedSolrConnector;
import net.yacy.cora.federate.solr.connector.MirrorSolrConnector;
import net.yacy.cora.federate.solr.connector.RemoteSolrConnector;
import net.yacy.cora.federate.solr.connector.SolrConnector;
import net.yacy.cora.federate.solr.instance.EmbeddedInstance;
import net.yacy.cora.federate.solr.instance.ShardInstance;
import net.yacy.search.Switchboard;

public class InstanceMirror {
    private EmbeddedInstance embeddedSolrInstance = null;
    private ShardInstance remoteSolrInstance = null;
    private Map<String, SolrConnector> mirrorConnectorCache = new ConcurrentHashMap<String, SolrConnector>();
    private Map<String, EmbeddedSolrConnector> embeddedConnectorCache = new ConcurrentHashMap<String, EmbeddedSolrConnector>();
    private Map<String, RemoteSolrConnector> remoteConnectorCache = new ConcurrentHashMap<String, RemoteSolrConnector>();

    public boolean isConnectedEmbedded() {
        return this.embeddedSolrInstance != null;
    }

    public void connectEmbedded(EmbeddedInstance c) {
        this.disconnectEmbedded();
        this.embeddedSolrInstance = c;
    }

    public EmbeddedInstance getEmbedded() {
        return this.embeddedSolrInstance;
    }

    public void disconnectEmbedded() {
        this.mirrorConnectorCache.clear();
        if (this.embeddedSolrInstance == null) {
            return;
        }
        HashSet<EmbeddedSolrConnector> connectors = new HashSet<EmbeddedSolrConnector>();
        connectors.addAll(this.embeddedConnectorCache.values());
        for (SolrConnector solrConnector : connectors) {
            solrConnector.close();
        }
        this.embeddedConnectorCache.clear();
        this.embeddedSolrInstance.close();
        this.embeddedSolrInstance = null;
    }

    public boolean isConnectedRemote() {
        return this.remoteSolrInstance != null;
    }

    public void connectRemote(ShardInstance c) {
        this.disconnectRemote();
        this.remoteSolrInstance = c;
    }

    public ShardInstance getRemote() {
        return this.remoteSolrInstance;
    }

    public void disconnectRemote() {
        this.mirrorConnectorCache.clear();
        if (this.remoteSolrInstance == null) {
            return;
        }
        for (RemoteSolrConnector connector : this.remoteConnectorCache.values()) {
            connector.close();
        }
        this.remoteConnectorCache.clear();
        this.remoteSolrInstance.close();
        this.remoteSolrInstance = null;
    }

    public synchronized void close() {
        HashSet<SolrConnector> connectors = new HashSet<SolrConnector>();
        connectors.addAll(this.mirrorConnectorCache.values());
        for (SolrConnector connector : connectors) {
            connector.close();
        }
        this.mirrorConnectorCache.clear();
        this.disconnectEmbedded();
    }

    public String getDefaultCoreName() {
        if (this.embeddedSolrInstance != null) {
            return this.embeddedSolrInstance.getDefaultCoreName();
        }
        if (this.remoteSolrInstance != null) {
            return this.remoteSolrInstance.getDefaultCoreName();
        }
        return null;
    }

    public Collection<String> getCoreNames() {
        if (this.embeddedSolrInstance != null) {
            return this.embeddedSolrInstance.getCoreNames();
        }
        if (this.remoteSolrInstance != null) {
            return this.remoteSolrInstance.getCoreNames();
        }
        return null;
    }

    public EmbeddedSolrConnector getDefaultEmbeddedConnector() {
        if (this.embeddedSolrInstance == null) {
            return null;
        }
        String coreName = this.getDefaultCoreName();
        if (coreName == null) {
            return null;
        }
        EmbeddedSolrConnector esc = this.embeddedConnectorCache.get(coreName);
        if (esc != null) {
            return esc;
        }
        esc = new EmbeddedSolrConnector(this.embeddedSolrInstance);
        this.embeddedConnectorCache.put(coreName, esc);
        return esc;
    }

    public RemoteSolrConnector getDefaultRemoteConnector(boolean useBinaryResponseWriter) throws IOException {
        if (this.remoteSolrInstance == null) {
            return null;
        }
        String coreName = this.getDefaultCoreName();
        if (coreName == null) {
            return null;
        }
        RemoteSolrConnector esc = this.remoteConnectorCache.get(coreName);
        if (esc != null) {
            return esc;
        }
        esc = new RemoteSolrConnector(this.remoteSolrInstance, useBinaryResponseWriter);
        this.remoteConnectorCache.put(coreName, esc);
        return esc;
    }

    public EmbeddedSolrConnector getEmbeddedConnector(String corename) {
        if (this.embeddedSolrInstance == null) {
            return null;
        }
        EmbeddedSolrConnector esc = this.embeddedConnectorCache.get(corename);
        if (esc != null) {
            return esc;
        }
        esc = new EmbeddedSolrConnector(this.embeddedSolrInstance, corename);
        this.embeddedConnectorCache.put(corename, esc);
        return esc;
    }

    public RemoteSolrConnector getRemoteConnector(String corename) {
        if (this.remoteSolrInstance == null) {
            return null;
        }
        RemoteSolrConnector rsc = this.remoteConnectorCache.get(corename);
        if (rsc != null) {
            return rsc;
        }
        boolean useBinaryResponseWriter = true;
        if (Switchboard.getSwitchboard() != null) {
            useBinaryResponseWriter = Switchboard.getSwitchboard().getConfigBool("remote.solr.binaryResponse.enabled", true);
        }
        rsc = new RemoteSolrConnector(this.remoteSolrInstance, useBinaryResponseWriter, corename);
        this.remoteConnectorCache.put(corename, rsc);
        return rsc;
    }

    public SolrConnector getDefaultMirrorConnector() {
        String coreName = this.getDefaultCoreName();
        if (coreName == null) {
            return null;
        }
        return this.getGenericMirrorConnector(coreName);
    }

    public SolrConnector getGenericMirrorConnector(String corename) {
        SolrConnector msc = this.mirrorConnectorCache.get(corename);
        if (msc != null) {
            return msc;
        }
        EmbeddedSolrConnector esc = this.getEmbeddedConnector(corename);
        RemoteSolrConnector rsc = this.getRemoteConnector(corename);
        msc = new MirrorSolrConnector(esc, rsc);
        this.mirrorConnectorCache.put(corename, msc);
        return msc;
    }

    public int bufferSize() {
        int b = 0;
        for (SolrConnector sc : this.mirrorConnectorCache.values()) {
            b += sc.bufferSize();
        }
        for (EmbeddedSolrConnector esc : this.embeddedConnectorCache.values()) {
            b += esc.bufferSize();
        }
        for (RemoteSolrConnector rsc : this.remoteConnectorCache.values()) {
            b += rsc.bufferSize();
        }
        return b;
    }

    public void clearCaches() {
        for (SolrConnector csc : this.mirrorConnectorCache.values()) {
            csc.clearCaches();
        }
        for (EmbeddedSolrConnector esc : this.embeddedConnectorCache.values()) {
            esc.clearCaches();
        }
        for (RemoteSolrConnector rsc : this.remoteConnectorCache.values()) {
            rsc.clearCaches();
        }
    }
}

