/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.yacy.cora.federate.AbstractFederateSearchConnector;
import net.yacy.cora.federate.solr.connector.RemoteSolrConnector;
import net.yacy.cora.federate.solr.instance.RemoteInstance;
import net.yacy.cora.storage.Configuration;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.search.Switchboard;
import net.yacy.search.query.QueryParams;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.ModifiableSolrParams;

public class SolrFederateSearchConnector
extends AbstractFederateSearchConnector {
    private String corename;

    @Override
    public boolean init(String instance, String cfgFileName) {
        boolean initResult = super.init(instance, cfgFileName);
        if (initResult) {
            if (this.localcfg.contains("_baseurl")) {
                this.setBaseurl(((Configuration.Entry)this.localcfg.get("_baseurl")).getValue());
            } else {
                ConcurrentLog.config(instance, "no _baseurl given in config file " + cfgFileName);
                initResult = false;
            }
            if (this.localcfg.contains("_corename")) {
                this.setCoreName(((Configuration.Entry)this.localcfg.get("_corename")).getValue());
            } else {
                ConcurrentLog.config(instance, "no _corename given in config file ");
                this.corename = "";
            }
        }
        return initResult;
    }

    public void setBaseurl(String url) {
        this.baseurl = url.endsWith("/") ? url : url + "/";
    }

    public void setCoreName(String core) {
        this.corename = core;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<URIMetadataNode> query(QueryParams query2) {
        ArrayList<URIMetadataNode> docs = new ArrayList<URIMetadataNode>();
        ArrayList<String> remotecorename = new ArrayList<String>();
        remotecorename.add(this.corename);
        SolrQuery msp = new SolrQuery(query2.getQueryGoal().getQueryString(false));
        msp.add("qt", new String[]{"/"});
        msp.add("rows", new String[]{Integer.toString(query2.itemsPerPage)});
        try {
            boolean trustSelfSignedOnAuthenticatedServer = false;
            if (Switchboard.getSwitchboard() != null) {
                trustSelfSignedOnAuthenticatedServer = Switchboard.getSwitchboard().getConfigBool("federated.service.solr.indexing.authenticated.allowSelfSigned", false);
            }
            try (RemoteInstance instance = new RemoteInstance(this.baseurl, remotecorename, this.corename, 20000, trustSelfSignedOnAuthenticatedServer, Long.MAX_VALUE, false);){
                boolean useBinaryResponseWriter = true;
                if (Switchboard.getSwitchboard() != null) {
                    useBinaryResponseWriter = Switchboard.getSwitchboard().getConfigBool("remote.solr.binaryResponse.enabled", true);
                }
                try (RemoteSolrConnector solrConnector = new RemoteSolrConnector(instance, useBinaryResponseWriter);){
                    this.lastaccesstime = System.currentTimeMillis();
                    SolrDocumentList docList = solrConnector.getDocumentListByParams((ModifiableSolrParams)msp);
                    Iterator iterator = docList.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            solrConnector.close();
                            return docs;
                        }
                        SolrDocument doc = (SolrDocument)iterator.next();
                        try {
                            URIMetadataNode anew = this.toYaCySchema(doc);
                            docs.add(anew);
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return docs;
    }
}

