/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.document.id;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import net.yacy.cora.document.analysis.Classification;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.Punycode;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.TimeoutRequest;
import net.yacy.cora.protocol.ftp.FTPClient;
import net.yacy.cora.protocol.http.HTTPClient;
import net.yacy.cora.util.CommonPattern;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.HTTPInputStream;
import net.yacy.crawler.retrieval.Response;
import org.apache.http.HttpResponse;

public class MultiProtocolURL
implements Serializable,
Comparable<MultiProtocolURL> {
    private static final long serialVersionUID = -1173233022912141884L;
    private static final long SMB_TIMEOUT = 5000L;
    public static final int TLD_any_zone_filter = 255;
    private static final Pattern backPathPattern;
    private static final Pattern patternMail;
    private static final BitSet UNRESERVED_RFC1738;
    private static final BitSet UNRESERVED_PATH;
    private static final BitSet PATTERN_METACHARACTERS;
    private static final Object PRESENT;
    private static final ConcurrentHashMap<String, Object> sessionIDnames;
    protected final String protocol;
    protected final String userInfo;
    protected String host;
    protected String path;
    protected String searchpart;
    protected String anchor;
    protected int port;
    protected InetAddress hostAddress;
    protected Classification.ContentDomain contentDomain;
    private static final String[] hex;
    private static final String splitrex = " |/|\\(|\\)|-|\\:|_|\\.|,|\\?|!|'|\"";
    public static final Pattern splitpattern;

    public static final void initSessionIDNames(Set<String> idNames) {
        for (String s : idNames) {
            if (s == null || (s = s.trim()).isEmpty()) continue;
            sessionIDnames.put(s, PRESENT);
        }
    }

    protected MultiProtocolURL() {
        this.protocol = null;
        this.host = null;
        this.hostAddress = null;
        this.userInfo = null;
        this.path = null;
        this.searchpart = null;
        this.anchor = null;
        this.contentDomain = null;
        this.port = -1;
    }

    public MultiProtocolURL(File file) throws MalformedURLException {
        this("file", "", -1, file.getAbsolutePath());
    }

    protected MultiProtocolURL(MultiProtocolURL url) {
        this.protocol = url.protocol;
        this.host = url.host;
        this.hostAddress = null;
        this.userInfo = url.userInfo;
        this.path = url.path;
        this.searchpart = url.searchpart;
        this.anchor = url.anchor;
        this.contentDomain = null;
        this.port = url.port;
    }

    public MultiProtocolURL(String url) throws MalformedURLException {
        int p;
        if (url == null) {
            throw new MalformedURLException("url string is null");
        }
        this.hostAddress = null;
        this.contentDomain = null;
        if (((String)(url = ((String)url).trim())).startsWith("//")) {
            url = "http:" + (String)url;
        }
        if (((String)url).startsWith("\\\\")) {
            url = "smb://" + CommonPattern.BACKSLASH.matcher(((String)url).substring(2)).replaceAll("/");
        }
        if (((String)url).length() > 1 && ((String)url).charAt(1) == ':' && Character.isLetter(((String)url).charAt(0))) {
            url = "file://" + (String)url;
        }
        if (((String)url).length() > 0 && ((String)url).charAt(0) == '/') {
            url = "file://" + (String)url;
        }
        if ((p = ((String)url).lastIndexOf("://", 5)) < 0) {
            if (((String)url).length() > 7 && ((String)url).substring(0, 7).equalsIgnoreCase("mailto:")) {
                p = 6;
            } else {
                url = "http://" + (String)url;
                p = 4;
            }
        }
        this.protocol = ((String)url).substring(0, p).toLowerCase(Locale.ROOT).trim().intern();
        if (((String)url).length() < p + 4) {
            throw new MalformedURLException("URL not parseable: '" + (String)url + "'");
        }
        if (!this.protocol.equals("file") && ((String)url).substring(p + 1, p + 3).equals("//")) {
            int q = ((String)url).indexOf(47, p + 3);
            if (q < 0) {
                q = ((String)url).indexOf("?", p + 3);
            } else if (((String)url).lastIndexOf("?", q) >= 0) {
                q = ((String)url).indexOf("?", p + 3);
            }
            if (q < 0) {
                q = ((String)url).indexOf("#", p + 3);
            }
            if (q < 0) {
                int r = ((String)url).indexOf(64, p + 3);
                if (r < 0) {
                    this.host = ((String)url).substring(p + 3).intern();
                    this.userInfo = null;
                } else {
                    this.host = ((String)url).substring(r + 1).intern();
                    this.userInfo = ((String)url).substring(p + 3, r);
                }
                this.path = "/";
            } else {
                this.host = ((String)url).substring(p + 3, q).trim().intern();
                int r = this.host.indexOf(64);
                if (r < 0) {
                    this.userInfo = null;
                } else {
                    this.userInfo = this.host.substring(0, r);
                    this.host = this.host.substring(r + 1).intern();
                }
                this.path = ((String)url).substring(q);
            }
            if (this.host.length() < 4 && !this.protocol.equals("file")) {
                throw new MalformedURLException("host too short: '" + this.host + "', url = " + (String)url);
            }
            if (this.host.indexOf(38) >= 0) {
                throw new MalformedURLException("invalid '&' in host");
            }
            this.path = MultiProtocolURL.resolveBackpath(this.path);
            this.identPort((String)url, this.isHTTP() ? 80 : (this.isHTTPS() ? 443 : (this.isFTP() ? 21 : (this.isSMB() ? 445 : -1))));
            if (this.port < 0) {
                throw new MalformedURLException("unknown protocol: " + (String)url);
            }
            this.identAnchor();
            this.identSearchpart();
            this.escape();
        } else {
            url = UTF8.decodeURL((String)url);
            if (this.protocol.equals("mailto")) {
                int q = ((String)url).indexOf(64, p + 3);
                if (q < 0) {
                    throw new MalformedURLException("wrong email address: " + (String)url);
                }
                this.userInfo = ((String)url).substring(p + 1, q);
                this.host = ((String)url).substring(q + 1);
                this.path = "";
                this.port = -1;
                this.searchpart = null;
                this.anchor = null;
            } else if (this.protocol.equals("file")) {
                Object h = ((String)url).substring(p + 1);
                this.host = null;
                if (((String)h).startsWith("///")) {
                    this.path = ((String)h).substring(2);
                } else if (((String)h).startsWith("//")) {
                    int q;
                    if (((String)h).length() > 4 && ((String)h).charAt(3) == ':' && ((String)h).charAt(4) != '/' && ((String)h).charAt(4) != '\\') {
                        h = ((String)h).substring(0, 4) + "/" + ((String)h).substring(4);
                    }
                    if ((q = ((String)h).indexOf(47, 2)) < 0 || ((String)h).length() > 3 && ((String)h).charAt(3) == ':') {
                        this.path = "/" + ((String)h).substring(2);
                    } else {
                        this.host = ((String)h).substring(2, q);
                        if (this.host.equalsIgnoreCase("localhost")) {
                            this.host = null;
                        }
                        this.path = ((String)h).substring(q);
                    }
                } else if (((String)h).startsWith("/")) {
                    this.path = h;
                }
                this.userInfo = null;
                this.port = -1;
                this.searchpart = null;
                this.anchor = null;
            } else {
                throw new MalformedURLException("unknown protocol: " + (String)url);
            }
        }
        if (!Punycode.isBasic(this.host)) {
            try {
                this.host = MultiProtocolURL.toPunycode(this.host);
            }
            catch (Punycode.PunycodeException punycodeException) {
                // empty catch block
            }
        }
    }

    public static String toPunycode(String host) throws Punycode.PunycodeException {
        String[] domainParts = CommonPattern.DOT.split(host, 0);
        StringBuilder buffer = new StringBuilder(80);
        for (int i = 0; i < domainParts.length; ++i) {
            String part = domainParts[i];
            if (!Punycode.isBasic(part)) {
                buffer.append("xn--").append(Punycode.encode(part));
            } else {
                buffer.append(part);
            }
            if (i == domainParts.length - 1) continue;
            buffer.append('.');
        }
        return buffer.toString();
    }

    public static final boolean isHTTP(String s) {
        return s.startsWith("http://");
    }

    public static final boolean isHTTPS(String s) {
        return s.startsWith("https://");
    }

    public static final boolean isFTP(String s) {
        return s.startsWith("ftp://");
    }

    public static final boolean isFile(String s) {
        return s.startsWith("file://");
    }

    public static final boolean isSMB(String s) {
        return s.startsWith("smb://") || s.startsWith("\\\\");
    }

    public final boolean isHTTP() {
        return this.protocol.equals("http");
    }

    public final boolean isHTTPS() {
        return this.protocol.equals("https");
    }

    public final boolean isFTP() {
        return this.protocol.equals("ftp");
    }

    public final boolean isFile() {
        return this.protocol.equals("file");
    }

    public final boolean isSMB() {
        return this.protocol.equals("smb");
    }

    public final Classification.ContentDomain getContentDomainFromExt() {
        if (this.contentDomain == null) {
            this.contentDomain = Classification.getContentDomainFromExt(MultiProtocolURL.getFileExtension(this.getFileName()));
        }
        return this.contentDomain;
    }

    @Deprecated
    public static MultiProtocolURL newURL(String baseURL, String relPath) throws MalformedURLException {
        if (((String)relPath).startsWith("//")) {
            relPath = "http:" + (String)relPath;
        }
        if (baseURL == null || MultiProtocolURL.isHTTP((String)relPath) || MultiProtocolURL.isHTTPS((String)relPath) || MultiProtocolURL.isFTP((String)relPath) || MultiProtocolURL.isFile((String)relPath) || MultiProtocolURL.isSMB((String)relPath)) {
            return new MultiProtocolURL((String)relPath);
        }
        return new MultiProtocolURL(new MultiProtocolURL(baseURL), (String)relPath);
    }

    @Deprecated
    public static MultiProtocolURL newURL(MultiProtocolURL baseURL, String relPath) throws MalformedURLException {
        if (((String)relPath).startsWith("//")) {
            Object object = relPath = baseURL == null ? "http:" + (String)relPath : baseURL.getProtocol() + ":" + (String)relPath;
        }
        if (baseURL == null || MultiProtocolURL.isHTTP((String)relPath) || MultiProtocolURL.isHTTPS((String)relPath) || MultiProtocolURL.isFTP((String)relPath) || MultiProtocolURL.isFile((String)relPath) || MultiProtocolURL.isSMB((String)relPath)) {
            return new MultiProtocolURL((String)relPath);
        }
        return new MultiProtocolURL(baseURL, (String)relPath);
    }

    public MultiProtocolURL(MultiProtocolURL baseURL, String relPath) throws MalformedURLException {
        if (baseURL == null) {
            throw new MalformedURLException("base URL is null");
        }
        if (relPath == null) {
            throw new MalformedURLException("relPath is null");
        }
        this.protocol = baseURL.protocol;
        this.host = baseURL.host;
        this.port = baseURL.port;
        this.userInfo = baseURL.userInfo;
        if (((String)relPath).startsWith("//")) {
            relPath = baseURL.protocol + ":" + (String)relPath;
        }
        if (((String)relPath).toLowerCase(Locale.ROOT).startsWith("javascript:")) {
            this.path = baseURL.path;
        } else if (MultiProtocolURL.isHTTP((String)relPath) || MultiProtocolURL.isHTTPS((String)relPath) || MultiProtocolURL.isFTP((String)relPath) || MultiProtocolURL.isFile((String)relPath) || MultiProtocolURL.isSMB((String)relPath)) {
            this.path = baseURL.path;
        } else {
            int q;
            if (((String)relPath).contains(":") && patternMail.matcher(((String)relPath).toLowerCase(Locale.ROOT)).find()) {
                throw new MalformedURLException("relative path malformed: " + (String)relPath);
            }
            this.path = ((String)relPath).length() > 0 && ((String)relPath).charAt(0) == '/' ? relPath : (baseURL.path.endsWith("/") ? (((String)relPath).startsWith("/") ? baseURL.path + ((String)relPath).substring(1) : baseURL.path + (String)relPath) : (((String)relPath).length() > 0 && (((String)relPath).charAt(0) == '#' || ((String)relPath).charAt(0) == '?') ? baseURL.path + (String)relPath : ((q = baseURL.path.lastIndexOf(47)) < 0 ? relPath : baseURL.path.substring(0, q + 1) + (String)relPath)));
        }
        this.searchpart = baseURL.searchpart;
        this.anchor = baseURL.anchor;
        this.path = MultiProtocolURL.resolveBackpath(this.path);
        this.identAnchor();
        this.identSearchpart();
        this.escape();
    }

    public MultiProtocolURL(String protocol, String host, int port, String path) throws MalformedURLException {
        if (protocol == null) {
            throw new MalformedURLException("protocol is null");
        }
        if (((String)host).indexOf(58) >= 0 && ((String)host).charAt(0) != '[') {
            host = "[" + (String)host + "]";
        }
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.path = path;
        this.searchpart = null;
        this.userInfo = null;
        this.anchor = null;
        this.identAnchor();
        this.identSearchpart();
        this.escape();
    }

    public MultiProtocolURL ofNewHost(String host) throws IllegalArgumentException {
        if (host == null || host.trim().isEmpty()) {
            throw new IllegalArgumentException("Host parameter must not be null");
        }
        MultiProtocolURL copy = new MultiProtocolURL(this);
        copy.host = host.indexOf(58) >= 0 && host.charAt(0) != '[' ? "[" + host + "]" : host;
        if (!Punycode.isBasic(this.host)) {
            try {
                this.host = MultiProtocolURL.toPunycode(this.host);
            }
            catch (Punycode.PunycodeException e) {
                ConcurrentLog.logException(e);
            }
        }
        return copy;
    }

    private static final String resolveBackpath(String path) {
        Matcher qm;
        Object p = path;
        if (((String)p).isEmpty() || ((String)p).charAt(0) != '/') {
            p = "/" + (String)p;
        }
        int end = (qm = CommonPattern.QUESTION.matcher((CharSequence)p)).find() ? qm.start() : ((String)p).length();
        Matcher matcher = backPathPattern.matcher((CharSequence)p);
        while (matcher.find() && matcher.start() <= end) {
            p = matcher.replaceAll("");
            matcher.reset((CharSequence)p);
        }
        while (((String)p).startsWith("/../")) {
            p = ((String)p).substring(3);
        }
        if (((String)p).equals("/..")) {
            p = "/";
        }
        return ((String)p).equals("") ? "/" : p;
    }

    private void escape() {
        if (this.path != null && this.path.indexOf(37) == -1) {
            this.path = MultiProtocolURL.escapePath(this.path);
        }
        if (this.searchpart != null && this.searchpart.indexOf(37) == -1) {
            this.escapeSearchpart();
        }
        if (this.anchor != null) {
            this.anchor = MultiProtocolURL.escape(this.anchor).toString();
        }
    }

    public static String escapePath(String pathToEscape) {
        return MultiProtocolURL.escapePath(pathToEscape, false);
    }

    public static String escapePathPattern(String pathPattern) {
        return MultiProtocolURL.escapePath(pathPattern, true);
    }

    private static String escapePath(String pathToEscape, boolean isPattern) {
        if (pathToEscape == null) {
            return pathToEscape;
        }
        StringBuilder ptmp = new StringBuilder(pathToEscape.length() + 10);
        boolean modified = false;
        int len = pathToEscape.length();
        for (int i = 0; i < len; ++i) {
            char ch = pathToEscape.charAt(i);
            if (ch == '%' && i + 2 < len) {
                char digit1 = pathToEscape.charAt(i + 1);
                char digit2 = pathToEscape.charAt(i + 2);
                if (MultiProtocolURL.isHexDigit(digit1) && MultiProtocolURL.isHexDigit(digit2)) {
                    ptmp.append(ch);
                    if (Character.isLowerCase(digit1) || Character.isLowerCase(digit2)) {
                        modified = true;
                    }
                    ptmp.append(Character.toUpperCase(digit1));
                    ptmp.append(Character.toUpperCase(digit2));
                    i += 2;
                    continue;
                }
                ptmp.append(hex[ch]);
                modified = true;
                continue;
            }
            if (isPattern && PATTERN_METACHARACTERS.get(ch)) {
                ptmp.append(ch);
                continue;
            }
            if (ch <= '\u007f') {
                if (UNRESERVED_PATH.get(ch)) {
                    ptmp.append(ch);
                    continue;
                }
                ptmp.append(hex[ch]);
                modified = true;
                continue;
            }
            if (ch <= '\u07ff') {
                ptmp.append(hex[0xC0 | ch >> 6]);
                ptmp.append(hex[0x80 | ch & 0x3F]);
                modified = true;
                continue;
            }
            ptmp.append(hex[0xE0 | ch >> 12]);
            ptmp.append(hex[0x80 | ch >> 6 & 0x3F]);
            ptmp.append(hex[0x80 | ch & 0x3F]);
            modified = true;
        }
        if (modified) {
            return ptmp.toString();
        }
        return pathToEscape;
    }

    public static final String unescapePath(String escaped) {
        if (escaped == null) {
            return escaped;
        }
        boolean modified = false;
        int len = escaped.length();
        StringBuilder unescaped = new StringBuilder(len > 500 ? len / 2 : len);
        Buffer utf8Bytes = null;
        for (int i = 0; i < len; ++i) {
            char ch = escaped.charAt(i);
            if (ch == '%' && i + 2 < len) {
                char digit1 = escaped.charAt(i + 1);
                char digit2 = escaped.charAt(i + 2);
                if (MultiProtocolURL.isHexDigit(digit1) && MultiProtocolURL.isHexDigit(digit2)) {
                    if (utf8Bytes == null) {
                        utf8Bytes = ByteBuffer.allocate((len - i) / 3);
                    }
                    int hexaValue = Integer.parseInt(escaped.substring(i + 1, i + 3), 16);
                    ((ByteBuffer)utf8Bytes).put((byte)hexaValue);
                    modified = true;
                    i += 2;
                    continue;
                }
                unescaped.append(ch);
                continue;
            }
            if (utf8Bytes != null && utf8Bytes.position() > 0) {
                unescaped.append(new String(((ByteBuffer)utf8Bytes).array(), 0, utf8Bytes.position(), StandardCharsets.UTF_8));
                ((ByteBuffer)utf8Bytes).position(0);
            }
            unescaped.append(ch);
        }
        if (utf8Bytes != null && utf8Bytes.position() > 0) {
            unescaped.append(new String(((ByteBuffer)utf8Bytes).array(), 0, utf8Bytes.position(), StandardCharsets.UTF_8));
        }
        return modified ? unescaped.toString() : escaped;
    }

    private static boolean isHexDigit(int character) {
        return character >= 48 && character <= 57 || character >= 97 && character <= 102 || character >= 65 && character <= 70;
    }

    private void escapeSearchpart() {
        StringBuilder qtmp = new StringBuilder(this.searchpart.length() + 10);
        for (Map.Entry<String, String> element : this.getAttributes().entrySet()) {
            qtmp.append('&');
            qtmp.append((CharSequence)MultiProtocolURL.escape(element.getKey()));
            qtmp.append('=');
            qtmp.append((CharSequence)MultiProtocolURL.escape(element.getValue()));
        }
        this.searchpart = qtmp.substring(qtmp.length() > 0 ? 1 : 0);
    }

    public static StringBuilder escape(String s) {
        int len = s.length();
        StringBuilder sbuf = new StringBuilder(len + 10);
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == ' ') {
                sbuf.append("%20");
                continue;
            }
            if (ch == '%') {
                if (i < len - 2 && s.charAt(i + 1) >= '0' && s.charAt(i + 1) <= '9' && s.charAt(i + 2) >= '0' && s.charAt(i + 2) <= '9') {
                    sbuf.append(ch);
                    continue;
                }
                sbuf.append("%25");
                continue;
            }
            if (ch == '&') {
                if (i < len - 6 && "amp;".equals(s.substring(i + 1, i + 5).toLowerCase(Locale.ROOT))) {
                    sbuf.append(ch);
                    continue;
                }
                sbuf.append("%26");
                continue;
            }
            if (ch == '#') {
                sbuf.append(ch);
                continue;
            }
            if (ch == '!' || ch == ':' || ch == '-' || ch == '_' || ch == '.' || ch == '~' || ch == '*' || ch == '\'' || ch == '(' || ch == ')' || ch == '{' || ch == '}' || ch == ';' || ch == ',' || ch == '=') {
                sbuf.append(ch);
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                sbuf.append(ch);
                continue;
            }
            if (ch == '/') {
                sbuf.append(ch);
                continue;
            }
            if ('A' <= ch && ch <= 'Z') {
                sbuf.append(ch);
                continue;
            }
            if ('a' <= ch && ch <= 'z') {
                sbuf.append(ch);
                continue;
            }
            if (ch <= '\u007f') {
                sbuf.append(hex[ch]);
                continue;
            }
            if (ch <= '\u07ff') {
                sbuf.append(hex[0xC0 | ch >> 6]);
                sbuf.append(hex[0x80 | ch & 0x3F]);
                continue;
            }
            sbuf.append(hex[0xE0 | ch >> 12]);
            sbuf.append(hex[0x80 | ch >> 6 & 0x3F]);
            sbuf.append(hex[0x80 | ch & 0x3F]);
        }
        return sbuf;
    }

    public static String unescape(String s) {
        try {
            return URLDecoder.decode(s, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            ConcurrentLog.logException(e);
            return s;
        }
        catch (Exception e) {
            return s;
        }
    }

    private void identPort(String inputURL, int dflt) throws MalformedURLException {
        int r;
        if (this.host == null) {
            this.port = dflt;
            return;
        }
        int pss = 0;
        int ip6 = this.host.indexOf(91);
        if (ip6 >= 0 && (ip6 = this.host.indexOf("]", ip6)) > 0) {
            pss = ip6 + 1;
        }
        if ((r = this.host.indexOf(":", pss)) < 0) {
            this.port = dflt;
        } else {
            try {
                String portStr = this.host.substring(r + 1);
                this.port = portStr.trim().length() > 0 ? Integer.parseInt(portStr) : dflt;
                this.host = this.host.substring(0, r);
            }
            catch (NumberFormatException e) {
                throw new MalformedURLException("wrong port in host fragment '" + this.host + "' of input url '" + inputURL + "'");
            }
        }
    }

    private void identAnchor() {
        int r = this.path.indexOf(35);
        if (r < 0) {
            this.anchor = null;
        } else {
            this.anchor = this.path.substring(r + 1);
            this.path = this.path.substring(0, r);
        }
    }

    private void identSearchpart() {
        int r = this.path.indexOf(63);
        if (r < 0) {
            this.searchpart = null;
        } else {
            this.searchpart = this.path.substring(r + 1);
            this.path = this.path.substring(0, r);
        }
    }

    public String getFile() {
        return this.getFile(false, false);
    }

    public String getFile(boolean excludeAnchor, boolean removeSessionID) {
        if (this.searchpart == null) {
            if (excludeAnchor || this.anchor == null) {
                return this.path;
            }
            StringBuilder sb = new StringBuilder(120);
            sb.append(this.path);
            sb.append('#');
            sb.append(this.anchor);
            return sb.toString();
        }
        Object q = this.searchpart;
        if (removeSessionID) {
            for (String sid : sessionIDnames.keySet()) {
                int p;
                if (((String)q).toLowerCase(Locale.ROOT).startsWith(sid.toLowerCase(Locale.ROOT) + "=")) {
                    p = ((String)q).indexOf(38);
                    if (p < 0) {
                        if (excludeAnchor || this.anchor == null) {
                            return this.path;
                        }
                        StringBuilder sb = new StringBuilder(120);
                        sb.append(this.path);
                        sb.append('#');
                        sb.append(this.anchor);
                        return sb.toString();
                    }
                    q = ((String)q).substring(p + 1);
                    continue;
                }
                p = ((String)q).toLowerCase(Locale.ROOT).indexOf("&" + sid.toLowerCase(Locale.ROOT) + "=", 0);
                if (p < 0) continue;
                int p1 = ((String)q).indexOf(38, p + 1);
                if (p1 < 0) {
                    q = ((String)q).substring(0, p);
                    continue;
                }
                q = ((String)q).substring(0, p) + ((String)q).substring(p1);
            }
        }
        StringBuilder sb = new StringBuilder(120);
        sb.append(this.path);
        sb.append('?');
        sb.append((String)q);
        if (excludeAnchor || this.anchor == null) {
            return sb.toString();
        }
        sb.append('#');
        sb.append(this.anchor);
        return sb.toString();
    }

    public String getFileName() {
        int p = this.path.lastIndexOf(47);
        if (p < 0) {
            return this.path;
        }
        if (p == this.path.length() - 1) {
            return "";
        }
        return this.path.substring(p + 1);
    }

    public static String getFileExtension(String fileName) {
        int p = fileName.lastIndexOf(46);
        if (p < 0) {
            return "";
        }
        int q = fileName.lastIndexOf(63);
        if (q < 0) {
            return fileName.substring(p + 1).toLowerCase(Locale.ROOT);
        }
        if (p > q && (p = fileName.lastIndexOf(46, q)) < 0) {
            return "";
        }
        return fileName.substring(p + 1, q).toLowerCase(Locale.ROOT);
    }

    public String getPath() {
        return this.path;
    }

    public String[] getPaths() {
        String s = this.path == null || this.path.length() < 1 ? "" : (this.path.charAt(0) == '/' ? this.path.substring(1) : this.path);
        int p = s.lastIndexOf(47);
        if (p < 0) {
            return new String[0];
        }
        s = s.substring(0, p);
        String[] paths = CommonPattern.SLASH.split(s);
        return paths;
    }

    public File getLocalFile() {
        char c = this.path.charAt(1);
        if (c == ':') {
            return new File(this.path);
        }
        if (c == '|') {
            return new File(this.path.charAt(0) + ":" + this.path.substring(2));
        }
        if (this.path.length() > 1 && ((c = this.path.charAt(2)) == ':' || c == '|')) {
            return new File(this.path.charAt(1) + ":" + this.path.substring(3));
        }
        return new File(this.path);
    }

    public String getAuthority() {
        return this.port >= 0 && this.host != null ? this.host + ":" + this.port : (this.host != null ? this.host : "");
    }

    public String getHost() {
        return this.host;
    }

    public String getOrganization() {
        String dnc = Domains.getDNC(this.host);
        String subdomOrga = this.host.length() - dnc.length() <= 0 ? "" : this.host.substring(0, this.host.length() - dnc.length() - 1);
        int p = subdomOrga.lastIndexOf(46);
        String orga = p < 0 ? subdomOrga : subdomOrga.substring(p + 1);
        return orga;
    }

    public String getTLD() {
        if (this.host == null) {
            return "";
        }
        int p = this.host.lastIndexOf(46);
        if (p < 0) {
            return "";
        }
        return this.host.substring(p + 1);
    }

    public InetAddress getInetAddress() {
        if (this.hostAddress != null) {
            return this.hostAddress;
        }
        if (this.host == null) {
            return null;
        }
        this.hostAddress = Domains.dnsResolve(this.host.toLowerCase(Locale.ROOT));
        return this.hostAddress;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRef() {
        return this.anchor;
    }

    public void removeRef() {
        this.anchor = null;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getSearchpart() {
        return this.searchpart;
    }

    public Map<String, String> getSearchpartMap() {
        if (this.searchpart == null) {
            return null;
        }
        this.searchpart = this.searchpart.replaceAll("&amp;", "&");
        String[] parts = CommonPattern.AMP.split(this.searchpart);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String part : parts) {
            int p = part.indexOf(61);
            if (p > 0) {
                map.put(part.substring(0, p), part.substring(p + 1));
                continue;
            }
            map.put(part, "");
        }
        return map;
    }

    public String toString() {
        return this.toNormalform(false);
    }

    public String toTokens() {
        return MultiProtocolURL.toTokens(MultiProtocolURL.unescape(this.urlstub(true, true)));
    }

    public static String toTokens(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isAlphabetic(c) || Character.isDigit(c)) {
                sb.append(c);
                continue;
            }
            sb.append(' ');
        }
        String[] u = CommonPattern.SPACES.split(sb);
        LinkedHashSet<String> token = new LinkedHashSet<String>();
        for (String r : u) {
            token.add(r);
        }
        for (String r : u) {
            token.addAll(MultiProtocolURL.parseCamelCase(r));
        }
        sb.setLength(0);
        for (String v : token) {
            if (v.length() < 1) continue;
            sb.append(v).append(' ');
        }
        return sb.length() == 0 ? "" : sb.substring(0, sb.length() - 1);
    }

    private static Set<String> parseCamelCase(String s) {
        CharType type;
        LinkedHashSet<String> token = new LinkedHashSet<String>();
        if (s.isEmpty()) {
            return token;
        }
        int p = 0;
        CharType nct = type = MultiProtocolURL.charType(s.charAt(0));
        while (p < s.length()) {
            while (p < s.length() && (nct = MultiProtocolURL.charType(s.charAt(p))) == type) {
                ++p;
            }
            if (p >= s.length()) {
                token.add(s);
                break;
            }
            if (nct == CharType.low) {
                type = CharType.low;
                ++p;
                continue;
            }
            token.add(s.substring(0, p));
            s = s.substring(p);
            p = 0;
            type = nct;
        }
        token.add(s);
        return token;
    }

    public Map<String, String> getAttributes() {
        String[] questp;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (this.searchpart == null) {
            return map;
        }
        for (String element : questp = CommonPattern.AMP.split(this.searchpart, -1)) {
            int p = element.indexOf(61);
            if (p != -1) {
                map.put(MultiProtocolURL.unescape(element.substring(0, p)), MultiProtocolURL.unescape(element.substring(p + 1)));
                continue;
            }
            if (element.isEmpty()) continue;
            map.put(MultiProtocolURL.unescape(element), "");
        }
        return map;
    }

    private static CharType charType(char c) {
        if (Character.isLowerCase(c)) {
            return CharType.low;
        }
        if (Character.isDigit(c)) {
            return CharType.number;
        }
        return CharType.high;
    }

    public String toNormalform(boolean excludeAnchor) {
        return this.toNormalform(excludeAnchor, false);
    }

    public String toNormalform(boolean excludeAnchor, boolean removeSessionID) {
        boolean defaultPort = false;
        if (this.protocol.equals("mailto")) {
            return this.protocol + ":" + this.userInfo + "@" + this.host;
        }
        if (this.isHTTP()) {
            if (this.port < 0 || this.port == 80) {
                defaultPort = true;
            }
        } else if (this.isHTTPS()) {
            if (this.port < 0 || this.port == 443) {
                defaultPort = true;
            }
        } else if (this.isFTP()) {
            if (this.port < 0 || this.port == 21) {
                defaultPort = true;
            }
        } else if (this.isSMB()) {
            if (this.port < 0 || this.port == 445) {
                defaultPort = true;
            }
        } else if (this.isFile()) {
            defaultPort = true;
        }
        String urlPath = this.getFile(excludeAnchor, removeSessionID);
        String h = this.getHost();
        StringBuilder u = new StringBuilder(20 + (urlPath == null ? 0 : urlPath.length()) + (h == null ? 0 : h.length()));
        u.append(this.protocol);
        u.append("://");
        if (h != null) {
            if (!(this.userInfo == null || this.isFTP() && this.userInfo.startsWith("anonymous"))) {
                u.append(this.userInfo);
                u.append("@");
            }
            u.append(h.toLowerCase(Locale.ROOT));
        }
        if (!defaultPort) {
            u.append(":");
            u.append(this.port);
        }
        if (this.isFile() && urlPath.indexOf(92) >= 0) {
            urlPath = urlPath.replace('\\', '/');
        }
        u.append(urlPath);
        String result = u.toString();
        return result;
    }

    public String urlstub(boolean excludeAnchor, boolean removeSessionID) {
        boolean defaultPort = false;
        if (this.protocol.equals("mailto")) {
            return this.userInfo + "@" + this.host;
        }
        if (this.isHTTP()) {
            if (this.port < 0 || this.port == 80) {
                defaultPort = true;
            }
        } else if (this.isHTTPS()) {
            if (this.port < 0 || this.port == 443) {
                defaultPort = true;
            }
        } else if (this.isFTP()) {
            if (this.port < 0 || this.port == 21) {
                defaultPort = true;
            }
        } else if (this.isSMB()) {
            if (this.port < 0 || this.port == 445) {
                defaultPort = true;
            }
        } else if (this.isFile()) {
            defaultPort = true;
        }
        String urlPath = this.getFile(excludeAnchor, removeSessionID);
        String h = this.getHost();
        StringBuilder u = new StringBuilder(20 + urlPath.length() + (h == null ? 0 : h.length()));
        if (h != null) {
            if (!(this.userInfo == null || this.isFTP() && this.userInfo.startsWith("anonymous"))) {
                u.append(this.userInfo);
                u.append("@");
            }
            u.append(h.toLowerCase(Locale.ROOT));
        }
        if (!defaultPort) {
            u.append(":");
            u.append(this.port);
        }
        u.append(urlPath);
        String result = u.toString();
        return result;
    }

    public int hashCode() {
        return (this.protocol == null ? 0 : this.protocol.hashCode() >> 2) + (this.host == null ? 0 : this.host.hashCode() >> 2) + (this.userInfo == null ? 0 : this.userInfo.hashCode() >> 2) + (this.path == null ? 0 : this.path.hashCode() >> 2) + (this.searchpart == null ? 0 : this.searchpart.hashCode() >> 2) + this.port;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiProtocolURL)) {
            return false;
        }
        MultiProtocolURL other = (MultiProtocolURL)obj;
        return (this.protocol == null && other.protocol == null || this.protocol != null && other.protocol != null && this.protocol.equals(other.protocol)) && (this.host == null && other.host == null || this.host != null && other.host != null && this.host.equals(other.host)) && (this.userInfo == null && other.userInfo == null || this.userInfo != null && other.userInfo != null && this.userInfo.equals(other.userInfo)) && (this.path == null && other.path == null || this.path != null && other.path != null && this.path.equals(other.path)) && (this.searchpart == null && other.searchpart == null || this.searchpart != null && other.searchpart != null && this.searchpart.equals(other.searchpart)) && this.port == other.port;
    }

    @Override
    public int compareTo(MultiProtocolURL h) {
        int c;
        if (this.protocol != null && h.protocol != null && (c = this.protocol.compareTo(h.protocol)) != 0) {
            return c;
        }
        if (this.host != null && h.host != null && (c = this.host.compareTo(h.host)) != 0) {
            return c;
        }
        if (this.userInfo != null && h.userInfo != null && (c = this.userInfo.compareTo(h.userInfo)) != 0) {
            return c;
        }
        if (this.path != null && h.path != null && (c = this.path.compareTo(h.path)) != 0) {
            return c;
        }
        if (this.searchpart != null && h.searchpart != null && (c = this.searchpart.compareTo(h.searchpart)) != 0) {
            return c;
        }
        return this.toNormalform(true).compareTo(h.toNormalform(true));
    }

    public boolean isPOST() {
        return this.searchpart != null && this.searchpart.length() > 0;
    }

    public static final boolean isCGI(String extension) {
        return extension != null && extension.length() > 0 && "cgi.exe".indexOf(extension.toLowerCase(Locale.ROOT)) >= 0;
    }

    @Deprecated
    public static final boolean isImage(String extension) {
        return extension != null && extension.length() > 0 && Response.docTypeExt(extension.toLowerCase(Locale.ROOT)) == 'i';
    }

    public final boolean isIndividual() {
        String q = MultiProtocolURL.unescape(this.path.toLowerCase(Locale.ROOT));
        for (String sid : sessionIDnames.keySet()) {
            if (q.startsWith(sid.toLowerCase(Locale.ROOT) + "=")) {
                return true;
            }
            int p = q.indexOf("&" + sid.toLowerCase(Locale.ROOT) + "=", 0);
            if (p < 0) continue;
            return true;
        }
        int pos = q.indexOf("sid", 0);
        return pos > 0 && (q.charAt(--pos) == '?' || q.charAt(pos) == '&' || q.charAt(pos) == ';') && (pos += 5) < q.length() && q.charAt(pos) != '&' && q.charAt(--pos) == '=' || (pos = q.indexOf("sessionid", 0)) > 0 && (pos += 10) < q.length() && q.charAt(pos) != '&' && (q.charAt(--pos) == '=' || q.charAt(pos) == '/') || (pos = q.indexOf("phpsessid", 0)) > 0 && (pos += 10) < q.length() && q.charAt(pos) != '&' && (q.charAt(--pos) == '=' || q.charAt(pos) == '/');
    }

    public boolean isLocal() {
        return this.isFile() || this.isSMB() || Domains.isLocal(this.host, this.hostAddress);
    }

    public final String language() {
        String language = "en";
        if (this.host == null) {
            return language;
        }
        int pos = this.host.lastIndexOf(46);
        String host_tld = this.host.substring(pos + 1).toLowerCase(Locale.ROOT);
        if (pos == 0) {
            return language;
        }
        int length = this.host.length() - pos - 1;
        switch (length) {
            case 2: {
                char firstletter = host_tld.charAt(0);
                switch (firstletter) {
                    case 'a': {
                        if (host_tld.equals("au")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("at")) {
                            language = "de";
                            break;
                        }
                        if (host_tld.equals("ar")) {
                            language = "es";
                            break;
                        }
                        if (host_tld.equals("ae")) {
                            language = "ar";
                            break;
                        }
                        if (host_tld.equals("am")) {
                            language = "hy";
                            break;
                        }
                        if (host_tld.equals("ac")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("az")) {
                            language = "az";
                            break;
                        }
                        if (host_tld.equals("ag")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("as")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("al")) {
                            language = "sq";
                            break;
                        }
                        if (host_tld.equals("ad")) {
                            language = "ca";
                            break;
                        }
                        if (host_tld.equals("ao")) {
                            language = "pt";
                            break;
                        }
                        if (host_tld.equals("ai")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("af")) {
                            language = "ps";
                            break;
                        }
                        if (host_tld.equals("an")) {
                            language = "nl";
                            break;
                        }
                        if (host_tld.equals("aq")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("aw")) {
                            language = "nl";
                            break;
                        }
                        if (!host_tld.equals("ax")) break;
                        language = "sv";
                        break;
                    }
                    case 'b': {
                        if (host_tld.equals("br")) {
                            language = "pt";
                            break;
                        }
                        if (host_tld.equals("be")) {
                            language = "nl";
                            break;
                        }
                        if (host_tld.equals("bg")) {
                            language = "bg";
                            break;
                        }
                        if (host_tld.equals("bz")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("ba")) {
                            language = "sh";
                            break;
                        }
                        if (host_tld.equals("by")) {
                            language = "be";
                            break;
                        }
                        if (host_tld.equals("bo")) {
                            language = "es";
                            break;
                        }
                        if (host_tld.equals("bd")) {
                            language = "bn";
                            break;
                        }
                        if (host_tld.equals("bw")) {
                            language = "tn";
                            break;
                        }
                        if (host_tld.equals("bh")) {
                            language = "ar";
                            break;
                        }
                        if (host_tld.equals("bf")) {
                            language = "fr";
                            break;
                        }
                        if (host_tld.equals("bm")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("bn")) {
                            language = "ms";
                            break;
                        }
                        if (host_tld.equals("bb")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("bt")) {
                            language = "dz";
                            break;
                        }
                        if (host_tld.equals("bi")) {
                            language = "rn";
                            break;
                        }
                        if (host_tld.equals("bs")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("bj")) {
                            language = "fr";
                            break;
                        }
                        if (!host_tld.equals("bv")) break;
                        language = "no";
                        break;
                    }
                    case 'c': {
                        if (host_tld.equals("ca")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("ch")) {
                            language = "de";
                            break;
                        }
                        if (host_tld.equals("cn")) {
                            language = "zh";
                            break;
                        }
                        if (host_tld.equals("cz")) {
                            language = "cs";
                            break;
                        }
                        if (host_tld.equals("cl")) {
                            language = "es";
                            break;
                        }
                        if (host_tld.equals("co")) {
                            language = "es";
                            break;
                        }
                        if (host_tld.equals("cc")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("cr")) {
                            language = "es";
                            break;
                        }
                        if (host_tld.equals("cy")) {
                            language = "el";
                            break;
                        }
                        if (host_tld.equals("cu")) {
                            language = "es";
                            break;
                        }
                        if (host_tld.equals("cx")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("cd")) {
                            language = "fr";
                            break;
                        }
                        if (host_tld.equals("cg")) {
                            language = "fr";
                            break;
                        }
                        if (host_tld.equals("cm")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("ci")) {
                            language = "fr";
                            break;
                        }
                        if (host_tld.equals("cv")) {
                            language = "pt";
                            break;
                        }
                        if (host_tld.equals("ck")) {
                            language = "en";
                            break;
                        }
                        if (!host_tld.equals("cf")) break;
                        language = "sg";
                        break;
                    }
                    case 'd': {
                        if (host_tld.equals("dk")) {
                            language = "da";
                            break;
                        }
                        if (host_tld.equals("do")) {
                            language = "es";
                            break;
                        }
                        if (host_tld.equals("dz")) {
                            language = "ar";
                            break;
                        }
                        if (host_tld.equals("dj")) {
                            language = "ar";
                            break;
                        }
                        if (!host_tld.equals("dm")) break;
                        language = "en";
                        break;
                    }
                    case 'e': {
                        if (host_tld.equals("ee")) {
                            language = "et";
                            break;
                        }
                        if (host_tld.equals("eg")) {
                            language = "ar";
                            break;
                        }
                        if (host_tld.equals("ec")) {
                            language = "es";
                            break;
                        }
                        if (host_tld.equals("et")) {
                            language = "am";
                            break;
                        }
                        if (host_tld.equals("eu")) {
                            language = "en";
                            break;
                        }
                        if (!host_tld.equals("er")) break;
                        language = "ti";
                        break;
                    }
                    case 'f': {
                        if (host_tld.equals("fr")) {
                            language = "fr";
                            break;
                        }
                        if (host_tld.equals("fi")) {
                            language = "fi";
                            break;
                        }
                        if (host_tld.equals("fm")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("fo")) {
                            language = "fo";
                            break;
                        }
                        if (host_tld.equals("fj")) {
                            language = "fj";
                            break;
                        }
                        if (!host_tld.equals("fk")) break;
                        language = "en";
                        break;
                    }
                    case 'g': {
                        if (host_tld.equals("gr")) {
                            language = "el";
                            break;
                        }
                        if (host_tld.equals("ge")) {
                            language = "ka";
                            break;
                        }
                        if (host_tld.equals("gt")) {
                            language = "es";
                            break;
                        }
                        if (host_tld.equals("gs")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("gl")) {
                            language = "kl";
                            break;
                        }
                        if (host_tld.equals("gg")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("gi")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("gh")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("gy")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("gm")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("gn")) {
                            language = "fr";
                            break;
                        }
                        if (host_tld.equals("ga")) {
                            language = "fr";
                            break;
                        }
                        if (host_tld.equals("gd")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("gu")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("gq")) {
                            language = "es";
                            break;
                        }
                        if (host_tld.equals("gp")) {
                            language = "fr";
                            break;
                        }
                        if (host_tld.equals("gf")) {
                            language = "fr";
                            break;
                        }
                        if (host_tld.equals("gb")) {
                            language = "en";
                            break;
                        }
                        if (!host_tld.equals("gw")) break;
                        language = "pt";
                        break;
                    }
                    case 'h': {
                        if (host_tld.equals("hu")) {
                            language = "hu";
                            break;
                        }
                        if (host_tld.equals("hk")) {
                            language = "zh";
                            break;
                        }
                        if (host_tld.equals("hr")) {
                            language = "hr";
                            break;
                        }
                        if (host_tld.equals("hn")) {
                            language = "es";
                            break;
                        }
                        if (host_tld.equals("hm")) {
                            language = "en";
                            break;
                        }
                        if (!host_tld.equals("ht")) break;
                        language = "fr";
                        break;
                    }
                    case 'i': {
                        if (host_tld.equals("it")) {
                            language = "it";
                            break;
                        }
                        if (host_tld.equals("il")) {
                            language = "he";
                            break;
                        }
                        if (host_tld.equals("ie")) {
                            language = "ga";
                            break;
                        }
                        if (host_tld.equals("in")) {
                            language = "hi";
                            break;
                        }
                        if (language.equals("is")) {
                            language = "is";
                            break;
                        }
                        if (host_tld.equals("ir")) {
                            language = "fa";
                            break;
                        }
                        if (host_tld.equals("im")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("io")) {
                            language = "en";
                            break;
                        }
                        if (!host_tld.equals("iq")) break;
                        language = "ar";
                        break;
                    }
                    case 'j': {
                        if (host_tld.equals("jp")) {
                            language = "ja";
                            break;
                        }
                        if (host_tld.equals("jo")) {
                            language = "ar";
                            break;
                        }
                        if (host_tld.equals("jm")) {
                            language = "en";
                            break;
                        }
                        if (!host_tld.equals("je")) break;
                        language = "en";
                        break;
                    }
                    case 'k': {
                        if (host_tld.equals("kr")) {
                            language = "ko";
                            break;
                        }
                        if (host_tld.equals("kz")) {
                            language = "kk";
                            break;
                        }
                        if (host_tld.equals("kg")) {
                            language = "ky";
                            break;
                        }
                        if (host_tld.equals("ki")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("kw")) {
                            language = "ar";
                            break;
                        }
                        if (host_tld.equals("ke")) {
                            language = "sw";
                            break;
                        }
                        if (host_tld.equals("kh")) {
                            language = "km";
                            break;
                        }
                        if (host_tld.equals("ky")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("kn")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("km")) {
                            language = "ar";
                            break;
                        }
                        if (!host_tld.equals("kp")) break;
                        language = "ko";
                        break;
                    }
                    case 'l': {
                        if (host_tld.equals("lv")) {
                            language = "lv";
                            break;
                        }
                        if (host_tld.equals("lt")) {
                            language = "lt";
                            break;
                        }
                        if (host_tld.equals("lu")) {
                            language = "lb";
                            break;
                        }
                        if (host_tld.equals("li")) {
                            language = "de";
                            break;
                        }
                        if (host_tld.equals("lb")) {
                            language = "ar";
                            break;
                        }
                        if (host_tld.equals("lk")) {
                            language = "si";
                            break;
                        }
                        if (host_tld.equals("la")) {
                            language = "lo";
                            break;
                        }
                        if (host_tld.equals("ly")) {
                            language = "ar";
                            break;
                        }
                        if (host_tld.equals("lc")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("ls")) {
                            language = "st";
                            break;
                        }
                        if (!host_tld.equals("lr")) break;
                        language = "en";
                        break;
                    }
                    case 'm': {
                        if (host_tld.equals("mx")) {
                            language = "es";
                            break;
                        }
                        if (host_tld.equals("my")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("md")) {
                            language = "ro";
                            break;
                        }
                        if (host_tld.equals("ma")) {
                            language = "ar";
                            break;
                        }
                        if (host_tld.equals("mk")) {
                            language = "mk";
                            break;
                        }
                        if (host_tld.equals("ms")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("mt")) {
                            language = "mt";
                            break;
                        }
                        if (host_tld.equals("mo")) {
                            language = "zh";
                            break;
                        }
                        if (host_tld.equals("mn")) {
                            language = "mn";
                            break;
                        }
                        if (host_tld.equals("mp")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("mu")) {
                            language = "fr";
                            break;
                        }
                        if (host_tld.equals("mm")) {
                            language = "my";
                            break;
                        }
                        if (host_tld.equals("mc")) {
                            language = "fr";
                            break;
                        }
                        if (host_tld.equals("me")) {
                            language = "sh";
                            break;
                        }
                        if (host_tld.equals("mz")) {
                            language = "pt";
                            break;
                        }
                        if (host_tld.equals("mg")) {
                            language = "mg";
                            break;
                        }
                        if (host_tld.equals("mr")) {
                            language = "ar";
                            break;
                        }
                        if (host_tld.equals("mv")) {
                            language = "dv";
                            break;
                        }
                        if (host_tld.equals("mw")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("ml")) {
                            language = "fr";
                            break;
                        }
                        if (host_tld.equals("mq")) {
                            language = "fr";
                            break;
                        }
                        if (!host_tld.equals("mh")) break;
                        language = "mh";
                        break;
                    }
                    case 'n': {
                        if (host_tld.equals("no")) {
                            language = "no";
                        } else if (host_tld.equals("nz")) {
                            language = "en";
                        } else if (host_tld.equals("nu")) {
                            language = "en";
                        } else if (host_tld.equals("ni")) {
                            language = "es";
                        } else if (host_tld.equals("np")) {
                            language = "ne";
                        }
                        if (host_tld.equals("na")) {
                            language = "af";
                            break;
                        }
                        if (host_tld.equals("nr")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("nc")) {
                            language = "fr";
                            break;
                        }
                        if (host_tld.equals("ne")) {
                            language = "fr";
                            break;
                        }
                        if (host_tld.equals("ng")) {
                            language = "en";
                            break;
                        }
                        if (!host_tld.equals("nf")) break;
                        language = "en";
                        break;
                    }
                    case 'o': {
                        if (!host_tld.equals("om")) break;
                        language = "ar";
                        break;
                    }
                    case 'p': {
                        if (host_tld.equals("pl")) {
                            language = "pl";
                            break;
                        }
                        if (host_tld.equals("pt")) {
                            language = "pt";
                            break;
                        }
                        if (host_tld.equals("ph")) {
                            language = "tl";
                            break;
                        }
                        if (host_tld.equals("pk")) {
                            language = "ur";
                            break;
                        }
                        if (host_tld.equals("pw")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("pe")) {
                            language = "es";
                            break;
                        }
                        if (host_tld.equals("pr")) {
                            language = "es";
                            break;
                        }
                        if (host_tld.equals("pa")) {
                            language = "es";
                            break;
                        }
                        if (host_tld.equals("py")) {
                            language = "gn";
                            break;
                        }
                        if (host_tld.equals("ps")) {
                            language = "ar";
                            break;
                        }
                        if (host_tld.equals("pf")) {
                            language = "fr";
                            break;
                        }
                        if (host_tld.equals("pg")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("pn")) {
                            language = "en";
                            break;
                        }
                        if (!host_tld.equals("pm")) break;
                        language = "fr";
                        break;
                    }
                    case 'q': {
                        if (!host_tld.equals("qa")) break;
                        language = "ar";
                        break;
                    }
                    case 'r': {
                        if (host_tld.equals("ru")) {
                            language = "ru";
                            break;
                        }
                        if (host_tld.equals("ro")) {
                            language = "ro";
                            break;
                        }
                        if (host_tld.equals("rs")) {
                            language = "sr";
                            break;
                        }
                        if (host_tld.equals("re")) {
                            language = "fr";
                            break;
                        }
                        if (!host_tld.equals("rw")) break;
                        language = "rw";
                        break;
                    }
                    case 's': {
                        if (host_tld.equals("se")) {
                            language = "sv";
                            break;
                        }
                        if (host_tld.equals("es")) {
                            language = "es";
                            break;
                        }
                        if (host_tld.equals("sg")) {
                            language = "zh";
                            break;
                        }
                        if (host_tld.equals("sk")) {
                            language = "sk";
                            break;
                        }
                        if (host_tld.equals("si")) {
                            language = "sl";
                            break;
                        }
                        if (host_tld.equals("su")) {
                            language = "ru";
                            break;
                        }
                        if (host_tld.equals("sa")) {
                            language = "ar";
                            break;
                        }
                        if (host_tld.equals("st")) {
                            language = "pt";
                            break;
                        }
                        if (host_tld.equals("sv")) {
                            language = "es";
                            break;
                        }
                        if (host_tld.equals("sc")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("sh")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("sn")) {
                            language = "wo";
                            break;
                        }
                        if (host_tld.equals("sr")) {
                            language = "nl";
                            break;
                        }
                        if (host_tld.equals("sm")) {
                            language = "it";
                            break;
                        }
                        if (host_tld.equals("sy")) {
                            language = "ar";
                            break;
                        }
                        if (host_tld.equals("sz")) {
                            language = "ss";
                            break;
                        }
                        if (host_tld.equals("sl")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("sb")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("sd")) {
                            language = "ar";
                            break;
                        }
                        if (host_tld.equals("so")) {
                            language = "so";
                            break;
                        }
                        if (!host_tld.equals("ss")) break;
                        language = "en";
                        break;
                    }
                    case 't': {
                        if (host_tld.equals("tw")) {
                            language = "zh";
                            break;
                        }
                        if (host_tld.equals("tr")) {
                            language = "tr";
                            break;
                        }
                        if (host_tld.equals("tv")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("th")) {
                            language = "th";
                            break;
                        }
                        if (host_tld.equals("tc")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("to")) {
                            language = "to";
                            break;
                        }
                        if (host_tld.equals("tk")) {
                            language = "to";
                            break;
                        }
                        if (host_tld.equals("tt")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("tn")) {
                            language = "ar";
                            break;
                        }
                        if (host_tld.equals("tf")) {
                            language = "fr";
                            break;
                        }
                        if (host_tld.equals("tz")) {
                            language = "sw";
                            break;
                        }
                        if (host_tld.equals("tj")) {
                            language = "tg";
                            break;
                        }
                        if (host_tld.equals("tp")) {
                            language = "pt";
                            break;
                        }
                        if (host_tld.equals("tm")) {
                            language = "tk";
                            break;
                        }
                        if (host_tld.equals("tg")) {
                            language = "fr";
                            break;
                        }
                        if (host_tld.equals("tl")) {
                            language = "id";
                            break;
                        }
                        if (!host_tld.equals("td")) break;
                        language = "ar";
                        break;
                    }
                    case 'u': {
                        if (host_tld.equals("uk")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("us")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("ua")) {
                            language = "uk";
                            break;
                        }
                        if (host_tld.equals("uz")) {
                            language = "uz";
                            break;
                        }
                        if (host_tld.equals("uy")) {
                            language = "es";
                            break;
                        }
                        if (!host_tld.equals("ug")) break;
                        language = "sw";
                        break;
                    }
                    case 'v': {
                        if (host_tld.equals("vu")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("ve")) {
                            language = "es";
                            break;
                        }
                        if (host_tld.equals("vn")) {
                            language = "vi";
                            break;
                        }
                        if (host_tld.equals("va")) {
                            language = "it";
                            break;
                        }
                        if (host_tld.equals("vg")) {
                            language = "en";
                            break;
                        }
                        if (host_tld.equals("vc")) {
                            language = "en";
                            break;
                        }
                        if (!host_tld.equals("vi")) break;
                        language = "en";
                        break;
                    }
                    case 'w': {
                        if (host_tld.equals("ws")) {
                            language = "sm";
                            break;
                        }
                        if (!host_tld.equals("wf")) break;
                        language = "fr";
                        break;
                    }
                    case 'x': {
                        break;
                    }
                    case 'y': {
                        if (host_tld.equals("yu")) {
                            language = "sh";
                            break;
                        }
                        if (host_tld.equals("ye")) {
                            language = "ar";
                            break;
                        }
                        if (!host_tld.equals("yt")) break;
                        language = "fr";
                        break;
                    }
                    case 'z': {
                        if (host_tld.equals("za")) {
                            language = "af";
                            break;
                        }
                        if (host_tld.equals("zw")) {
                            language = "sn";
                            break;
                        }
                        if (!host_tld.equals("zm")) break;
                        language = "en";
                    }
                }
                break;
            }
            case 3: {
                if (!host_tld.equals("cat")) break;
                language = "ca";
                break;
            }
            case 8: {
                if (host_tld.equals("xn--p1ai")) {
                    language = "ru";
                    break;
                }
                if (!host_tld.equals("xn--node")) break;
                language = "ka";
                break;
            }
            case 9: {
                if (!host_tld.equals("xn--j1amh")) break;
                language = "uk";
                break;
            }
            case 10: {
                if (host_tld.equals("xn--fiqs8s")) {
                    language = "zh";
                    break;
                }
                if (host_tld.equals("xn--fiqz9s")) {
                    language = "zh";
                    break;
                }
                if (host_tld.equals("xn--o3cw4h")) {
                    language = "th";
                    break;
                }
                if (host_tld.equals("xn--wgbh1c")) {
                    language = "ar";
                    break;
                }
                if (host_tld.equals("xn--wgbl6a")) {
                    language = "ar";
                    break;
                }
                if (host_tld.equals("xn--90a3ac")) {
                    language = "sr";
                    break;
                }
                if (!host_tld.equals("xn--wgv71a")) break;
                language = "ja";
                break;
            }
            case 11: {
                if (host_tld.equals("xn--kprw13d")) {
                    language = "zh";
                    break;
                }
                if (host_tld.equals("xn--kpry57d")) {
                    language = "zh";
                    break;
                }
                if (host_tld.equals("xn--j6w193g")) {
                    language = "zh";
                    break;
                }
                if (host_tld.equals("xn--h2brj9c")) {
                    language = "hi";
                    break;
                }
                if (host_tld.equals("xn--gecrj9c")) {
                    language = "gu";
                    break;
                }
                if (host_tld.equals("xn--s9brj9c")) {
                    language = "pa";
                    break;
                }
                if (host_tld.equals("xn--45brj9c")) {
                    language = "bn";
                    break;
                }
                if (host_tld.equals("xn--pgbs0dh")) {
                    language = "ar";
                    break;
                }
                if (!host_tld.equals("xn--80ao21a")) break;
                language = "kk";
                break;
            }
            case 12: {
                if (host_tld.equals("xn--3e0b707e")) {
                    language = "ko";
                    break;
                }
                if (host_tld.equals("xn--mgbtf8fl")) {
                    language = "ar";
                    break;
                }
                if (host_tld.equals("xn--4dbrk0ce")) {
                    language = "he";
                    break;
                }
                if (host_tld.equals("xn--mgb9awbf")) {
                    language = "ar";
                    break;
                }
                if (!host_tld.equals("xn--mgb2ddes")) break;
                language = "ar";
                break;
            }
            case 13: {
                if (host_tld.equals("xn--fpcrj9c3d")) {
                    language = "te";
                    break;
                }
                if (host_tld.equals("xn--yfro4i67o")) {
                    language = "zh";
                    break;
                }
                if (host_tld.equals("xn--fzc2c9e2c")) {
                    language = "si";
                    break;
                }
                if (!host_tld.equals("xn--ygbi2ammx")) break;
                language = "ar";
                break;
            }
            case 14: {
                if (host_tld.equals("xn--mgbbh1a71e")) {
                    language = "ur";
                    break;
                }
                if (host_tld.equals("xn--mgbaam7a8h")) {
                    language = "ar";
                    break;
                }
                if (host_tld.equals("xn--mgbayh7gpa")) {
                    language = "ar";
                    break;
                }
                if (host_tld.equals("xn--mgbx4cd0ab")) {
                    language = "ar";
                    break;
                }
                if (!host_tld.equals("xn--54b7fta0cc")) break;
                language = "bn";
                break;
            }
            case 15: {
                if (host_tld.equals("xn--mgbc0a9azcg")) {
                    language = "ar";
                    break;
                }
                if (host_tld.equals("xn--mgba3a4f16a")) {
                    language = "fa";
                    break;
                }
                if (!host_tld.equals("xn--lgbbat1ad8j")) break;
                language = "ar";
                break;
            }
            case 16: {
                if (!host_tld.equals("xn--xkc2al3hye2a")) break;
                language = "ta";
                break;
            }
            case 17: {
                if (host_tld.equals("xn--xkc2dl3a5ee0h")) {
                    language = "ta";
                    break;
                }
                if (host_tld.equals("xn--mgberp4a5d4ar")) {
                    language = "ar";
                    break;
                }
                if (!host_tld.equals("xn--mgbai9azgqp6j")) break;
                language = "ar";
                break;
            }
            case 22: {
                if (!host_tld.equals("xn--clchc0ea0b2g2a9gcd")) break;
                language = "ta";
                break;
            }
        }
        return language;
    }

    public URL getURL() throws MalformedURLException {
        if (!(this.isHTTP() || this.isHTTPS() || this.isFTP())) {
            throw new MalformedURLException();
        }
        try {
            return new URI(this.toNormalform(false)).toURL();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    public File getFSFile() throws MalformedURLException {
        if (!this.isFile()) {
            throw new MalformedURLException();
        }
        return new File(MultiProtocolURL.unescape(this.toNormalform(true)).substring("file://".length()));
    }

    public SmbFile getSmbFile() throws MalformedURLException {
        if (!this.isSMB()) {
            throw new MalformedURLException();
        }
        String url = MultiProtocolURL.unescape(this.toNormalform(true));
        return new SmbFile(url);
    }

    public boolean exists() throws IOException {
        if (this.isFile()) {
            return this.getFSFile().exists();
        }
        if (this.isSMB()) {
            try {
                return TimeoutRequest.exists(this.getSmbFile(), 5000L);
            }
            catch (SmbException e) {
                throw new IOException("SMB.exists SmbException (" + e.getMessage() + ") for " + this.toNormalform(false));
            }
            catch (MalformedURLException e) {
                throw new IOException("SMB.exists MalformedURLException (" + e.getMessage() + ") for " + this.toNormalform(false));
            }
        }
        return false;
    }

    public boolean canRead() throws IOException {
        if (this.isFile()) {
            return this.getFSFile().canRead();
        }
        if (this.isSMB()) {
            try {
                return TimeoutRequest.canRead(this.getSmbFile(), 5000L);
            }
            catch (SmbException e) {
                throw new IOException("SMB.canRead SmbException (" + e.getMessage() + ") for " + this.toNormalform(false));
            }
            catch (MalformedURLException e) {
                throw new IOException("SMB.canRead MalformedURLException (" + e.getMessage() + ") for " + this.toNormalform(false));
            }
        }
        return false;
    }

    public boolean canWrite() throws IOException {
        if (this.isFile()) {
            return this.getFSFile().canWrite();
        }
        if (this.isSMB()) {
            try {
                return TimeoutRequest.canWrite(this.getSmbFile(), 5000L);
            }
            catch (SmbException e) {
                throw new IOException("SMB.canWrite SmbException (" + e.getMessage() + ") for " + this.toNormalform(false));
            }
            catch (MalformedURLException e) {
                throw new IOException("SMB.canWrite MalformedURLException (" + e.getMessage() + ") for " + this.toNormalform(false));
            }
        }
        return false;
    }

    public boolean isHidden() throws IOException {
        if (this.isFile()) {
            return this.getFSFile().isHidden();
        }
        if (this.isSMB()) {
            try {
                return TimeoutRequest.isHidden(this.getSmbFile(), 5000L);
            }
            catch (SmbException e) {
                throw new IOException("SMB.isHidden SmbException (" + e.getMessage() + ") for " + this.toNormalform(false));
            }
            catch (MalformedURLException e) {
                throw new IOException("SMB.isHidden MalformedURLException (" + e.getMessage() + ") for " + this.toNormalform(false));
            }
        }
        return false;
    }

    public boolean isDirectory() throws IOException {
        if (this.isFile()) {
            return this.getFSFile().isDirectory();
        }
        if (this.isSMB()) {
            try {
                return TimeoutRequest.isDirectory(this.getSmbFile(), 5000L);
            }
            catch (SmbException e) {
                throw new IOException("SMB.isDirectory SmbException (" + e.getMessage() + ") for " + this.toNormalform(false));
            }
            catch (MalformedURLException e) {
                throw new IOException("SMB.isDirectory MalformedURLException (" + e.getMessage() + ") for " + this.toNormalform(false));
            }
        }
        return false;
    }

    public long length() {
        if (this.isFile()) {
            try {
                return this.getFSFile().length();
            }
            catch (Throwable e) {
                ConcurrentLog.logException(e);
                return -1L;
            }
        }
        if (this.isSMB()) {
            try {
                return this.getSmbFile().length();
            }
            catch (Throwable e) {
                ConcurrentLog.logException(e);
                return -1L;
            }
        }
        return -1L;
    }

    public long lastModified() throws IOException {
        if (this.isFile()) {
            return this.getFSFile().lastModified();
        }
        if (this.isSMB()) {
            try {
                return this.getSmbFile().lastModified();
            }
            catch (SmbException e) {
                throw new IOException("SMB.lastModified SmbException (" + e.getMessage() + ") for " + this.toNormalform(false));
            }
            catch (MalformedURLException e) {
                throw new IOException("SMB.lastModified MalformedURLException (" + e.getMessage() + ") for " + this.toNormalform(false));
            }
        }
        return 0L;
    }

    public String getName() throws IOException {
        if (this.isFile()) {
            return this.getFSFile().getName();
        }
        if (this.isSMB()) {
            try {
                return this.getSmbFile().getName();
            }
            catch (MalformedURLException e) {
                throw new IOException("SMB.getName MalformedURLException (" + e.getMessage() + ") for " + this.toNormalform(false));
            }
        }
        if (this.isFTP()) {
            return this.getFileName();
        }
        return null;
    }

    public String[] list() throws IOException {
        if (this.isFile() && !this.isHidden()) {
            return this.getFSFile().list();
        }
        if (this.isSMB()) {
            try {
                SmbFile sf = this.getSmbFile();
                if (!sf.isDirectory() || sf.isHidden()) {
                    return null;
                }
                try {
                    return TimeoutRequest.list(sf, 5000L);
                }
                catch (SmbException e) {
                    throw new IOException("SMB.list SmbException for " + sf.toString() + ": " + e.getMessage());
                }
            }
            catch (MalformedURLException e) {
                throw new IOException("SMB.list MalformedURLException for " + this.toNormalform(false) + ": " + e.getMessage());
            }
        }
        return null;
    }

    public InputStream getInputStream(ClientIdentification.Agent agent) throws IOException {
        if (this.isFile()) {
            return new BufferedInputStream(new FileInputStream(this.getFSFile()));
        }
        if (this.isSMB()) {
            return new BufferedInputStream((InputStream)new SmbFileInputStream(this.getSmbFile()));
        }
        if (this.isFTP()) {
            FTPClient client = new FTPClient();
            client.open(this.host, this.port < 0 ? 21 : this.port);
            byte[] b = client.get(this.path);
            client.CLOSE();
            return new ByteArrayInputStream(b);
        }
        if (this.isHTTP() || this.isHTTPS()) {
            try (HTTPClient client = new HTTPClient(agent);){
                client.setHost(this.getHost());
                client.GET(this, false);
                if (client.getStatusCode() != 200) {
                    throw new IOException("Unable to open http stream on " + this.toString() + "\nServer returned status: " + String.valueOf(client.getHttpResponse().getStatusLine()));
                }
                HTTPInputStream hTTPInputStream = new HTTPInputStream(client);
                return hTTPInputStream;
            }
        }
        return null;
    }

    public byte[] get(ClientIdentification.Agent agent, String username, String pass) throws IOException {
        if (this.isFile()) {
            byte[] b = MultiProtocolURL.read(new FileInputStream(this.getFSFile()));
            return b;
        }
        if (this.isSMB()) {
            byte[] b = MultiProtocolURL.read((InputStream)new SmbFileInputStream(this.getSmbFile()));
            return b;
        }
        if (this.isFTP()) {
            FTPClient client = new FTPClient();
            client.open(this.host, this.port < 0 ? 21 : this.port);
            byte[] b = client.get(this.path);
            client.CLOSE();
            return b;
        }
        if (this.isHTTP() || this.isHTTPS()) {
            try (HTTPClient client = new HTTPClient(agent);){
                client.setHost(this.getHost());
                byte[] byArray = client.GETbytes(this, username, pass, false);
                return byArray;
            }
        }
        return null;
    }

    public boolean exists(ClientIdentification.Agent agent) {
        try {
            if (this.isFile()) {
                return this.getFSFile().exists();
            }
            if (this.isSMB()) {
                return this.getSmbFile().exists();
            }
            if (this.isFTP()) {
                FTPClient client = new FTPClient();
                client.open(this.host, this.port < 0 ? 21 : this.port);
                return client.fileSize(this.path) > 0L;
            }
            if (this.isHTTP() || this.isHTTPS()) {
                HTTPClient client = new HTTPClient(agent);
                client.setHost(this.getHost());
                HttpResponse response = client.HEADResponse(this, true);
                client.close();
                if (response == null) {
                    return false;
                }
                int status = response.getStatusLine().getStatusCode();
                return status == 200 || status == 301 || status == 302;
            }
            return false;
        }
        catch (IOException e) {
            return e.getMessage().contains("Circular redirect to");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(InputStream source) throws IOException {
        try {
            int c;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            while ((c = source.read(buffer, 0, 2048)) > 0) {
                baos.write(buffer, 0, c);
            }
            baos.flush();
            baos.close();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            try {
                source.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Locale getLocale() {
        Locale locale;
        if (this.hostAddress != null && (locale = Domains.getLocale(this.hostAddress)) != null && locale.getCountry() != null && locale.getCountry().length() > 0) {
            return locale;
        }
        return Domains.getLocale(this.host);
    }

    public static String[] urlComps(String normalizedURL) {
        int p = normalizedURL.indexOf("//", 0);
        if (p > 0) {
            normalizedURL = normalizedURL.substring(p + 2);
        }
        return splitpattern.split(normalizedURL.toLowerCase());
    }

    public static void main(String[] args) {
        String[][] test2;
        for (String[] element : test2 = new String[][]{{null, "file://y:/"}, {null, "file://y:/yacy"}, {null, "file://y:/yacy/"}, {null, "file://y:"}, {null, "file://Z:admin\\home"}, {null, "file://Z:\\admin\\home"}, {null, "https://www.example.com/shoe/?p=2&ps=75#t={%22san_NaviPaging%22:2}"}, {null, "C:WINDOWS\\CMD0.EXE"}, {null, "file://C:WINDOWS\\CMD0.EXE"}, {null, "file:///bin/yacy2"}, {null, "file:/bin/yacy1"}, {null, "file:C:WINDOWS\\CMD.EXE"}, {null, "file:///C:WINDOWS\\CMD1.EXE"}, {null, "file:///C|WINDOWS\\CMD2.EXE"}, {null, "http://www.anomic.de/test/"}, {null, "http://www.anomic.de/"}, {null, "http://www.anomic.de"}, {null, "http://www.anomic.de/home/test?x=1#home"}, {null, "http://www.anomic.de/home/test?x=1"}, {null, "http://www.anomic.de/home/test#home"}, {null, "ftp://ftp.anomic.de/home/test#home"}, {null, "ftp://bob:builder@ftp.anomic.de/home/test.gif"}, {null, "http://www.anomic.de/home/../abc/"}, {null, "mailto:abcdefg@nomailnomail.com"}, {"http://www.anomic.de/home", "test"}, {"http://www.anomic.de/home", "test/"}, {"http://www.anomic.de/home/", "test"}, {"http://www.anomic.de/home/", "test/"}, {"http://www.anomic.de/home/index.html", "test.htm"}, {"http://www.anomic.de/home/index.html", "http://www.yacy.net/test"}, {"http://www.anomic.de/home/index.html", "ftp://ftp.yacy.net/test"}, {"http://www.anomic.de/home/index.html", "../test"}, {"http://www.anomic.de/home/index.html", "mailto:abcdefg@nomailnomail.com"}, {null, "news:de.test"}, {"http://www.anomic.de/home", "news:de.test"}, {null, "mailto:bob@web.com"}, {"http://www.anomic.de/home", "mailto:bob@web.com"}, {"http://www.anomic.de/home", "ftp://ftp.anomic.de/src"}, {null, "ftp://ftp.delegate.org/"}, {"http://www.anomic.de/home", "ftp://ftp.delegate.org/"}, {"http://www.anomic.de", "mailto:yacy@weltherrschaft.org"}, {"http://www.anomic.de", "javascipt:temp"}, {null, "http://yacy-websuche.de/wiki/index.php?title=De:IntroInformationFreedom&action=history"}, {null, "http://diskusjion.no/index.php?s=5bad5f431a106d9a8355429b81bb0ca5&showuser=23585"}, {null, "http://diskusjion.no/index.php?s=5bad5f431a106d9a8355429b81bb0ca5&amp;showuser=23585"}, {null, "http://www.scc.kit.edu/publikationen/80.php?PHPSESSID=5f3624d3e1c33d4c086ab600d4d5f5a1"}, {null, "smb://localhost/"}, {null, "smb://localhost/repository"}, {null, "smb://localhost/repository/"}, {null, "\\\\localhost\\"}, {null, "\\\\localhost\\repository"}, {null, "\\\\localhost\\repository\\"}, {null, "http://test.net/test1.htm?s=multiple&amp;a=amp&amp;b=in&amp;c=url"}, {null, "http://test.net/test2.htm?s=multiple&amp;amp;amp;amp;a=amp"}, {null, "http://validator.w3.org/check?uri=http://www.anomic.de/"}}) {
            URL jURL;
            MultiProtocolURL aURL;
            String environment = element[0];
            String url = element[1];
            try {
                aURL = MultiProtocolURL.newURL(environment, url);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                aURL = null;
            }
            if (environment == null) {
                try {
                    jURL = new URI(url).toURL();
                }
                catch (MalformedURLException | URISyntaxException e) {
                    jURL = null;
                }
            } else {
                try {
                    jURL = new URL(new URL(environment), url);
                }
                catch (MalformedURLException e) {
                    jURL = null;
                }
            }
            if (aURL == null && jURL != null || aURL != null && jURL == null || aURL != null && jURL != null && !jURL.toString().equals(aURL.toNormalform(false))) {
                System.out.println("Difference for environment=" + environment + ", url=" + url + ":");
                System.out.println((String)(jURL == null ? "jURL rejected input" : "jURL=" + jURL.toString()));
                System.out.println((String)(aURL == null ? "aURL rejected input" : "aURL=" + aURL.toNormalform(false) + "; host=" + aURL.getHost() + "; path=" + aURL.getPath() + "; file=" + aURL.getFile()));
            }
            if (aURL != null && jURL != null && jURL.toString().equals(aURL.toNormalform(false))) {
                System.out.println("jURL == aURL=" + aURL.toNormalform(false) + "; host=" + aURL.getHost() + "; path=" + aURL.getPath() + "; file=" + aURL.getFile());
            }
            if (aURL == null) continue;
            try {
                MultiProtocolURL aURL1 = new MultiProtocolURL(aURL.toNormalform(false));
                if (aURL1.toNormalform(false).equals(aURL.toNormalform(false))) continue;
                System.out.println("no stability for url:");
                System.out.println("aURL0=" + aURL.toNormalform(false));
                System.out.println("aURL1=" + aURL1.toNormalform(false));
            }
            catch (MalformedURLException e) {
                System.out.println("no stability for url:");
                System.out.println("aURL0=" + aURL.toNormalform(false));
                System.out.println("aURL1 cannot be computed:" + e.getMessage());
            }
        }
    }

    static {
        int i;
        backPathPattern = Pattern.compile("(/[^/]+(?<!/\\.{1,2})/)[.]{2}(?=/|$)|/\\.(?=/)|/(?=/)");
        patternMail = Pattern.compile("^[a-z]+:.*?");
        UNRESERVED_RFC1738 = new BitSet(128);
        UNRESERVED_PATH = new BitSet(128);
        PATTERN_METACHARACTERS = new BitSet(128);
        for (i = 65; i <= 90; ++i) {
            UNRESERVED_RFC1738.set(i);
        }
        for (i = 97; i <= 122; ++i) {
            UNRESERVED_RFC1738.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            UNRESERVED_RFC1738.set(i);
        }
        UNRESERVED_RFC1738.set(36);
        UNRESERVED_RFC1738.set(45);
        UNRESERVED_RFC1738.set(95);
        UNRESERVED_RFC1738.set(46);
        UNRESERVED_RFC1738.set(43);
        UNRESERVED_RFC1738.set(33);
        UNRESERVED_RFC1738.set(42);
        UNRESERVED_RFC1738.set(39);
        UNRESERVED_RFC1738.set(40);
        UNRESERVED_RFC1738.set(41);
        UNRESERVED_RFC1738.set(44);
        UNRESERVED_RFC1738.set(126);
        UNRESERVED_PATH.or(UNRESERVED_RFC1738);
        UNRESERVED_PATH.set(47);
        UNRESERVED_PATH.set(59);
        UNRESERVED_PATH.set(58);
        UNRESERVED_PATH.set(64);
        UNRESERVED_PATH.set(38);
        UNRESERVED_PATH.set(61);
        PATTERN_METACHARACTERS.set(60);
        PATTERN_METACHARACTERS.set(40);
        PATTERN_METACHARACTERS.set(91);
        PATTERN_METACHARACTERS.set(123);
        PATTERN_METACHARACTERS.set(92);
        PATTERN_METACHARACTERS.set(94);
        PATTERN_METACHARACTERS.set(45);
        PATTERN_METACHARACTERS.set(61);
        PATTERN_METACHARACTERS.set(36);
        PATTERN_METACHARACTERS.set(33);
        PATTERN_METACHARACTERS.set(124);
        PATTERN_METACHARACTERS.set(93);
        PATTERN_METACHARACTERS.set(125);
        PATTERN_METACHARACTERS.set(41);
        PATTERN_METACHARACTERS.set(63);
        PATTERN_METACHARACTERS.set(42);
        PATTERN_METACHARACTERS.set(43);
        PATTERN_METACHARACTERS.set(46);
        PATTERN_METACHARACTERS.set(62);
        PRESENT = new Object();
        sessionIDnames = new ConcurrentHashMap();
        hex = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0A", "%0B", "%0C", "%0D", "%0E", "%0F", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1A", "%1B", "%1C", "%1D", "%1E", "%1F", "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29", "%2A", "%2B", "%2C", "%2D", "%2E", "%2F", "%30", "%31", "%32", "%33", "%34", "%35", "%36", "%37", "%38", "%39", "%3A", "%3B", "%3C", "%3D", "%3E", "%3F", "%40", "%41", "%42", "%43", "%44", "%45", "%46", "%47", "%48", "%49", "%4A", "%4B", "%4C", "%4D", "%4E", "%4F", "%50", "%51", "%52", "%53", "%54", "%55", "%56", "%57", "%58", "%59", "%5A", "%5B", "%5C", "%5D", "%5E", "%5F", "%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67", "%68", "%69", "%6A", "%6B", "%6C", "%6D", "%6E", "%6F", "%70", "%71", "%72", "%73", "%74", "%75", "%76", "%77", "%78", "%79", "%7A", "%7B", "%7C", "%7D", "%7E", "%7F", "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87", "%88", "%89", "%8A", "%8B", "%8C", "%8D", "%8E", "%8F", "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97", "%98", "%99", "%9A", "%9B", "%9C", "%9D", "%9E", "%9F", "%A0", "%A1", "%A2", "%A3", "%A4", "%A5", "%A6", "%A7", "%A8", "%A9", "%AA", "%AB", "%AC", "%AD", "%AE", "%AF", "%B0", "%B1", "%B2", "%B3", "%B4", "%B5", "%B6", "%B7", "%B8", "%B9", "%BA", "%BB", "%BC", "%BD", "%BE", "%BF", "%C0", "%C1", "%C2", "%C3", "%C4", "%C5", "%C6", "%C7", "%C8", "%C9", "%CA", "%CB", "%CC", "%CD", "%CE", "%CF", "%D0", "%D1", "%D2", "%D3", "%D4", "%D5", "%D6", "%D7", "%D8", "%D9", "%DA", "%DB", "%DC", "%DD", "%DE", "%DF", "%E0", "%E1", "%E2", "%E3", "%E4", "%E5", "%E6", "%E7", "%E8", "%E9", "%EA", "%EB", "%EC", "%ED", "%EE", "%EF", "%F0", "%F1", "%F2", "%F3", "%F4", "%F5", "%F6", "%F7", "%F8", "%F9", "%FA", "%FB", "%FC", "%FD", "%FE", "%FF"};
        splitpattern = Pattern.compile(splitrex);
    }

    public static enum CharType {
        low,
        high,
        number;

    }
}

