/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.OptionalInt;
import org.apache.lucene.search.DisiPriorityQueue;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.MaxScoreSumPropagator;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerUtil;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

final class WANDScorer
extends Scorer {
    private final int scalingFactor;
    private long minCompetitiveScore = 0L;
    DisiWrapper lead;
    int doc;
    long leadMaxScore;
    final DisiPriorityQueue head;
    final DisiWrapper[] tail;
    long tailMaxScore;
    int tailSize;
    final long cost;
    final MaxScoreSumPropagator maxScorePropagator;
    int upTo;
    final int minShouldMatch;
    int freq;
    final ScoreMode scoreMode;

    static int scalingFactor(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Scores must be positive or null");
        }
        if (f == 0.0f) {
            return WANDScorer.scalingFactor(Float.MIN_VALUE) - 1;
        }
        if (Float.isInfinite(f)) {
            return WANDScorer.scalingFactor(Float.MAX_VALUE) + 1;
        }
        double d = f;
        assert (d == 0.0 || Math.getExponent(d) >= -1022);
        return 15 - Math.getExponent(Math.nextDown(d));
    }

    private static long scaleMaxScore(float maxScore, int scalingFactor) {
        assert (!Float.isNaN(maxScore));
        assert (maxScore >= 0.0f);
        double scaled = Math.scalb((double)maxScore, scalingFactor);
        if (scaled > 65536.0) {
            return 0xFFFFFFFFL;
        }
        return (long)Math.ceil(scaled);
    }

    private static long scaleMinScore(float minScore, int scalingFactor) {
        assert (!Float.isNaN(minScore));
        assert (minScore >= 0.0f);
        double scaled = Math.scalb((double)minScore, scalingFactor);
        return (long)Math.floor(scaled);
    }

    WANDScorer(Weight weight, Collection<Scorer> scorers, int minShouldMatch, ScoreMode scoreMode) throws IOException {
        super(weight);
        if (minShouldMatch >= scorers.size()) {
            throw new IllegalArgumentException("minShouldMatch should be < the number of scorers");
        }
        this.minCompetitiveScore = 0L;
        assert (minShouldMatch >= 0) : "minShouldMatch should not be negative, but got " + minShouldMatch;
        this.minShouldMatch = minShouldMatch;
        this.doc = -1;
        this.upTo = -1;
        this.scoreMode = scoreMode;
        this.head = new DisiPriorityQueue(scorers.size());
        this.tail = new DisiWrapper[scorers.size()];
        if (this.scoreMode == ScoreMode.TOP_SCORES) {
            OptionalInt scalingFactor = OptionalInt.empty();
            for (Scorer scorer : scorers) {
                scorer.advanceShallow(0);
                float maxScore = scorer.getMaxScore(Integer.MAX_VALUE);
                if (maxScore == 0.0f || !Float.isFinite(maxScore)) continue;
                scalingFactor = OptionalInt.of(Math.min(scalingFactor.orElse(Integer.MAX_VALUE), WANDScorer.scalingFactor(maxScore)));
            }
            this.scalingFactor = scalingFactor.orElse(0);
            this.maxScorePropagator = new MaxScoreSumPropagator(scorers);
        } else {
            this.scalingFactor = 0;
            this.maxScorePropagator = null;
        }
        for (Scorer scorer : scorers) {
            this.addLead(new DisiWrapper(scorer));
        }
        this.cost = ScorerUtil.costWithMinShouldMatch(scorers.stream().map(Scorer::iterator).mapToLong(DocIdSetIterator::cost), scorers.size(), minShouldMatch);
    }

    private boolean ensureConsistent() {
        if (this.scoreMode == ScoreMode.TOP_SCORES) {
            long maxScoreSum = 0L;
            for (int i = 0; i < this.tailSize; ++i) {
                assert (this.tail[i].doc < this.doc);
                maxScoreSum = Math.addExact(maxScoreSum, this.tail[i].maxScore);
            }
            assert (maxScoreSum == this.tailMaxScore) : maxScoreSum + " " + this.tailMaxScore;
            maxScoreSum = 0L;
            DisiWrapper w = this.lead;
            while (w != null) {
                assert (w.doc == this.doc);
                maxScoreSum = Math.addExact(maxScoreSum, w.maxScore);
                w = w.next;
            }
            assert (maxScoreSum == this.leadMaxScore) : maxScoreSum + " " + this.leadMaxScore;
            assert (this.minCompetitiveScore == 0L || this.tailMaxScore < this.minCompetitiveScore || this.tailSize < this.minShouldMatch);
            assert (this.doc <= this.upTo);
        }
        for (DisiWrapper w : this.head) {
            assert (w.doc > this.doc);
        }
        return true;
    }

    @Override
    public void setMinCompetitiveScore(float minScore) throws IOException {
        assert (this.scoreMode == ScoreMode.TOP_SCORES) : "minCompetitiveScore can only be set for ScoreMode.TOP_SCORES, but got: " + this.scoreMode;
        assert (minScore >= 0.0f);
        long scaledMinScore = WANDScorer.scaleMinScore(minScore, this.scalingFactor);
        assert (scaledMinScore >= this.minCompetitiveScore);
        this.minCompetitiveScore = scaledMinScore;
        this.maxScorePropagator.setMinCompetitiveScore(minScore);
    }

    @Override
    public final Collection<Scorable.ChildScorable> getChildren() throws IOException {
        ArrayList<Scorable.ChildScorable> matchingChildren = new ArrayList<Scorable.ChildScorable>();
        this.advanceAllTail();
        DisiWrapper s = this.lead;
        while (s != null) {
            matchingChildren.add(new Scorable.ChildScorable(s.scorer, "SHOULD"));
            s = s.next;
        }
        return matchingChildren;
    }

    @Override
    public DocIdSetIterator iterator() {
        return TwoPhaseIterator.asDocIdSetIterator(this.twoPhaseIterator());
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        DocIdSetIterator approximation = new DocIdSetIterator(){

            @Override
            public int docID() {
                return WANDScorer.this.doc;
            }

            @Override
            public int nextDoc() throws IOException {
                return this.advance(WANDScorer.this.doc + 1);
            }

            @Override
            public int advance(int target) throws IOException {
                assert (WANDScorer.this.ensureConsistent());
                WANDScorer.this.pushBackLeads(target);
                WANDScorer.this.advanceHead(target);
                WANDScorer.this.moveToNextCandidate(target);
                if (WANDScorer.this.doc == Integer.MAX_VALUE) {
                    return Integer.MAX_VALUE;
                }
                assert (WANDScorer.this.ensureConsistent());
                return WANDScorer.this.doNextCompetitiveCandidate();
            }

            @Override
            public long cost() {
                return WANDScorer.this.cost;
            }
        };
        return new TwoPhaseIterator(approximation){

            @Override
            public boolean matches() throws IOException {
                while (WANDScorer.this.leadMaxScore < WANDScorer.this.minCompetitiveScore || WANDScorer.this.freq < WANDScorer.this.minShouldMatch) {
                    if (WANDScorer.this.leadMaxScore + WANDScorer.this.tailMaxScore < WANDScorer.this.minCompetitiveScore || WANDScorer.this.freq + WANDScorer.this.tailSize < WANDScorer.this.minShouldMatch) {
                        return false;
                    }
                    WANDScorer.this.advanceTail();
                }
                return true;
            }

            @Override
            public float matchCost() {
                return WANDScorer.this.tail.length;
            }
        };
    }

    private void addLead(DisiWrapper lead) {
        lead.next = this.lead;
        this.lead = lead;
        this.leadMaxScore += lead.maxScore;
        ++this.freq;
    }

    private void pushBackLeads(int target) throws IOException {
        DisiWrapper s = this.lead;
        while (s != null) {
            DisiWrapper evicted = this.insertTailWithOverFlow(s);
            if (evicted != null) {
                evicted.doc = evicted.iterator.advance(target);
                this.head.add(evicted);
            }
            s = s.next;
        }
        this.lead = null;
        this.leadMaxScore = 0L;
    }

    private void advanceHead(int target) throws IOException {
        DisiWrapper headTop = this.head.top();
        while (headTop != null && headTop.doc < target) {
            DisiWrapper evicted = this.insertTailWithOverFlow(headTop);
            if (evicted != null) {
                evicted.doc = evicted.iterator.advance(target);
                headTop = this.head.updateTop(evicted);
                continue;
            }
            this.head.pop();
            headTop = this.head.top();
        }
    }

    private void advanceTail(DisiWrapper disi) throws IOException {
        disi.doc = disi.iterator.advance(this.doc);
        if (disi.doc == this.doc) {
            this.addLead(disi);
        } else {
            this.head.add(disi);
        }
    }

    private void advanceTail() throws IOException {
        DisiWrapper top = this.popTail();
        this.advanceTail(top);
    }

    private void updateMaxScores(int target) throws IOException {
        if (this.head.size() == 0) {
            this.upTo = this.tail[0].scorer.advanceShallow(target);
        } else {
            int newUpTo = Integer.MAX_VALUE;
            for (DisiWrapper w : this.head) {
                if (w.doc > newUpTo) continue;
                newUpTo = Math.min(w.scorer.advanceShallow(w.doc), newUpTo);
                w.maxScore = WANDScorer.scaleMaxScore(w.scorer.getMaxScore(newUpTo), this.scalingFactor);
            }
            this.upTo = newUpTo;
        }
        this.tailMaxScore = 0L;
        for (int i = 0; i < this.tailSize; ++i) {
            DisiWrapper w = this.tail[i];
            w.scorer.advanceShallow(target);
            w.maxScore = WANDScorer.scaleMaxScore(w.scorer.getMaxScore(this.upTo), this.scalingFactor);
            WANDScorer.upHeapMaxScore(this.tail, i);
            this.tailMaxScore += w.maxScore;
        }
        while (this.tailSize > 0 && this.tailMaxScore >= this.minCompetitiveScore) {
            DisiWrapper w = this.popTail();
            w.doc = w.iterator.advance(target);
            this.head.add(w);
        }
    }

    private void updateMaxScoresIfNecessary(int target) throws IOException {
        assert (this.lead == null);
        while (this.upTo < Integer.MAX_VALUE) {
            if (this.head.size() == 0) {
                target = Math.max(target, this.upTo + 1);
                this.updateMaxScores(target);
                continue;
            }
            if (this.head.top().doc <= this.upTo) break;
            assert (this.head.top().doc >= target);
            this.updateMaxScores(target);
            break;
        }
        assert (this.head.size() == 0 && this.upTo == Integer.MAX_VALUE || this.head.size() > 0 && this.head.top().doc <= this.upTo);
        assert (this.upTo >= target);
    }

    private void moveToNextCandidate(int target) throws IOException {
        if (this.scoreMode == ScoreMode.TOP_SCORES) {
            this.updateMaxScoresIfNecessary(target);
            assert (this.upTo >= target);
            if (this.head.size() == 0) {
                assert (this.upTo == Integer.MAX_VALUE);
                this.doc = Integer.MAX_VALUE;
                return;
            }
        }
        this.lead = this.head.pop();
        this.lead.next = null;
        this.leadMaxScore = this.lead.maxScore;
        this.freq = 1;
        this.doc = this.lead.doc;
        while (this.head.size() > 0 && this.head.top().doc == this.doc) {
            this.addLead(this.head.pop());
        }
    }

    private int doNextCompetitiveCandidate() throws IOException {
        while (this.leadMaxScore + this.tailMaxScore < this.minCompetitiveScore || this.freq + this.tailSize < this.minShouldMatch) {
            this.pushBackLeads(this.doc + 1);
            this.moveToNextCandidate(this.doc + 1);
            assert (this.ensureConsistent());
            if (this.doc != Integer.MAX_VALUE) continue;
            break;
        }
        return this.doc;
    }

    private void advanceAllTail() throws IOException {
        for (int i = this.tailSize - 1; i >= 0; --i) {
            this.advanceTail(this.tail[i]);
        }
        this.tailSize = 0;
        this.tailMaxScore = 0L;
        assert (this.ensureConsistent());
    }

    @Override
    public float score() throws IOException {
        this.advanceAllTail();
        double score = 0.0;
        DisiWrapper s = this.lead;
        while (s != null) {
            score += (double)s.scorer.score();
            s = s.next;
        }
        return (float)score;
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        this.maxScorePropagator.advanceShallow(target);
        if (target <= this.upTo) {
            return this.upTo;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return this.maxScorePropagator.getMaxScore(upTo);
    }

    @Override
    public int docID() {
        return this.doc;
    }

    private DisiWrapper insertTailWithOverFlow(DisiWrapper s) {
        if (this.tailMaxScore + s.maxScore < this.minCompetitiveScore || this.tailSize + 1 < this.minShouldMatch) {
            this.addTail(s);
            this.tailMaxScore += s.maxScore;
            return null;
        }
        if (this.tailSize == 0) {
            return s;
        }
        DisiWrapper top = this.tail[0];
        if (!WANDScorer.greaterMaxScore(top, s)) {
            return s;
        }
        this.tail[0] = s;
        WANDScorer.downHeapMaxScore(this.tail, this.tailSize);
        this.tailMaxScore = this.tailMaxScore - top.maxScore + s.maxScore;
        return top;
    }

    private void addTail(DisiWrapper s) {
        this.tail[this.tailSize] = s;
        WANDScorer.upHeapMaxScore(this.tail, this.tailSize);
        ++this.tailSize;
    }

    private DisiWrapper popTail() {
        assert (this.tailSize > 0);
        DisiWrapper result = this.tail[0];
        this.tail[0] = this.tail[--this.tailSize];
        WANDScorer.downHeapMaxScore(this.tail, this.tailSize);
        this.tailMaxScore -= result.maxScore;
        return result;
    }

    private static void upHeapMaxScore(DisiWrapper[] heap, int i) {
        DisiWrapper node = heap[i];
        int j = DisiPriorityQueue.parentNode(i);
        while (j >= 0 && WANDScorer.greaterMaxScore(node, heap[j])) {
            heap[i] = heap[j];
            i = j;
            j = DisiPriorityQueue.parentNode(j);
        }
        heap[i] = node;
    }

    private static void downHeapMaxScore(DisiWrapper[] heap, int size) {
        int i = 0;
        DisiWrapper node = heap[0];
        int j = DisiPriorityQueue.leftNode(i);
        if (j < size) {
            int k = DisiPriorityQueue.rightNode(j);
            if (k < size && WANDScorer.greaterMaxScore(heap[k], heap[j])) {
                j = k;
            }
            if (WANDScorer.greaterMaxScore(heap[j], node)) {
                do {
                    heap[i] = heap[j];
                    i = j;
                    k = DisiPriorityQueue.rightNode(j = DisiPriorityQueue.leftNode(i));
                    if (k >= size || !WANDScorer.greaterMaxScore(heap[k], heap[j])) continue;
                    j = k;
                } while (j < size && WANDScorer.greaterMaxScore(heap[j], node));
                heap[i] = node;
            }
        }
    }

    private static boolean greaterMaxScore(DisiWrapper w1, DisiWrapper w2) {
        if (w1.maxScore > w2.maxScore) {
            return true;
        }
        if (w1.maxScore < w2.maxScore) {
            return false;
        }
        return w1.cost < w2.cost;
    }
}

