/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.flac;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPicture;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.images.ArtworkFactory;
import org.jaudiotagger.tag.reference.PictureTypes;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentFieldKey;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;

public class FlacTag
implements Tag {
    private VorbisCommentTag tag = null;
    private List<MetadataBlockDataPicture> images = new ArrayList<MetadataBlockDataPicture>();

    public FlacTag() {
        this(VorbisCommentTag.createNewTag(), new ArrayList<MetadataBlockDataPicture>());
    }

    public FlacTag(VorbisCommentTag tag, List<MetadataBlockDataPicture> images) {
        this.tag = tag;
        this.images = images;
    }

    public List<MetadataBlockDataPicture> getImages() {
        return this.images;
    }

    public VorbisCommentTag getVorbisCommentTag() {
        return this.tag;
    }

    @Override
    public void addField(TagField field) throws FieldDataInvalidException {
        if (field instanceof MetadataBlockDataPicture) {
            this.images.add((MetadataBlockDataPicture)field);
        } else {
            this.tag.addField(field);
        }
    }

    @Override
    public List<TagField> getFields(String id) {
        if (id.equals(FieldKey.COVER_ART.name())) {
            ArrayList<TagField> castImages = new ArrayList<TagField>();
            for (MetadataBlockDataPicture image : this.images) {
                castImages.add(image);
            }
            return castImages;
        }
        return this.tag.getFields(id);
    }

    @Override
    public List<String> getAll(FieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == FieldKey.COVER_ART) {
            throw new UnsupportedOperationException(ErrorMessage.ARTWORK_CANNOT_BE_CREATED_WITH_THIS_METHOD.getMsg());
        }
        return this.tag.getAll(genericKey);
    }

    @Override
    public boolean hasCommonFields() {
        return this.tag.hasCommonFields();
    }

    @Override
    public boolean isEmpty() {
        return (this.tag == null || this.tag.isEmpty()) && this.images.size() == 0;
    }

    @Override
    public void setField(FieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagfield = this.createField(genericKey, value);
        this.setField(tagfield);
    }

    @Override
    public void addField(FieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagfield = this.createField(genericKey, value);
        this.addField(tagfield);
    }

    public void setField(String vorbisCommentKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagfield = this.createField(vorbisCommentKey, value);
        this.setField(tagfield);
    }

    public void addField(String vorbisCommentKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagfield = this.createField(vorbisCommentKey, value);
        this.addField(tagfield);
    }

    @Override
    public void setField(TagField field) throws FieldDataInvalidException {
        if (field instanceof MetadataBlockDataPicture) {
            if (this.images.size() == 0) {
                this.images.add(0, (MetadataBlockDataPicture)field);
            } else {
                this.images.set(0, (MetadataBlockDataPicture)field);
            }
        } else {
            this.tag.setField(field);
        }
    }

    @Override
    public TagField createField(FieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        if (genericKey.equals((Object)FieldKey.COVER_ART)) {
            throw new UnsupportedOperationException(ErrorMessage.ARTWORK_CANNOT_BE_CREATED_WITH_THIS_METHOD.getMsg());
        }
        return this.tag.createField(genericKey, value);
    }

    public TagField createField(VorbisCommentFieldKey vorbisCommentFieldKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        if (vorbisCommentFieldKey.equals((Object)VorbisCommentFieldKey.COVERART)) {
            throw new UnsupportedOperationException(ErrorMessage.ARTWORK_CANNOT_BE_CREATED_WITH_THIS_METHOD.getMsg());
        }
        return this.tag.createField(vorbisCommentFieldKey, value);
    }

    public TagField createField(String vorbisCommentFieldKey, String value) {
        if (vorbisCommentFieldKey.equals(VorbisCommentFieldKey.COVERART.getFieldName())) {
            throw new UnsupportedOperationException(ErrorMessage.ARTWORK_CANNOT_BE_CREATED_WITH_THIS_METHOD.getMsg());
        }
        return this.tag.createField(vorbisCommentFieldKey, value);
    }

    @Override
    public String getFirst(String id) {
        if (id.equals(FieldKey.COVER_ART.name())) {
            throw new UnsupportedOperationException(ErrorMessage.ARTWORK_CANNOT_BE_CREATED_WITH_THIS_METHOD.getMsg());
        }
        return this.tag.getFirst(id);
    }

    @Override
    public String getValue(FieldKey id, int index) throws KeyNotFoundException {
        if (id.equals((Object)FieldKey.COVER_ART)) {
            throw new UnsupportedOperationException(ErrorMessage.ARTWORK_CANNOT_BE_RETRIEVED_WITH_THIS_METHOD.getMsg());
        }
        return this.tag.getValue(id, index);
    }

    @Override
    public String getFirst(FieldKey id) throws KeyNotFoundException {
        return this.getValue(id, 0);
    }

    @Override
    public TagField getFirstField(String id) {
        if (id.equals(FieldKey.COVER_ART.name())) {
            if (this.images.size() > 0) {
                return this.images.get(0);
            }
            return null;
        }
        return this.tag.getFirstField(id);
    }

    @Override
    public TagField getFirstField(FieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        if (genericKey == FieldKey.COVER_ART) {
            return this.getFirstField(FieldKey.COVER_ART.name());
        }
        return this.tag.getFirstField(genericKey);
    }

    @Override
    public void deleteField(FieldKey fieldKey) throws KeyNotFoundException {
        if (fieldKey.equals((Object)FieldKey.COVER_ART)) {
            this.images.clear();
        } else {
            this.tag.deleteField(fieldKey);
        }
    }

    @Override
    public void deleteField(String id) throws KeyNotFoundException {
        if (id.equals(FieldKey.COVER_ART.name())) {
            this.images.clear();
        } else {
            this.tag.deleteField(id);
        }
    }

    @Override
    public Iterator<TagField> getFields() {
        return this.tag.getFields();
    }

    @Override
    public int getFieldCount() {
        return this.tag.getFieldCount() + this.images.size();
    }

    @Override
    public int getFieldCountIncludingSubValues() {
        return this.getFieldCount();
    }

    @Override
    public boolean setEncoding(Charset enc) throws FieldDataInvalidException {
        return this.tag.setEncoding(enc);
    }

    @Override
    public List<TagField> getFields(FieldKey id) throws KeyNotFoundException {
        if (id.equals((Object)FieldKey.COVER_ART)) {
            ArrayList<TagField> castImages = new ArrayList<TagField>();
            for (MetadataBlockDataPicture image : this.images) {
                castImages.add(image);
            }
            return castImages;
        }
        return this.tag.getFields(id);
    }

    public TagField createArtworkField(byte[] imageData, int pictureType, String mimeType, String description, int width, int height, int colourDepth, int indexedColouredCount) throws FieldDataInvalidException {
        if (imageData == null) {
            throw new FieldDataInvalidException("ImageData cannot be null");
        }
        return new MetadataBlockDataPicture(imageData, pictureType, mimeType, description, width, height, colourDepth, indexedColouredCount);
    }

    public TagField createLinkedArtworkField(String url) {
        return new MetadataBlockDataPicture(url.getBytes(StandardCharsets.ISO_8859_1), PictureTypes.DEFAULT_ID, "-->", "", 0, 0, 0, 0);
    }

    @Override
    public TagField createField(Artwork artwork) throws FieldDataInvalidException {
        if (artwork.isLinked()) {
            return new MetadataBlockDataPicture(artwork.getImageUrl().getBytes(StandardCharsets.ISO_8859_1), artwork.getPictureType(), "-->", "", 0, 0, 0, 0);
        }
        if (!artwork.setImageFromData()) {
            throw new FieldDataInvalidException("Unable to createField buffered image from the image");
        }
        return new MetadataBlockDataPicture(artwork.getBinaryData(), artwork.getPictureType(), artwork.getMimeType(), artwork.getDescription(), artwork.getWidth(), artwork.getHeight(), 0, 0);
    }

    @Override
    public void setField(Artwork artwork) throws FieldDataInvalidException {
        this.setField(this.createField(artwork));
    }

    @Override
    public void addField(Artwork artwork) throws FieldDataInvalidException {
        this.addField(this.createField(artwork));
    }

    @Override
    public List<Artwork> getArtworkList() {
        ArrayList<Artwork> artworkList = new ArrayList<Artwork>(this.images.size());
        for (MetadataBlockDataPicture coverArt : this.images) {
            Artwork artwork = ArtworkFactory.createArtworkFromMetadataBlockDataPicture(coverArt);
            artworkList.add(artwork);
        }
        return artworkList;
    }

    @Override
    public Artwork getFirstArtwork() {
        List<Artwork> artwork = this.getArtworkList();
        if (artwork.size() > 0) {
            return artwork.get(0);
        }
        return null;
    }

    @Override
    public void deleteArtworkField() throws KeyNotFoundException {
        this.deleteField(FieldKey.COVER_ART);
    }

    @Override
    public boolean hasField(FieldKey genericKey) {
        if (genericKey == FieldKey.COVER_ART) {
            return this.images.size() > 0;
        }
        return this.tag.hasField(genericKey);
    }

    public boolean hasField(VorbisCommentFieldKey vorbisFieldKey) {
        return this.tag.hasField(vorbisFieldKey);
    }

    @Override
    public boolean hasField(String id) {
        if (id.equals(FieldKey.COVER_ART.name())) {
            return this.images.size() > 0;
        }
        return this.tag.hasField(id);
    }

    @Override
    public TagField createCompilationField(boolean value) throws KeyNotFoundException, FieldDataInvalidException {
        return this.tag.createCompilationField(value);
    }
}

