/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp4;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.NullBoxIdException;
import org.jaudiotagger.audio.mp4.Mp4AtomIdentifier;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.audio.mp4.atom.Mp4MetaBox;
import org.jaudiotagger.audio.mp4.atom.Mp4StcoBox;
import org.jaudiotagger.audio.mp4.atom.NullPadding;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.utils.tree.DefaultMutableTreeNode;
import org.jaudiotagger.utils.tree.DefaultTreeModel;

public class Mp4AtomTree {
    private DefaultMutableTreeNode rootNode;
    private DefaultTreeModel dataTree;
    private DefaultMutableTreeNode moovNode;
    private DefaultMutableTreeNode mdatNode;
    private DefaultMutableTreeNode stcoNode;
    private DefaultMutableTreeNode ilstNode;
    private DefaultMutableTreeNode metaNode;
    private DefaultMutableTreeNode tagsNode;
    private DefaultMutableTreeNode udtaNode;
    private DefaultMutableTreeNode hdlrWithinMdiaNode;
    private DefaultMutableTreeNode hdlrWithinMetaNode;
    private List<DefaultMutableTreeNode> freeNodes = new ArrayList<DefaultMutableTreeNode>();
    private List<DefaultMutableTreeNode> mdatNodes = new ArrayList<DefaultMutableTreeNode>();
    private List<DefaultMutableTreeNode> trakNodes = new ArrayList<DefaultMutableTreeNode>();
    private Mp4StcoBox stco;
    private ByteBuffer moovBuffer;
    private Mp4BoxHeader moovHeader;
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.mp4");

    public Mp4AtomTree(RandomAccessFile raf) throws IOException, CannotReadException {
        this.buildTree(raf, true);
    }

    public Mp4AtomTree(RandomAccessFile raf, boolean closeOnExit) throws IOException, CannotReadException {
        this.buildTree(raf, closeOnExit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultTreeModel buildTree(RandomAccessFile raf, boolean closeExit) throws IOException, CannotReadException {
        FileChannel fc = null;
        try {
            fc = raf.getChannel();
            fc.position(0L);
            this.rootNode = new DefaultMutableTreeNode();
            this.dataTree = new DefaultTreeModel(this.rootNode);
            ByteBuffer headerBuffer = ByteBuffer.allocate(8);
            while (fc.position() < fc.size()) {
                Mp4BoxHeader boxHeader = new Mp4BoxHeader();
                headerBuffer.clear();
                fc.read(headerBuffer);
                headerBuffer.rewind();
                try {
                    boxHeader.update(headerBuffer);
                }
                catch (NullBoxIdException ne) {
                    if (this.moovNode != null & this.mdatNode != null) {
                        NullPadding np = new NullPadding(fc.position() - 8L, fc.size());
                        DefaultMutableTreeNode trailingPaddingNode = new DefaultMutableTreeNode(np);
                        this.rootNode.add(trailingPaddingNode);
                        logger.warning(ErrorMessage.NULL_PADDING_FOUND_AT_END_OF_MP4.getMsg(np.getFilePos()));
                        break;
                    }
                    throw ne;
                }
                boxHeader.setFilePos(fc.position() - 8L);
                DefaultMutableTreeNode newAtom = new DefaultMutableTreeNode(boxHeader);
                if (boxHeader.getId().equals(Mp4AtomIdentifier.MOOV.getFieldName())) {
                    if (this.moovNode != null & this.mdatNode != null) {
                        logger.warning(ErrorMessage.ADDITIONAL_MOOV_ATOM_AT_END_OF_MP4.getMsg(fc.position() - 8L));
                        break;
                    }
                    this.moovNode = newAtom;
                    this.moovHeader = boxHeader;
                    long filePosStart = fc.position();
                    this.moovBuffer = ByteBuffer.allocate(boxHeader.getDataLength());
                    int bytesRead = fc.read(this.moovBuffer);
                    if (bytesRead < boxHeader.getDataLength()) {
                        String msg = ErrorMessage.ATOM_LENGTH_LARGER_THAN_DATA.getMsg(boxHeader.getId(), boxHeader.getDataLength(), bytesRead);
                        throw new CannotReadException(msg);
                    }
                    this.moovBuffer.rewind();
                    this.buildChildrenOfNode(this.moovBuffer, newAtom);
                    fc.position(filePosStart);
                } else if (boxHeader.getId().equals(Mp4AtomIdentifier.FREE.getFieldName())) {
                    this.freeNodes.add(newAtom);
                } else if (boxHeader.getId().equals(Mp4AtomIdentifier.MDAT.getFieldName())) {
                    this.mdatNode = newAtom;
                    this.mdatNodes.add(newAtom);
                }
                this.rootNode.add(newAtom);
                fc.position(fc.position() + (long)boxHeader.getDataLength());
            }
            DefaultTreeModel defaultTreeModel = this.dataTree;
            return defaultTreeModel;
        }
        finally {
            if (this.mdatNode == null) {
                throw new CannotReadException(ErrorMessage.MP4_CANNOT_FIND_AUDIO.getMsg());
            }
            if (closeExit) {
                fc.close();
            }
        }
    }

    public void printAtomTree() {
        Enumeration e = this.rootNode.preorderEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode nextNode = (DefaultMutableTreeNode)e.nextElement();
            Mp4BoxHeader header = (Mp4BoxHeader)nextNode.getUserObject();
            if (header == null) continue;
            String tabbing = "";
            for (int i = 1; i < nextNode.getLevel(); ++i) {
                tabbing = tabbing + "\t";
            }
            if (header instanceof NullPadding) {
                System.out.println(tabbing + "Null pad  @ " + header.getFilePos() + " of size:" + header.getLength() + " ,ends @ " + (header.getFilePos() + (long)header.getLength()));
                continue;
            }
            System.out.println(tabbing + "Atom " + header.getId() + " @ " + header.getFilePos() + " of size:" + header.getLength() + " ,ends @ " + (header.getFilePos() + (long)header.getLength()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildChildrenOfNode(ByteBuffer moovBuffer, DefaultMutableTreeNode parentNode) throws IOException, CannotReadException {
        Mp4BoxHeader boxHeader;
        Mp4BoxHeader parentBoxHeader = (Mp4BoxHeader)parentNode.getUserObject();
        int justAfterHeaderPos = moovBuffer.position();
        if (parentBoxHeader.getId().equals(Mp4AtomIdentifier.META.getFieldName())) {
            Mp4MetaBox meta = new Mp4MetaBox(parentBoxHeader, moovBuffer);
            meta.processData();
            try {
                boxHeader = new Mp4BoxHeader(moovBuffer);
            }
            catch (NullBoxIdException nbe) {
                moovBuffer.position(moovBuffer.position() - 4);
            }
            finally {
                moovBuffer.position(moovBuffer.position() - 8);
            }
        }
        int startPos = moovBuffer.position();
        while (moovBuffer.position() < startPos + parentBoxHeader.getDataLength() - 8) {
            boxHeader = new Mp4BoxHeader(moovBuffer);
            if (boxHeader == null) continue;
            boxHeader.setFilePos(this.moovHeader.getFilePos() + (long)moovBuffer.position());
            logger.finest("Atom " + boxHeader.getId() + " @ " + boxHeader.getFilePos() + " of size:" + boxHeader.getLength() + " ,ends @ " + (boxHeader.getFilePos() + (long)boxHeader.getLength()));
            DefaultMutableTreeNode newAtom = new DefaultMutableTreeNode(boxHeader);
            parentNode.add(newAtom);
            if (boxHeader.getId().equals(Mp4AtomIdentifier.UDTA.getFieldName())) {
                this.udtaNode = newAtom;
            } else if (boxHeader.getId().equals(Mp4AtomIdentifier.META.getFieldName()) && parentBoxHeader.getId().equals(Mp4AtomIdentifier.UDTA.getFieldName())) {
                this.metaNode = newAtom;
            } else if (boxHeader.getId().equals(Mp4AtomIdentifier.HDLR.getFieldName()) && parentBoxHeader.getId().equals(Mp4AtomIdentifier.META.getFieldName())) {
                this.hdlrWithinMetaNode = newAtom;
            } else if (boxHeader.getId().equals(Mp4AtomIdentifier.HDLR.getFieldName())) {
                this.hdlrWithinMdiaNode = newAtom;
            } else if (boxHeader.getId().equals(Mp4AtomIdentifier.TAGS.getFieldName())) {
                this.tagsNode = newAtom;
            } else if (boxHeader.getId().equals(Mp4AtomIdentifier.STCO.getFieldName())) {
                if (this.stco == null) {
                    this.stco = new Mp4StcoBox(boxHeader, moovBuffer);
                    this.stcoNode = newAtom;
                }
            } else if (boxHeader.getId().equals(Mp4AtomIdentifier.ILST.getFieldName())) {
                Mp4BoxHeader parentsParent;
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)parentNode.getParent();
                if (parent != null && (parentsParent = (Mp4BoxHeader)parent.getUserObject()) != null && parentBoxHeader.getId().equals(Mp4AtomIdentifier.META.getFieldName()) && parentsParent.getId().equals(Mp4AtomIdentifier.UDTA.getFieldName())) {
                    this.ilstNode = newAtom;
                }
            } else if (boxHeader.getId().equals(Mp4AtomIdentifier.FREE.getFieldName())) {
                this.freeNodes.add(newAtom);
            } else if (boxHeader.getId().equals(Mp4AtomIdentifier.TRAK.getFieldName())) {
                this.trakNodes.add(newAtom);
            }
            if (boxHeader.getId().equals(Mp4AtomIdentifier.TRAK.getFieldName()) || boxHeader.getId().equals(Mp4AtomIdentifier.MDIA.getFieldName()) || boxHeader.getId().equals(Mp4AtomIdentifier.MINF.getFieldName()) || boxHeader.getId().equals(Mp4AtomIdentifier.STBL.getFieldName()) || boxHeader.getId().equals(Mp4AtomIdentifier.UDTA.getFieldName()) || boxHeader.getId().equals(Mp4AtomIdentifier.META.getFieldName()) || boxHeader.getId().equals(Mp4AtomIdentifier.ILST.getFieldName())) {
                this.buildChildrenOfNode(moovBuffer, newAtom);
            }
            moovBuffer.position(moovBuffer.position() + boxHeader.getDataLength());
        }
        moovBuffer.position(justAfterHeaderPos);
    }

    public DefaultTreeModel getDataTree() {
        return this.dataTree;
    }

    public DefaultMutableTreeNode getMoovNode() {
        return this.moovNode;
    }

    public DefaultMutableTreeNode getStcoNode() {
        return this.stcoNode;
    }

    public DefaultMutableTreeNode getIlstNode() {
        return this.ilstNode;
    }

    public Mp4BoxHeader getBoxHeader(DefaultMutableTreeNode node) {
        if (node == null) {
            return null;
        }
        return (Mp4BoxHeader)node.getUserObject();
    }

    public DefaultMutableTreeNode getMdatNode() {
        return this.mdatNode;
    }

    public DefaultMutableTreeNode getUdtaNode() {
        return this.udtaNode;
    }

    public DefaultMutableTreeNode getMetaNode() {
        return this.metaNode;
    }

    public DefaultMutableTreeNode getHdlrWithinMetaNode() {
        return this.hdlrWithinMetaNode;
    }

    public DefaultMutableTreeNode getHdlrWithinMdiaNode() {
        return this.hdlrWithinMdiaNode;
    }

    public DefaultMutableTreeNode getTagsNode() {
        return this.tagsNode;
    }

    public List<DefaultMutableTreeNode> getFreeNodes() {
        return this.freeNodes;
    }

    public List<DefaultMutableTreeNode> getTrakNodes() {
        return this.trakNodes;
    }

    public Mp4StcoBox getStco() {
        return this.stco;
    }

    public ByteBuffer getMoovBuffer() {
        return this.moovBuffer;
    }

    public Mp4BoxHeader getMoovHeader() {
        return this.moovHeader;
    }
}

