/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.io.File;
import java.io.IOException;
import net.yacy.visualization.PrintTool;
import net.yacy.visualization.RasterPlotter;

public class WireframeBarPrismPlotter
extends RasterPlotter {
    private final double[][] values;
    private final long[] colors;
    private final int originX;
    private final int originY;
    private final int barWidth;
    private final int depth;

    public WireframeBarPrismPlotter(int width, int height, double[][] values) {
        super(width, height, RasterPlotter.DrawMode.MODE_REPLACE, 20L);
        this.values = values;
        this.colors = new long[]{65535L, 0xFF66CCL, 0x66FF99L};
        this.originX = 120;
        this.originY = height - 80;
        this.barWidth = 40;
        this.depth = 28;
    }

    public void renderScene() {
        this.clear();
        this.drawAxes();
        for (int series = 0; series < this.values.length; ++series) {
            for (int index2 = 0; index2 < this.values[series].length; ++index2) {
                this.drawBar(series, index2, this.values[series][index2]);
            }
        }
        this.drawLegend();
    }

    private void drawAxes() {
        this.setColor(12876L);
        this.line(this.originX - 60, this.originY, this.getWidth() - 40, this.originY, 40);
        this.line(this.originX, this.originY + 20, this.originX + this.depth * 6, this.originY - this.depth * 6, 30);
        this.line(this.originX, this.originY + 20, this.originX, this.originY - 240, 35);
        this.setColor(23168L);
        for (int i = 0; i <= 5; ++i) {
            int y = this.originY - i * 40;
            this.line(this.originX, y, this.getWidth() - 60, y - this.depth * 2, 20);
            PrintTool.print5(this, this.originX - 70, y, 0, String.format("%3d", i * 20), -1, 60);
        }
    }

    private void drawBar(int series, int index2, double value) {
        long baseColor = this.colors[series % this.colors.length];
        int x = this.originX + index2 * (this.barWidth + 20) + series * (this.barWidth + 4);
        int height = (int)Math.round(value * 160.0);
        int frontLeftX = x;
        int frontRightX = x + this.barWidth;
        int frontBottomY = this.originY;
        int frontTopY = this.originY - height;
        int backLeftX = frontLeftX + this.depth;
        int backRightX = frontRightX + this.depth;
        int backTopY = frontTopY - this.depth / 2;
        int backBottomY = frontBottomY - this.depth / 2;
        this.setColor(WireframeBarPrismPlotter.lighten(baseColor, 1.5));
        this.fillPolygon(new int[]{frontLeftX, frontRightX, backRightX, backLeftX}, new int[]{frontTopY, frontTopY, backTopY, backTopY}, WireframeBarPrismPlotter.lighten(baseColor, 1.2), 60);
        this.setColor(baseColor);
        this.line(frontLeftX, frontTopY, frontRightX, frontTopY, 90);
        this.line(frontLeftX, frontBottomY, frontRightX, frontBottomY, 50);
        this.line(frontLeftX, frontTopY, frontLeftX, frontBottomY, 70);
        this.line(frontRightX, frontTopY, frontRightX, frontBottomY, 70);
        this.line(backLeftX, backTopY, backRightX, backTopY, 60);
        this.line(backLeftX, backTopY, backLeftX, backBottomY, 50);
        this.line(backRightX, backTopY, backRightX, backBottomY, 50);
        this.line(frontLeftX, frontTopY, backLeftX, backTopY, 65);
        this.line(frontRightX, frontTopY, backRightX, backTopY, 65);
        this.line(frontLeftX, frontBottomY, backLeftX, backBottomY, 40);
        this.line(frontRightX, frontBottomY, backRightX, backBottomY, 40);
        this.setColor(WireframeBarPrismPlotter.darken(baseColor, 0.6));
        for (int stripe = 0; stripe < height; stripe += 6) {
            int y = frontTopY + stripe;
            this.line(frontLeftX + 2, y, frontRightX - 2, y, 35);
        }
        this.setColor(WireframeBarPrismPlotter.lighten(baseColor, 1.3));
        String label = String.format("S%d-%d", series + 1, index2 + 1);
        PrintTool.print5(this, frontLeftX + this.barWidth / 2, this.originY + 14 + series * 12, 0, label, 0, 60);
    }

    private void drawLegend() {
        int x = this.getWidth() - 140;
        int y = 60;
        for (int i = 0; i < this.colors.length; ++i) {
            this.setColor(this.colors[i]);
            this.dot(x, 60 + i * 18, 6, true, 90);
            PrintTool.print5(this, x + 10, 60 + i * 18 + 4, 0, "SERIES " + (i + 1), -1, 70);
        }
        this.setColor(61183L);
        PrintTool.print5(this, x, 44, 0, "DATASET", -1, 80);
    }

    public static void main(String[] args) {
        File outDir;
        System.setProperty("java.awt.headless", "true");
        File file = outDir = args.length > 0 ? new File(args[0]) : new File(".");
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        double[][] values = new double[][]{{0.4, 0.7, 0.5, 0.8}, {0.5, 0.6, 0.65, 0.45}, {0.3, 0.55, 0.75, 0.6}};
        WireframeBarPrismPlotter plotter = new WireframeBarPrismPlotter(680, 420, values);
        plotter.renderScene();
        File out = new File(outDir, "wireframe_bar_prism.png");
        try {
            plotter.save(out, "png");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save prism chart", e);
        }
    }
}

