/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import net.yacy.visualization.PrintTool;
import net.yacy.visualization.RasterPlotter;

public class StarTunnelPlotter
extends RasterPlotter {
    private final Star[] stars;
    private final Random random = new Random(212716254L);
    private final double speed;
    private final double focalLength;
    private final int centerX;
    private final int centerY;

    public StarTunnelPlotter(int width, int height, int starCount) {
        super(width, height, RasterPlotter.DrawMode.MODE_REPLACE, 16L);
        this.stars = new Star[starCount];
        this.speed = 12.0;
        this.focalLength = (double)Math.min(width, height) * 1.2;
        this.centerX = width / 2;
        this.centerY = height / 2;
        for (int i = 0; i < starCount; ++i) {
            this.stars[i] = this.randomStar();
        }
    }

    private Star randomStar() {
        Star s = new Star();
        s.z = this.random.nextDouble() * 400.0 + 40.0;
        double angle = this.random.nextDouble() * 2.0 * Math.PI;
        double radius = Math.sqrt(this.random.nextDouble()) * 220.0;
        s.x = Math.cos(angle) * radius;
        s.y = Math.sin(angle) * radius;
        return s;
    }

    public void renderFrame() {
        this.clear();
        this.drawGrid();
        this.setColor(0x66FFFFL);
        for (Star star : this.stars) {
            star.z -= this.speed;
            if (star.z < 20.0) {
                Star replacement = this.randomStar();
                star.x = replacement.x;
                star.y = replacement.y;
                star.z = replacement.z + 400.0;
            }
            double scale = this.focalLength / star.z;
            int x = this.centerX + (int)Math.round(star.x * scale);
            int y = this.centerY + (int)Math.round(star.y * scale);
            if (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight()) continue;
            int intensity = Math.min(100, (int)(120.0 - star.z / 4.0));
            int radius = Math.max(1, (int)(6.0 - star.z / 80.0));
            this.dot(x, y, radius, true, intensity);
        }
        this.drawOverlay();
    }

    private void drawGrid() {
        this.setColor(8772L);
        for (int i = 0; i < 40; ++i) {
            int offset = i * 12;
            int intensity = 20 + i % 8 * 4;
            int y = this.getHeight() - offset;
            if (y < 0) break;
            this.line(0, y, this.getWidth(), y, intensity);
        }
        this.setColor(13158L);
        for (int a = -80; a <= 80; a += 10) {
            double rad = Math.toRadians(a);
            int x1 = this.centerX;
            int y1 = this.centerY;
            int x2 = this.centerX + (int)(Math.cos(rad) * (double)this.getWidth());
            int y2 = this.centerY + (int)(Math.sin(rad) * (double)this.getHeight());
            this.line(x1, y1, x2, y2, 28);
        }
        this.setColor(17527L);
        this.dot(this.centerX, this.centerY, 12, true, 30);
    }

    private void drawOverlay() {
        this.setColor(65484L);
        PrintTool.print5(this, 4, 12, 0, "STAR TUNNEL", -1, 90);
        this.setColor(0x66FFFFL);
        PrintTool.print5(this, 4, 22, 0, "HYPERSPACE VECTOR", -1, 70);
        this.setColor(43724L);
        PrintTool.print5(this, this.getWidth() - 4, this.getHeight() - 6, 0, "SPEED:" + (int)this.speed * this.stars.length, 1, 70);
    }

    public static void main(String[] args) {
        File target;
        System.setProperty("java.awt.headless", "true");
        File file = target = args.length > 0 ? new File(args[0]) : new File(".");
        if (!target.exists()) {
            target.mkdirs();
        }
        StarTunnelPlotter tunnel = new StarTunnelPlotter(480, 360, 160);
        for (int frame = 0; frame < 8; ++frame) {
            tunnel.renderFrame();
            File out = new File(target, String.format("star_tunnel_%02d.png", frame));
            try {
                tunnel.save(out, "png");
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to store tunnel frame", e);
            }
        }
    }

    private static final class Star {
        double x;
        double y;
        double z;

        private Star() {
        }
    }
}

