/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.io.File;
import java.io.IOException;
import net.yacy.visualization.PrintTool;
import net.yacy.visualization.RasterPlotter;

public class RetroVfdDashboardPlotter
extends RasterPlotter {
    private final int centerX;
    private final int centerY;

    public RetroVfdDashboardPlotter(int width, int height) {
        super(width, height, RasterPlotter.DrawMode.MODE_REPLACE, 8L);
        this.centerX = width / 2;
        this.centerY = height / 2 + 20;
    }

    public void renderFrame(double sweepFraction) {
        this.clear();
        this.drawBackground();
        this.drawGauge("THROUGHPUT", this.centerX - 140, this.centerY, 110, sweepFraction, 61648L, 0.78);
        this.drawGauge("LATENCY", this.centerX + 140, this.centerY, 110, 1.0 - sweepFraction * 0.6, 49407L, 0.45);
        this.drawCounters(sweepFraction);
        this.drawStatusLights(sweepFraction);
    }

    private void drawBackground() {
        this.setColor(6176L);
        for (int y = 0; y < this.getHeight(); y += 6) {
            this.line(0, y, this.getWidth(), y, 20);
        }
        this.setColor(12352L);
        this.line(0, this.centerY + 120, this.getWidth(), this.centerY + 120, 35);
        this.line(0, this.centerY - 140, this.getWidth(), this.centerY - 140, 25);
    }

    private void drawGauge(String label, int cx, int cy, int radius, double fraction, long color, double labelOffset) {
        int inner = radius - 28;
        int outer = radius;
        this.setColor(RetroVfdDashboardPlotter.darken(color, 0.3));
        this.arc(cx, cy, inner - 6, outer + 6, 18);
        this.setColor(RetroVfdDashboardPlotter.darken(color, 0.5));
        this.arc(cx, cy, inner - 2, inner, 30);
        this.setColor(color);
        int start = 210;
        int sweep = (int)Math.round(300.0 * fraction);
        this.arc(cx, cy, inner, outer, 210, 210 + sweep);
        for (int tick = 0; tick <= 10; ++tick) {
            int angle = 210 + tick * 30;
            int intensity = tick % 5 == 0 ? 70 : 40;
            this.setColor(RetroVfdDashboardPlotter.darken(color, tick % 5 == 0 ? 0.4 : 0.6));
            this.arcLine(cx, cy, inner - 6, inner + 6, angle, true, null, null, -1, -1, -1, false);
            if (tick % 5 != 0) continue;
            int tx = cx + (int)(Math.cos(Math.toRadians(angle)) * (double)(inner - 20));
            int ty = cy - (int)(Math.sin(Math.toRadians(angle)) * (double)(inner - 20));
            this.setColor(color);
            PrintTool.print5(this, tx, ty, 0, Integer.toString(tick), -1, intensity);
        }
        this.setColor(color);
        int needleAngle = 210 + sweep;
        this.arcLine(cx, cy, 0, inner, needleAngle, true, null, null, -1, -1, -1, false);
        this.dot(cx, cy, 6, true, 80);
        PrintTool.print5(this, cx, (int)((double)cy + labelOffset * (double)radius), 0, label, 0, 75);
    }

    private void drawCounters(double fraction) {
        long color = 65496L;
        this.setColor(65496L);
        int baseY = this.centerY + 150;
        PrintTool.print5(this, this.centerX - 150, baseY, 0, "REQ/S", -1, 70);
        PrintTool.print5(this, this.centerX + 150, baseY, 0, "ERROR%", -1, 70);
        this.setColor(12336L);
        this.fillRectangle(this.centerX - 200, baseY - 4, this.centerX - 40, baseY + 20);
        this.fillRectangle(this.centerX + 40, baseY - 4, this.centerX + 200, baseY + 20);
        String left = this.sevenSegmentNumber(4300 + (int)(fraction * 1200.0));
        String right = this.sevenSegmentNumber((int)(fraction * 240.0));
        this.setColor(65496L);
        PrintTool.print5(this, this.centerX - 40, baseY + 8, 0, left, -1, 100);
        PrintTool.print5(this, this.centerX + 200, baseY + 8, 0, right, -1, 100);
    }

    private void fillRectangle(int x1, int y1, int x2, int y2) {
        for (int y = y1; y <= y2; ++y) {
            this.line(x1, y, x2, y, 18);
        }
    }

    private void drawStatusLights(double fraction) {
        int top = this.centerY - 200;
        String[] labels = new String[]{"NET", "CPU", "IO", "CACHE"};
        long[] colors = new long[]{65484L, 0xFF8844L, 0x66FF99L, 0xFFEE44L};
        for (int i = 0; i < labels.length; ++i) {
            int x = 80 + i * 90;
            int intensity = (int)((Math.sin(fraction * Math.PI * 2.0 + (double)i) + 1.0) * 30.0) + 40;
            this.setColor(RetroVfdDashboardPlotter.darken(colors[i], 0.4));
            this.dot(x, top, 12, true, intensity);
            this.dot(x, top, 6, true, intensity + 10);
            this.setColor(colors[i]);
            PrintTool.print5(this, x, top - 20, 0, labels[i], 0, 60);
        }
    }

    private String sevenSegmentNumber(int value) {
        String s = String.format("%04d", Math.abs(value));
        return s;
    }

    public static void main(String[] args) {
        File dir;
        System.setProperty("java.awt.headless", "true");
        File file = dir = args.length > 0 ? new File(args[0]) : new File(".");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        RetroVfdDashboardPlotter plotter = new RetroVfdDashboardPlotter(640, 420);
        for (int frame = 0; frame < 8; ++frame) {
            double fraction = (double)frame / 7.0;
            plotter.renderFrame(fraction);
            File out = new File(dir, String.format("vfd_dashboard_%02d.png", frame));
            try {
                plotter.save(out, "png");
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to store frame", e);
            }
        }
    }
}

