/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.io.File;
import java.io.IOException;
import net.yacy.visualization.RasterPlotter;

public class PrintTool {
    private static long[] font5 = new long[]{0L, 0x300C03000030L, 0xCC3300000000L, 0xCCFFCCCFFCCCL, 844202395095038L, 215294090137356L, 840989741474540L, 0x300C00000000L, 3313579866115L, 845181046423552L, 219775250432L, 0xC0FC0C000L, 50512064L, 0xFC00000L, 48L, 0x30383838380L, 278055968779516L, 53034306552060L, 278051014018047L, 278050829643004L, 207512417611788L, 1125626098495484L, 278040075447548L, 1124849846108208L, 278051616075004L, 278051618303228L, 0xC0000C000L, 0xC0002C0C0L, 0xE0E0E00E00EL, 0xFFC00FFC00L, 0x2C02C02C2C2C0L, 277124225171504L, 843312465314044L, 203116397985539L, 1117976764624892L, 278039809097980L, 1122339114463228L, 1125626086687743L, 1125626086687488L, 278039875038460L, 848552393445123L, 1124851985204223L, 1124803620515068L, 857392494195467L, 845250369946623L, 848771365506819L, 989530328710923L, 278051623415036L, 1122339375547136L, 278051682171131L, 1122339375592203L, 280238290382588L, 1124851985203248L, 848552129342716L, 848552271261744L, 848552162946252L, 0x38BBB8B8BBB8BL, 848494604632112L, 1124849981031423L, 69320822538303L, 985952885454859L, 1108359310787568L, 0xB8BBB8B00000L, 1023L, 246479583182848L, 805178623L, 845250634199036L, 0xFFE00FFL, 3302024416511L, 816896205055L, 66031091499056L, 204249165820L, 845250569416579L, 0x30000300C030L, 52776608645344L, 845250419483439L, 0x300C0300C030L, 248442675L, 265170691L, 265170172L, 1096034546432L, 274747096067L, 47303409712L, 197898156L, 53047191453744L, 809381116L, 0x38BBB8B8L, 0x333EECECL, 247652588L, 247652400L, 267576316L, 16542259525647L, 0x300C0300C030L, 1056321630340032L, 791275419648L, 1125629059403775L};
    private static long[] font6 = new long[]{0L, 0x8208200200L, 1256277934080L, 1304903283840L, 0x8FA8F8AF88L, 3421010737344L, 571370514240L, 0x4200000000L, 283604189440L, 554118955520L, 10812670592L, 4370219264L, 33296L, 0x7C0000L, 49920L, 2216757248L, 2099796973440L, 846176733120L, 2097042558912L, 2097118844800L, 288108048640L, 4364727359360L, 2096993015680L, 4330435412480L, 2097529886592L, 2097579562880L, 0x8000200L, 8589967888L, 4433412352L, 0x1F01F000L, 8657584640L, 2097052385536L, 2102046623616L, 2097588082752L, 4297090015104L, 2097563178880L, 4160238268160L, 4364735483840L, 4364735481856L, 2097565013888L, 2304241965120L, 2134666921920L, 69818783616L, 2376066017344L, 2233928388544L, 2323267328064L, 2321053792320L, 2097580218240L, 4296611072000L, 2097582331776L, 4296611080256L, 2096447756160L, 2134666920192L, 2303738648448L, 2303738585856L, 2303738696832L, 2287274633280L, 1186653552896L, 4331543793600L, 485399478720L, 34630287488L, 3857016983040L, 571801075712L, 63L, 0x8100000000L, 30106331008L, 1117199341440L, 15305081728L, 140098807680L, 30651058048L, 421110252032L, 32791715996L, 2234398681216L, 550160598784L, 137473041548L, 1121395491968L, 558482096512L, 56550402688L, 65003989120L, 30644250368L, 65004095520L, 32791715971L, 15305081856L, 30608994048L, 579956932864L, 37086701312L, 37082972672L, 37223048448L, 36844947584L, 37086683292L, 66641268608L, 486271893952L, 0x4104104100L, 3857000205824L, 11072962560L, 4365322950783L};
    private static long[] font6_bold = new long[]{0L, 0xC30C30C00CL, 0x33CC0000000L, 1815687722650L, 858464460684L, 3422119103715L, 1982603689375L, 0xC30C000000L, 425610806022L, 1662254605080L, 0xCCCFCCCC0L, 13102793472L, 49944L, 0xFC0000L, 49920L, 3325135872L, 2117283560670L, 837991580479L, 2116397141055L, 2116399152350L, 427866976646L, 4381907631326L, 2117166906590L, 4384191726348L, 2117208849630L, 2117208915166L, 0xC30030CL, 204473112L, 213016215939L, 0x3F03F000L, 3324406162992L, 2116397088780L, 2117282499678L, 857718340851L, 4316240493822L, 2117163224286L, 4182019882428L, 4381687876671L, 4381687876656L, 2117165071582L, 0x33CF3FF3CF3L, 2074673726238L, 1037336866204L, 3563694837171L, 3350892579903L, 3431676189809L, 3569117789427L, 2117214354654L, 4316240481328L, 2117214353287L, 4316240530867L, 2117158321374L, 4342416458508L, 3560323366110L, 3560323364748L, 3420702858993L, 3559960734963L, 3559960658700L, 4332652170303L, 2087763150366L, 51945431232L, 2068129014174L, 857701613568L, 63L, 1662152343552L, 504233183L, 52361379070L, 516099102L, 3279895775L, 516946974L, 7725695756L, 533590270L, 52361379059L, 825106678558L, 412419121596L, 52359318963L, 30269293342L, 922746225L, 1053768947L, 516898014L, 1053813808L, 533590211L, 1053756464L, 532799742L, 13945062151L, 869219551L, 869218188L, 836237275L, 863553459L, 869134780L, 1058588223L, 494137295623L, 0xC30C30C30CL, 3861378810680L, 280240128L, 4365322950783L};
    private static long[] font7 = new long[]{0L, 4539061041628160L, 11346959998648320L, 11351329320798720L, 4783167122670592L, 55037293660529024L, 27339911100177536L, 0x10200000000000L, 2287538270241280L, 4521261074023424L, 4689313804141568L, 35475909902336L, 198148L, 0x3E0000000L, 198144L, 0x2082082082000L, 35199956817567488L, 4610529297571584L, 34067340249808640L, 35188808256347904L, 1152636747284736L, 35607700710645504L, 34069500723764736L, 34911763015271424L, 15913308096335360L, 15913308566097408L, 277025522688L, 277025522704L, 1743292966568320L, 1030855065600L, 54148955084566528L, 15912202087171072L, 35191229422509952L, 35191037747028096L, 71219834497564416L, 17035850475392768L, 70098316262686208L, 71778352042622848L, 71778352042614784L, 35186592455876352L, 36879887607292032L, 15798060110188032L, 7899030056147968L, 38028151700431232L, 36312488334081920L, 37030093887922304L, 37021160364368000L, 35191021104029440L, 71219834495442944L, 35191021104094977L, 71219834503864448L, 35190985804766976L, 71530105498895360L, 36879870964293376L, 36879870898537472L, 36879870981394688L, 36741969938522240L, 36741969912923136L, 71503579798060928L, 16959421431418624L, 0x80808080808080L, 16897363956240128L, 0x10511000000000L, 16256L, 0x10100000000000L, 2062252285568L, 283707960229632L, 2181978660736L, 4449455071104L, 2148019478272L, 6826333007251456L, 2147889430718L, 283707960221824L, 35190831451648L, 17595415724568L, 283797716410752L, 105830158568960L, 1875175957632L, 2147889471616L, 2147889471232L, 4346913726528L, 2182249169025L, 3255988920320L, 2147613695744L, 35475909903104L, 2250968686336L, 2250902930432L, 2250985787648L, 2247896178816L, 2250968645822L, 4365314965376L, 6826343744669184L, 4539061041759240L, 13528529320872960L, 561839603712L, 71782768076423040L};
    private static final int arcDist = 8;

    private static void print5(RasterPlotter matrix, int x, int y, int angle, char letter, int intensity) {
        int index2 = letter - 32;
        if (index2 < 0 || index2 >= font5.length || intensity <= 0) {
            return;
        }
        long character = font5[index2];
        int i3 = intensity / 3;
        for (int row = 0; row < 5; ++row) {
            long c;
            int col;
            long bits = character & 0x3FFL;
            character >>= 10;
            if (angle == 0) {
                for (col = 0; col < 5; ++col) {
                    c = bits & 3L;
                    if (c == 3L) {
                        matrix.plot(x + 5 - col, y, intensity);
                    } else if (c == 2L) {
                        matrix.plot(x + 5 - col, y, i3);
                    }
                    bits >>= 2;
                }
                --y;
            }
            if (angle == 90) {
                for (col = 0; col < 5; ++col) {
                    c = bits & 3L;
                    if (c == 3L) {
                        matrix.plot(x, y - 5 + col, intensity);
                    } else if (c == 2L) {
                        matrix.plot(x, y - 5 + col, i3);
                    }
                    bits >>= 2;
                }
                --x;
            }
            if (angle != 315) continue;
            int i2 = intensity / 2;
            int i5 = intensity / 5;
            for (int col2 = 0; col2 < 5; ++col2) {
                c = bits & 3L;
                if (c == 3L) {
                    matrix.plot(x + 5 - col2, y + 5 - col2, intensity);
                    matrix.plot(x + 6 - col2, y + 5 - col2, i2);
                    matrix.plot(x + 5 - col2, y + 6 - col2, i2);
                } else if (c == 2L) {
                    matrix.plot(x + 5 - col2, y + 5 - col2, i3);
                    matrix.plot(x + 6 - col2, y + 5 - col2, i5);
                    matrix.plot(x + 5 - col2, y + 6 - col2, i5);
                }
                bits >>= 2;
            }
            ++x;
            --y;
        }
    }

    private static void print6(RasterPlotter matrix, int x, int y, int angle, char letter, int intensity, boolean bold, boolean invers) {
        int row;
        long p;
        int index2 = letter - 32;
        if (index2 < 0 || index2 >= font6.length || intensity <= 0) {
            return;
        }
        long character = bold ? font6_bold[index2] : font6[index2];
        long l = p = invers ? 0L : 1L;
        if (invers) {
            int col;
            if (angle == 0) {
                for (col = 0; col < 7; ++col) {
                    matrix.plot(x + col, y + 1, intensity);
                }
                for (row = 0; row < 8; ++row) {
                    matrix.plot(x - 1, y + 1 - row, intensity);
                }
            } else if (angle == 90) {
                for (col = 0; col < 7; ++col) {
                    matrix.plot(x + 1, y + col, intensity);
                }
                for (row = 0; row < 8; ++row) {
                    matrix.plot(x, y - 1, 50);
                }
            } else if (angle == 315) {
                for (col = 0; col < 7; ++col) {
                    matrix.plot(x + col - 1, y + col, intensity);
                }
                for (row = 0; row < 8; ++row) {
                    matrix.plot(x + row - 1, y - row - 1, 50);
                }
            }
        }
        for (row = 0; row < 7; ++row) {
            int col;
            long bits = character & 0x3FL;
            character >>= 6;
            if (angle == 0) {
                for (col = 0; col < 6; ++col) {
                    if ((bits & 1L) == p) {
                        matrix.plot(x + 5 - col, y, intensity);
                    }
                    bits >>= 1;
                }
                if (invers) {
                    matrix.plot(x + 6, y, intensity);
                }
                --y;
                continue;
            }
            if (angle == 90) {
                for (col = 0; col < 6; ++col) {
                    if ((bits & 1L) == p) {
                        matrix.plot(x, y - 5 + col, intensity);
                    }
                    bits >>= 1;
                }
                if (invers) {
                    matrix.plot(x, y - 6, intensity);
                }
                --x;
                continue;
            }
            if (angle != 315) continue;
            int i2 = intensity / 2;
            for (int col2 = 0; col2 < 6; ++col2) {
                if ((bits & 1L) == p) {
                    int px = x + 5 - col2;
                    int py = y + 5 - col2;
                    matrix.plot(px, py, intensity);
                    if (i2 > 0) {
                        matrix.plot(px + 1, py, i2);
                        matrix.plot(px, py + 1, i2);
                    }
                }
                bits >>= 1;
            }
            if (invers) {
                matrix.plot(x + 6, y + 6, intensity);
            }
            ++x;
            --y;
        }
    }

    public static void print5(RasterPlotter matrix, int x, int y, int angle, String message2, int align, int intensity) {
        int size = 6;
        int halfStep = 3;
        int xx = 0;
        int yy = 0;
        if (angle == 0) {
            xx = align == -1 ? x : (align == 1 ? x - 6 * message2.length() : x - 3 * message2.length());
            yy = y;
        } else if (angle == 90) {
            xx = x;
            yy = align == -1 ? y : (align == 1 ? y + 6 * message2.length() : y + 3 * message2.length());
        } else if (angle == 315) {
            int n = align == -1 ? x : (xx = align == 1 ? x - 6 * message2.length() : x - 3 * message2.length());
            yy = align == -1 ? y : (align == 1 ? y - 6 * message2.length() : y - 3 * message2.length());
        }
        for (int i = 0; i < message2.length(); ++i) {
            PrintTool.print5(matrix, xx, yy, angle, message2.charAt(i), intensity);
            if (angle == 0) {
                xx += 6;
                continue;
            }
            if (angle == 90) {
                yy -= 6;
                continue;
            }
            if (angle != 315) continue;
            xx += 6;
            yy += 6;
        }
    }

    public static void print6(RasterPlotter matrix, int x, int y, int angle, String message2, int align, int intensity, boolean bold, boolean invers) {
        if (message2 == null || message2.isEmpty() || intensity <= 0) {
            return;
        }
        int size = 7;
        int xx = x;
        int yy = y;
        if (angle == 0) {
            xx = align == -1 ? x : (align == 1 ? x - 7 * message2.length() : x - 7 * message2.length() / 2);
            yy = y;
        } else if (angle == 90) {
            xx = x;
            yy = align == -1 ? y : (align == 1 ? y + 7 * message2.length() : y + 7 * message2.length() / 2);
        } else if (angle == 315) {
            int n = align == -1 ? x : (xx = align == 1 ? x - 7 * message2.length() : x - 7 * message2.length() / 2);
            yy = align == -1 ? y : (align == 1 ? y - 7 * message2.length() : y - 7 * message2.length() / 2);
        }
        for (int i = 0; i < message2.length(); ++i) {
            PrintTool.print6(matrix, xx, yy, angle, message2.charAt(i), intensity, bold, invers);
            if (angle == 0) {
                xx += 7;
                continue;
            }
            if (angle == 90) {
                yy -= 7;
                continue;
            }
            if (angle != 315) continue;
            xx += 7;
            yy += 7;
        }
    }

    public static void arcPrint5(RasterPlotter matrix, int cx, int cy, int radius, double angle, String message2, int intensity) {
        int x = cx + (int)((double)(radius + 1) * Math.cos(Math.PI / 180 * angle));
        int y = cy - (int)((double)(radius + 1) * Math.sin(Math.PI / 180 * angle));
        int yp = y + 3;
        if (angle > 8.0 && angle < 172.0) {
            yp = y;
        }
        if (angle > 188.0 && angle < 352.0) {
            yp = y + 6;
        }
        if (angle > 82.0 && angle < 98.0) {
            yp -= 6;
        }
        if (angle > 262.0 && angle < 278.0) {
            yp += 6;
        }
        int xp = x - 3 * message2.length();
        if (angle > 98.0 && angle < 262.0) {
            xp = x - 6 * message2.length();
        }
        if (angle < 82.0 || angle > 278.0) {
            xp = x;
        }
        PrintTool.print5(matrix, xp, yp, 0, message2, -1, intensity);
    }

    public static void arcPrint6(RasterPlotter matrix, int cx, int cy, int radius, double angle, String message2, int intensity, boolean bold, boolean invers) {
        int x = cx + (int)((double)(radius + 1) * Math.cos(Math.PI / 180 * angle));
        int y = cy - (int)((double)(radius + 1) * Math.sin(Math.PI / 180 * angle));
        int yp = y + 4;
        if (angle > 8.0 && angle < 172.0) {
            yp = y;
        }
        if (angle > 188.0 && angle < 352.0) {
            yp = y + 8;
        }
        if (angle > 82.0 && angle < 98.0) {
            yp -= 8;
        }
        if (angle > 262.0 && angle < 278.0) {
            yp += 8;
        }
        int xp = x - 4 * message2.length();
        if (angle > 98.0 && angle < 262.0) {
            xp = x - 8 * message2.length();
        }
        if (angle < 82.0 || angle > 278.0) {
            xp = x;
        }
        PrintTool.print6(matrix, xp, yp, 0, message2, -1, intensity, bold, invers);
    }

    public static void main(String[] args) {
        System.setProperty("java.awt.headless", "true");
        File target = PrintTool.determineTarget(args);
        RasterPlotter canvas = new RasterPlotter(360, 260, RasterPlotter.DrawMode.MODE_REPLACE, 16L);
        boolean bold = true;
        boolean invers = true;
        canvas.setColor(65488L);
        PrintTool.print5(canvas, 12, 60, 0, "print5 left", -1, 90);
        canvas.setColor(16755264L);
        PrintTool.print5(canvas, 348, 100, 0, "print5 right", 1, 90);
        canvas.setColor(0x66FFAAL);
        PrintTool.print5(canvas, 24, 240, 90, "vertical5", -1, 90);
        canvas.setColor(0xFF6699L);
        PrintTool.print5(canvas, 40, 150, 315, "diag5", -1, 90);
        canvas.setColor(0x99DDFFL);
        PrintTool.arcPrint5(canvas, 260, 70, 40, 210.0, "arcPrint5", 90);
        canvas.setColor(0xFFFFFFL);
        PrintTool.print6(canvas, 12, 120, 0, "print6 demo", -1, 100, bold, invers);
        canvas.setColor(52479L);
        PrintTool.print6(canvas, 348, 180, 0, "print6 right", 1, 90, bold, invers);
        canvas.setColor(0xFFCC00L);
        PrintTool.print6(canvas, 330, 240, 90, "vertical6", -1, 90, bold, invers);
        canvas.setColor(0xFF66FFL);
        PrintTool.print6(canvas, 140, 120, 315, "diagonal6", -1, 90, bold, invers);
        try {
            if (target.getParentFile() != null) {
                target.getParentFile().mkdirs();
            }
            canvas.save(target, "png");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to save PrintTool demo image", e);
        }
    }

    private static File determineTarget(String[] args) {
        if (args != null && args.length > 0) {
            File supplied = new File(args[0]);
            if (supplied.isDirectory()) {
                return new File(supplied, "printtool-demo.png");
            }
            return supplied;
        }
        return new File("printtool-demo.png");
    }
}

