/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.io.File;
import java.io.IOException;
import net.yacy.visualization.PrintTool;
import net.yacy.visualization.RasterPlotter;

public class DataSpindleCarouselPlotter
extends RasterPlotter {
    private final int centerX;
    private final int centerY;
    private final int[] ringRadii;
    private final long[] ringColors;

    public DataSpindleCarouselPlotter(int width, int height) {
        super(width, height, RasterPlotter.DrawMode.MODE_REPLACE, 20L);
        this.centerX = width / 2;
        this.centerY = height / 2;
        this.ringRadii = new int[]{40, 70, 100, 130};
        this.ringColors = new long[]{65484L, 0x66FF99L, 0xFF66CCL, 0x66AAFFL};
    }

    public void renderFrame(int frame) {
        this.clear();
        this.drawBackground();
        for (int i = 0; i < this.ringRadii.length; ++i) {
            this.drawRing(i, frame);
        }
        this.drawCenter(frame);
        this.drawOverlay(frame);
    }

    private void drawBackground() {
        this.setColor(6700L);
        for (int y = 0; y < this.getHeight(); y += 6) {
            this.line(0, y, this.getWidth(), y, 12);
        }
    }

    private void drawRing(int index2, int frame) {
        int radius = this.ringRadii[index2];
        long color = this.ringColors[index2];
        double rotation = (double)(frame * (index2 + 1)) * 7.0;
        this.setColor(DataSpindleCarouselPlotter.darken(color, 0.4));
        this.arc(this.centerX, this.centerY, radius - 4, radius + 4, 40);
        this.setColor(color);
        for (int spoke = 0; spoke < 6; ++spoke) {
            double angle = rotation + (double)spoke * 60.0;
            this.arcLine(this.centerX, this.centerY, radius - 6, radius + 6, angle, true, null, null, -1, -1, -1, false);
            int dotX = this.centerX + (int)(Math.cos(Math.toRadians(angle)) * (double)radius);
            int dotY = this.centerY - (int)(Math.sin(Math.toRadians(angle)) * (double)radius);
            this.dot(dotX, dotY, 4, true, 85);
        }
        this.setColor(DataSpindleCarouselPlotter.lighten(color, 1.3));
        this.arc(this.centerX, this.centerY, radius - 1, radius + 1, 90);
    }

    private void drawCenter(int frame) {
        long color = 61183L;
        this.setColor(61183L);
        this.dot(this.centerX, this.centerY, 12, true, 90);
        double angle = (double)frame * 9.0;
        this.arcLine(this.centerX, this.centerY, 12, 40, angle, true, null, null, -1, -1, -1, false);
        this.arcLine(this.centerX, this.centerY, 12, 40, angle + 120.0, true, null, null, -1, -1, -1, false);
        this.arcLine(this.centerX, this.centerY, 12, 40, angle + 240.0, true, null, null, -1, -1, -1, false);
    }

    private void drawOverlay(int frame) {
        this.setColor(0x66FFFFL);
        PrintTool.print5(this, 6, 12, 0, "DATA SPINDLE", -1, 80);
        this.setColor(65450L);
        PrintTool.print5(this, 6, 24, 0, String.format("IDX:%02d", frame % 32), -1, 70);
        this.setColor(52479L);
        PrintTool.print5(this, this.getWidth() - 6, 12, 0, "RPM" + frame * 37 % 1000, 1, 70);
    }

    public static void main(String[] args) {
        File dir;
        System.setProperty("java.awt.headless", "true");
        File file = dir = args.length > 0 ? new File(args[0]) : new File(".");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        DataSpindleCarouselPlotter plotter = new DataSpindleCarouselPlotter(400, 400);
        for (int frame = 0; frame < 8; ++frame) {
            plotter.renderFrame(frame);
            File out = new File(dir, String.format("data_spindle_%02d.png", frame));
            try {
                plotter.save(out, "png");
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to save spindle frame", e);
            }
        }
    }
}

