/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import net.yacy.visualization.PrintTool;
import net.yacy.visualization.RasterPlotter;

public class CrtHeatmapConsolePlotter
extends RasterPlotter {
    private final double[][] values;
    private final String[] rowLabels;
    private final String[] colLabels;

    public CrtHeatmapConsolePlotter(int width, int height, double[][] values, String[] rowLabels, String[] colLabels) {
        super(width, height, RasterPlotter.DrawMode.MODE_REPLACE, 16L);
        this.values = values;
        this.rowLabels = rowLabels;
        this.colLabels = colLabels;
    }

    public void render() {
        this.clear();
        this.drawScanlines();
        this.drawHeatmap();
        this.drawLegend();
    }

    private void drawScanlines() {
        this.setColor(4128L);
        for (int y = 0; y < this.getHeight(); y += 3) {
            this.line(0, y, this.getWidth(), y, 18);
        }
    }

    private void drawHeatmap() {
        int c;
        int r;
        int rows = this.values.length;
        int cols = this.values[0].length;
        int padding = 50;
        int cellWidth = (this.getWidth() - 100) / cols;
        int cellHeight = (this.getHeight() - 100) / rows;
        for (r = 0; r < rows; ++r) {
            for (int c2 = 0; c2 < cols; ++c2) {
                double v = this.values[r][c2];
                long color = this.colorForValue(v);
                int x = 50 + c2 * cellWidth;
                int y = 50 + r * cellHeight;
                this.fillCell(x, y, cellWidth - 2, cellHeight - 2, color, v);
            }
        }
        this.setColor(12111L);
        for (r = 0; r <= rows; ++r) {
            int y = 50 + r * cellHeight;
            this.line(50, y, 50 + cols * cellWidth, y, 30);
        }
        for (c = 0; c <= cols; ++c) {
            int x = 50 + c * cellWidth;
            this.line(x, 50, x, 50 + rows * cellHeight, 30);
        }
        this.setColor(65501L);
        for (r = 0; r < this.rowLabels.length; ++r) {
            PrintTool.print5(this, 42, 50 + r * cellHeight + cellHeight / 2, 0, this.rowLabels[r], 1, 65);
        }
        for (c = 0; c < this.colLabels.length; ++c) {
            PrintTool.print5(this, 50 + c * cellWidth + cellWidth / 2, 38, 0, this.colLabels[c], 0, 65);
        }
    }

    private long colorForValue(double value) {
        double clamped = Math.max(0.0, Math.min(1.0, value));
        int r = (int)(clamped * 255.0);
        int g = (int)((1.0 - Math.abs(clamped - 0.5) * 2.0) * 220.0);
        int b = (int)((1.0 - clamped) * 255.0);
        return r << 16 | g << 8 | b;
    }

    private void fillCell(int x, int y, int width, int height, long color, double value) {
        long base = CrtHeatmapConsolePlotter.darken(color, 0.4);
        for (int yy = 0; yy < height; ++yy) {
            double lineFactor = 0.8 + 0.2 * Math.sin((double)yy / 3.0);
            this.setColor(CrtHeatmapConsolePlotter.lighten(base, lineFactor));
            this.line(x, y + yy, x + width, y + yy, 60);
        }
        this.setColor(CrtHeatmapConsolePlotter.lighten(color, 1.6));
        this.line(x, y, x + width, y, 80);
        this.line(x, y + height, x + width, y + height, 40);
        this.line(x, y, x, y + height, 40);
        this.line(x + width, y, x + width, y + height, 40);
        this.setColor(4112L);
        PrintTool.print5(this, x + width / 2, y + height / 2, 0, String.format("%3.0f", value * 100.0), 0, 55);
    }

    private void drawLegend() {
        int x = this.getWidth() - 60;
        int y = 50;
        this.setColor(65484L);
        PrintTool.print5(this, x, 34, 90, "TEMP", -1, 70);
        for (int i = 0; i <= 8; ++i) {
            double v = (double)i / 8.0;
            long color = this.colorForValue(v);
            this.setColor(color);
            this.line(x - 12, 50 + i * 12, x, 50 + i * 12, 40);
            this.setColor(61183L);
            PrintTool.print5(this, x - 16, 50 + i * 12, 0, String.format("%2d", (int)(v * 100.0)), 1, 50);
        }
    }

    public static void main(String[] args) {
        File outDir;
        System.setProperty("java.awt.headless", "true");
        File file = outDir = args.length > 0 ? new File(args[0]) : new File(".");
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        int rows = 6;
        int cols = 8;
        double[][] values = new double[6][8];
        Random random = new Random(12648430L);
        for (int r = 0; r < 6; ++r) {
            for (int c = 0; c < 8; ++c) {
                values[r][c] = random.nextDouble();
            }
        }
        String[] rowLabels = new String[]{"NORTH", "NE", "EAST", "SE", "SOUTH", "CORE"};
        String[] colLabels = new String[]{"00", "03", "06", "09", "12", "15", "18", "21"};
        CrtHeatmapConsolePlotter plotter = new CrtHeatmapConsolePlotter(720, 420, values, rowLabels, colLabels);
        plotter.render();
        File out = new File(outDir, "crt_heatmap.png");
        try {
            plotter.save(out, "png");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save heatmap", e);
        }
    }
}

