/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.snippet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeSet;
import net.yacy.cora.document.analysis.Classification;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.id.AnchorURL;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.federate.solr.FailCategory;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.ByteArray;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.NumberTools;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.WordTokenizer;
import net.yacy.document.parser.html.ImageEntry;
import net.yacy.kelondro.index.RowHandleSet;
import net.yacy.repository.Blacklist;
import net.yacy.search.Switchboard;

public class MediaSnippet
implements Comparable<MediaSnippet>,
Comparator<MediaSnippet> {
    public Classification.ContentDomain type;
    public DigestURL href;
    public DigestURL source;
    public String name;
    public String attr;
    public String mime;
    public long ranking;
    public int width;
    public int height;
    public long fileSize;
    private int hashCache = Integer.MIN_VALUE;

    public MediaSnippet(Classification.ContentDomain type, DigestURL href, String mime, String name, long fileSize, String attr, long ranking, DigestURL source) {
        this.type = type;
        this.href = href;
        this.mime = mime;
        this.fileSize = fileSize;
        this.source = source;
        this.name = name;
        this.attr = attr;
        this.width = -1;
        this.height = -1;
        int p = 0;
        if (attr != null && (p = attr.indexOf(" x ", 0)) > 0) {
            this.width = NumberTools.parseIntDecSubstring(attr, 0, p);
            this.height = NumberTools.parseIntDecSubstring(attr, p + 3);
        }
        this.ranking = ranking;
        if (this.name == null || this.name.isEmpty()) {
            this.name = "_";
        }
        if (this.attr == null || this.attr.isEmpty()) {
            this.attr = "_";
        }
    }

    public MediaSnippet(Classification.ContentDomain type, DigestURL href, String mime, String name, long fileSize, int width, int height, long ranking, DigestURL source) {
        this.type = type;
        this.href = href;
        this.mime = mime;
        this.fileSize = fileSize;
        this.source = source;
        this.name = name;
        this.attr = width + " x " + height;
        this.width = width;
        this.height = height;
        this.ranking = ranking;
        if (this.name == null || this.name.isEmpty()) {
            this.name = "_";
        }
        if (this.attr == null || this.attr.isEmpty()) {
            this.attr = "_";
        }
    }

    public int hashCode() {
        if (this.hashCache == Integer.MIN_VALUE) {
            this.hashCache = ByteArray.hashCode(this.href.hash());
        }
        return this.hashCache;
    }

    public String toString() {
        return ASCII.String(this.href.hash());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaSnippet)) {
            return false;
        }
        MediaSnippet other = (MediaSnippet)obj;
        return Base64Order.enhancedCoder.equal(this.href.hash(), other.href.hash());
    }

    @Override
    public int compareTo(MediaSnippet o) {
        return Base64Order.enhancedCoder.compare(this.href.hash(), o.href.hash());
    }

    @Override
    public int compare(MediaSnippet o1, MediaSnippet o2) {
        return o1.compareTo(o2);
    }

    public static List<MediaSnippet> retrieveMediaSnippets(DigestURL url, HandleSet queryhashes, Classification.ContentDomain mediatype, CacheStrategy cacheStrategy, boolean reindexing) {
        Document document;
        if (queryhashes.isEmpty()) {
            ConcurrentLog.fine("snippet fetch", "no query hashes given for url " + String.valueOf(url));
            return new ArrayList<MediaSnippet>();
        }
        try {
            document = Document.mergeDocuments(url, null, Switchboard.getSwitchboard().loader.loadDocuments(Switchboard.getSwitchboard().loader.request(url, false, reindexing), cacheStrategy, Integer.MAX_VALUE, Blacklist.BlacklistType.SEARCH, ClientIdentification.yacyIntranetCrawlerAgent));
        }
        catch (IOException e) {
            ConcurrentLog.fine("snippet fetch", "load error: " + e.getMessage());
            return new ArrayList<MediaSnippet>();
        }
        catch (Parser.Failure e) {
            ConcurrentLog.fine("snippet fetch", "parser error: " + e.getMessage());
            return new ArrayList<MediaSnippet>();
        }
        ArrayList<MediaSnippet> a = new ArrayList<MediaSnippet>();
        if (document != null) {
            if (mediatype == Classification.ContentDomain.ALL || mediatype == Classification.ContentDomain.AUDIO) {
                a.addAll(MediaSnippet.computeMediaSnippets(url, document, queryhashes, Classification.ContentDomain.AUDIO));
            }
            if (mediatype == Classification.ContentDomain.ALL || mediatype == Classification.ContentDomain.VIDEO) {
                a.addAll(MediaSnippet.computeMediaSnippets(url, document, queryhashes, Classification.ContentDomain.VIDEO));
            }
            if (mediatype == Classification.ContentDomain.ALL || mediatype == Classification.ContentDomain.APP) {
                a.addAll(MediaSnippet.computeMediaSnippets(url, document, queryhashes, Classification.ContentDomain.APP));
            }
            if (mediatype == Classification.ContentDomain.ALL || mediatype == Classification.ContentDomain.IMAGE) {
                a.addAll(MediaSnippet.computeImageSnippets(url, document, queryhashes));
            }
        }
        return a;
    }

    public static List<MediaSnippet> computeMediaSnippets(DigestURL source, Document document, HandleSet queryhashes, Classification.ContentDomain mediatype) {
        if (document == null) {
            return new ArrayList<MediaSnippet>();
        }
        Map<AnchorURL, String> media = null;
        if (mediatype == Classification.ContentDomain.AUDIO) {
            media = document.getAudiolinks();
        } else if (mediatype == Classification.ContentDomain.VIDEO) {
            media = document.getVideolinks();
        } else if (mediatype == Classification.ContentDomain.APP) {
            media = document.getApplinks();
        }
        if (media == null) {
            return null;
        }
        Iterator<Map.Entry<AnchorURL, String>> i = media.entrySet().iterator();
        ArrayList<MediaSnippet> result = new ArrayList<MediaSnippet>();
        while (i.hasNext()) {
            int ranking;
            Map.Entry<AnchorURL, String> entry2 = i.next();
            AnchorURL url = entry2.getKey();
            String desc = entry2.getValue();
            if (MediaSnippet.isUrlBlacklisted(Blacklist.BlacklistType.SEARCH, url) || (ranking = MediaSnippet.removeAppearanceHashes(url.toNormalform(true), queryhashes).size() + MediaSnippet.removeAppearanceHashes(desc, queryhashes).size()) >= 2 * queryhashes.size()) continue;
            result.add(new MediaSnippet(mediatype, url, Classification.url2mime(url), desc, document.getTextLength(), null, ranking, source));
        }
        return result;
    }

    public static List<MediaSnippet> computeImageSnippets(DigestURL source, Document document, HandleSet queryhashes) {
        TreeSet<ImageEntry> images = new TreeSet<ImageEntry>();
        images.addAll(document.getImages().values());
        Iterator i = images.iterator();
        ArrayList<MediaSnippet> result = new ArrayList<MediaSnippet>();
        while (i.hasNext()) {
            ImageEntry ientry = (ImageEntry)i.next();
            DigestURL url = ientry.url();
            String u = url.toNormalform(false);
            if (MediaSnippet.isUrlBlacklisted(Blacklist.BlacklistType.SEARCH, url) || u.indexOf(".ico", 0) >= 0 || u.indexOf("favicon", 0) >= 0 || ientry.height() > 0 && ientry.height() < 32 || ientry.width() > 0 && ientry.width() < 32) continue;
            String desc = ientry.alt();
            int appcount = queryhashes.size() * 2 - MediaSnippet.removeAppearanceHashes(url.toNormalform(true), queryhashes).size() - MediaSnippet.removeAppearanceHashes(desc, queryhashes).size();
            long ranking = Long.MAX_VALUE - (long)((ientry.height() + 1) * (ientry.width() + 1) * (appcount + 1));
            result.add(new MediaSnippet(Classification.ContentDomain.IMAGE, url, Classification.url2mime(url), desc, ientry.fileSize(), ientry.width(), ientry.height(), ranking, source));
        }
        return result;
    }

    private static HandleSet removeAppearanceHashes(String sentence, HandleSet queryhashes) {
        if (sentence == null) {
            return queryhashes;
        }
        SortedMap<byte[], Integer> hs = WordTokenizer.hashSentence(sentence, 100);
        Iterator<byte[]> j = queryhashes.iterator();
        RowHandleSet remaininghashes = new RowHandleSet(queryhashes.keylen(), queryhashes.comparator(), queryhashes.size());
        while (j.hasNext()) {
            byte[] hash = j.next();
            Integer pos = (Integer)hs.get(hash);
            if (pos != null) continue;
            try {
                remaininghashes.put(hash);
            }
            catch (SpaceExceededException e) {
                ConcurrentLog.logException(e);
            }
        }
        remaininghashes.optimize();
        return remaininghashes;
    }

    private static boolean isUrlBlacklisted(Blacklist.BlacklistType blacklistType, DigestURL url) {
        boolean isBlacklisted = Switchboard.urlBlacklist.isListed(blacklistType, url.getHost().toLowerCase(Locale.ROOT), url.getFile());
        if (isBlacklisted) {
            Switchboard.getSwitchboard().crawlQueues.errorURL.push(url, 996, null, FailCategory.FINAL_LOAD_CONTEXT, "url in blacklist", -1);
            ConcurrentLog.fine("snippet fetch", "MEDIA-SNIPPET Rejecting URL '" + url.toNormalform(false) + "'. URL is in blacklist.");
        }
        return isBlacklisted;
    }
}

