/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.navigator;

import java.util.Collection;
import java.util.StringTokenizer;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.search.Switchboard;
import net.yacy.search.navigator.Navigator;
import net.yacy.search.navigator.NavigatorSort;
import net.yacy.search.navigator.StringNavigator;
import net.yacy.search.query.QueryModifier;
import net.yacy.search.schema.CollectionSchema;

public class TokenizedStringNavigator
extends StringNavigator
implements Navigator {
    public TokenizedStringNavigator(String title, CollectionSchema field, NavigatorSort sort) {
        super(title, field, sort);
    }

    @Override
    public void incDoc(URIMetadataNode doc) {
        block5: {
            Object val;
            if (this.field == null || (val = doc.getFieldValue(this.field.getSolrFieldName())) == null) break block5;
            if (val instanceof Collection) {
                Collection ll = (Collection)val;
                for (Object obj : ll) {
                    String s;
                    if (!(obj instanceof String) || (s = (String)obj).isEmpty()) continue;
                    StringTokenizer token = new StringTokenizer(s.toLowerCase(), " ,;");
                    while (token.hasMoreTokens()) {
                        String word = token.nextToken();
                        if (word.length() <= 1 || Switchboard.stopwords.contains(word)) continue;
                        this.inc(word);
                    }
                }
            } else {
                StringTokenizer token = new StringTokenizer((String)val, " ,;");
                while (token.hasMoreTokens()) {
                    String word = token.nextToken().toLowerCase();
                    if (word.length() <= 1 || Switchboard.stopwords.contains(word)) continue;
                    this.inc(word);
                }
            }
        }
    }

    @Override
    public boolean modifieractive(QueryModifier modifier, String key) {
        return modifier.toString().toLowerCase().contains(this.getQueryModifier(key));
    }
}

