/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.peers.graphics;

import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import net.yacy.peers.graphics.BannerData;
import net.yacy.visualization.PrintTool;
import net.yacy.visualization.RasterPlotter;

public final class Banner {
    private static final String QUERIES_HOUR = " QUERIES/HOUR";
    private static final String PAGES_MINUTE = " PAGES/MINUTE";
    private static final String QUERIES = "QUERIES:";
    private static final String WORDS = "WORDS:";
    private static final String LINKS = "LINKS:";
    private static final String NETWORK = "NETWORK:";
    private static final String SPEED = "SPEED:";
    private static final String TYPE = "TYPE:";
    private static final String DHT_WORDS = "DHT WORDS:";
    private static final String DOCUMENTS = "DOCUMENTS:";
    private static final String PEER_NAME = "PEER:";
    private static final int EXPR_LEN = 26;
    private static final DecimalFormatSymbols DFS = new DecimalFormatSymbols();
    private static final NumberFormat QPM_FORMAT;
    private static final NumberFormat LARGE_NUMBER_FORMAT;
    private static RasterPlotter bannerPicture;
    private static BufferedImage logo;
    private static long bannerPictureDate;

    private Banner() {
    }

    public static RasterPlotter getBannerPicture(BannerData data, long maxAge) {
        if (bannerPicture == null || Banner.bannerOutdated(maxAge)) {
            Banner.drawBannerPicture(data, logo);
        }
        return bannerPicture;
    }

    public static RasterPlotter getBannerPicture(BannerData data, long maxAge, BufferedImage newLogo) {
        if (bannerPicture == null || Banner.bannerOutdated(maxAge)) {
            Banner.drawBannerPicture(data, newLogo);
        }
        return bannerPicture;
    }

    private static boolean bannerOutdated(long maxAge) {
        return System.currentTimeMillis() - bannerPictureDate > maxAge;
    }

    private static void drawBannerPicture(BannerData data, BufferedImage newLogo) {
        logo = newLogo;
        bannerPicture = new RasterPlotter(data.getWidth(), data.getHeight(), RasterPlotter.DrawMode.MODE_REPLACE, data.getBgcolor());
        bannerPicture.setColor(data.getTextcolor());
        PrintTool.print5(bannerPicture, 100, 12, 0, PEER_NAME + Banner.addBlanks(data.getName(), PEER_NAME.length()), -1, 100);
        PrintTool.print5(bannerPicture, 100, 22, 0, DOCUMENTS + Banner.addBlanksAndDots(data.getLinks(), DOCUMENTS.length()), -1, 80);
        PrintTool.print5(bannerPicture, 100, 32, 0, DHT_WORDS + Banner.addBlanksAndDots(data.getWords(), DHT_WORDS.length()), -1, 80);
        PrintTool.print5(bannerPicture, 100, 42, 0, TYPE + Banner.addBlanks(data.getType(), TYPE.length()), -1, 80);
        PrintTool.print5(bannerPicture, 100, 52, 0, SPEED + Banner.addBlanks(data.getPpm() + PAGES_MINUTE, SPEED.length()), -1, 80);
        PrintTool.print5(bannerPicture, 290, 12, 0, NETWORK + Banner.addBlanks(data.getNetwork() + " [" + data.getPeers() + "]", NETWORK.length()), -1, 80);
        PrintTool.print5(bannerPicture, 290, 22, 0, LINKS + Banner.addBlanksAndDots(data.getNlinks(), LINKS.length()), -1, 80);
        PrintTool.print5(bannerPicture, 290, 32, 0, WORDS + Banner.addBlanksAndDots(data.getNwords(), WORDS.length()), -1, 80);
        PrintTool.print5(bannerPicture, 290, 42, 0, QUERIES + Banner.addBlanks(Banner.formatQpm(data.getNqph()) + QUERIES_HOUR, QUERIES.length()), -1, 80);
        PrintTool.print5(bannerPicture, 290, 52, 0, SPEED + Banner.addBlanks(data.getNppm() + PAGES_MINUTE, SPEED.length()), -1, 80);
        int height = data.getHeight();
        int width = data.getWidth();
        if (logo != null) {
            int x = 50 - logo.getWidth() / 2;
            int y = height / 2 - logo.getHeight() / 2;
            bannerPicture.insertBitmap(logo, x, y, 0, 0, RasterPlotter.FilterMode.FILTER_ANTIALIASING);
        }
        bannerPicture.setColor(data.getBordercolor());
        bannerPicture.line(0, 0, 0, height - 1, 100);
        bannerPicture.line(0, 0, width - 1, 0, 100);
        bannerPicture.line(width - 1, 0, width - 1, height - 1, 100);
        bannerPicture.line(0, height - 1, width - 1, height - 1, 100);
        bannerPictureDate = System.currentTimeMillis();
    }

    private static String addBlanksAndDots(long input, int length) {
        return Banner.addBlanks(LARGE_NUMBER_FORMAT.format(input), length);
    }

    private static String addBlanks(String word, int offset) {
        return String.format(String.format("%%%ds", 26 - offset), word);
    }

    private static String formatQpm(double qpm) {
        return qpm < 10.0 ? QPM_FORMAT.format(qpm) : Long.toString(Math.round(qpm));
    }

    public static boolean logoIsLoaded() {
        return logo != null;
    }

    static {
        DFS.setDecimalSeparator('.');
        DFS.setGroupingSeparator(',');
        QPM_FORMAT = new DecimalFormat("0.00", DFS);
        LARGE_NUMBER_FORMAT = new DecimalFormat("#,###", DFS);
        bannerPicture = null;
        logo = null;
        bannerPictureDate = 0L;
    }
}

