/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.peers;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.index.Index;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.table.Table;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.MapTools;
import net.yacy.kelondro.util.kelondroException;
import net.yacy.peers.Network;
import net.yacy.peers.Seed;

public class NewsDB {
    private final File path;
    private final Row rowdef;
    private final int attributesMaxLength;
    private Index news;
    private static final int categoryStringLength = 8;
    public static final int idLength = "yyyyMMddHHmmss".length() + 12;
    private static final GenericFormatter my_SHORT_SECOND_FORMATTER = new GenericFormatter(GenericFormatter.newShortSecondFormat(), 1000L);

    public NewsDB(File path, int maxNewsRecordLength, boolean useTailCache, boolean exceed134217727) {
        this.path = path;
        this.attributesMaxLength = maxNewsRecordLength - idLength - 8 - "yyyyMMddHHmmss".length() - 2;
        this.rowdef = new Row("String idx-" + idLength + " \"id = created + originator\",String cat-8,String rec-" + "yyyyMMddHHmmss".length() + ",short  dis-2 {b64e},String att-" + this.attributesMaxLength, NaturalOrder.naturalOrder);
        try {
            this.news = new Table(path, this.rowdef, 10, 0, useTailCache, exceed134217727, true);
        }
        catch (SpaceExceededException e) {
            try {
                this.news = new Table(path, this.rowdef, 0, 0, false, exceed134217727, true);
            }
            catch (SpaceExceededException e1) {
                ConcurrentLog.logException(e1);
            }
        }
    }

    private void resetDB() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.path.exists()) {
            FileUtils.deletedelete(this.path);
        }
        try {
            this.news = new Table(this.path, this.rowdef, 10, 0, false, false, true);
        }
        catch (SpaceExceededException e) {
            try {
                this.news = new Table(this.path, this.rowdef, 0, 0, false, false, true);
            }
            catch (SpaceExceededException e1) {
                ConcurrentLog.logException(e1);
            }
        }
    }

    public synchronized void close() {
        if (this.news != null) {
            this.news.close();
        }
        this.news = null;
    }

    public int size() {
        return this.news.size();
    }

    public void remove(String id) throws IOException {
        this.news.delete(UTF8.getBytes(id));
    }

    public synchronized Record put(Record record) throws IOException, SpaceExceededException {
        try {
            return this.b2r(this.news.replace(this.r2b(record)));
        }
        catch (Exception e) {
            this.resetDB();
            return this.b2r(this.news.replace(this.r2b(record)));
        }
    }

    public synchronized Record get(String id) throws IOException {
        if (this.news == null) {
            return null;
        }
        try {
            return this.b2r(this.news.get(UTF8.getBytes(id), false));
        }
        catch (kelondroException e) {
            this.resetDB();
            return null;
        }
    }

    private Record b2r(Row.Entry b) {
        Calendar c;
        if (b == null) {
            return null;
        }
        try {
            c = b.empty(2) ? null : my_SHORT_SECOND_FORMATTER.parse(b.getColASCII(2), 0);
        }
        catch (ParseException e) {
            c = null;
        }
        return new Record(b.getPrimaryKeyASCII(), b.getColUTF8(1), c == null ? null : c.getTime(), (int)b.getColLong(3), MapTools.string2map(b.getColUTF8(4), ","));
    }

    private final Row.Entry r2b(Record r) {
        if (r == null) {
            return null;
        }
        String attributes = r.attributes().toString();
        if (attributes.length() > this.attributesMaxLength) {
            ConcurrentLog.warn("yacyNewsDB", "attribute length=" + attributes.length() + " exceeds maximum size=" + this.attributesMaxLength);
            attributes = new HashMap().toString();
        }
        Row.Entry entry2 = this.news.row().newEntry();
        entry2.setCol(0, UTF8.getBytes(r.id()));
        entry2.setCol(1, UTF8.getBytes(r.category()));
        entry2.setCol(2, r.received() == null ? null : UTF8.getBytes(my_SHORT_SECOND_FORMATTER.format(r.received())));
        entry2.setCol(3, Base64Order.enhancedCoder.encodeLongBA(r.distributed(), 2));
        entry2.setCol(4, UTF8.getBytes(attributes));
        return entry2;
    }

    public Record newRecord(Seed mySeed, String category, Properties attributes) {
        try {
            HashMap<String, String> m = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry2 : attributes.entrySet()) {
                m.put((String)entry2.getKey(), (String)entry2.getValue());
            }
            return new Record(mySeed, category, m);
        }
        catch (IllegalArgumentException e) {
            Network.log.warn("rejected bad yacy news record (1): " + e.getMessage());
            return null;
        }
    }

    public Record newRecord(Seed mySeed, String category, Map<String, String> attributes) {
        try {
            return new Record(mySeed, category, attributes);
        }
        catch (IllegalArgumentException e) {
            Network.log.warn("rejected bad yacy news record (2): " + e.getMessage());
            return null;
        }
    }

    public Record newRecord(String external) {
        try {
            return new Record(external);
        }
        catch (IllegalArgumentException e) {
            Network.log.warn("rejected bad yacy news record (3): " + e.getMessage());
            return null;
        }
    }

    public class Record {
        private final String originator;
        private Date created;
        private Date received;
        private final String category;
        private int distributed;
        private final Map<String, String> attributes;

        private Record(String newsString) {
            this.attributes = MapTools.string2map(newsString, ",");
            if (this.attributes.toString().length() > NewsDB.this.attributesMaxLength) {
                throw new IllegalArgumentException("attributes length (" + this.attributes.toString().length() + ") exceeds maximum (" + NewsDB.this.attributesMaxLength + ")");
            }
            String string = this.category = this.attributes.containsKey("cat") ? this.attributes.get("cat") : "";
            if (this.category.length() > 8) {
                throw new IllegalArgumentException("category length (" + this.category.length() + ") exceeds maximum (8)");
            }
            try {
                this.received = this.attributes.containsKey("rec") ? my_SHORT_SECOND_FORMATTER.parse(this.attributes.get("rec"), 0).getTime() : new Date();
            }
            catch (ParseException e) {
                this.received = new Date();
            }
            try {
                this.created = this.attributes.containsKey("cre") ? my_SHORT_SECOND_FORMATTER.parse(this.attributes.get("cre"), 0).getTime() : new Date();
            }
            catch (ParseException e) {
                this.created = new Date();
            }
            this.distributed = this.attributes.containsKey("dis") ? Integer.parseInt(this.attributes.get("dis")) : 0;
            this.originator = this.attributes.containsKey("ori") ? this.attributes.get("ori") : "";
            this.removeStandards();
        }

        private Record(Seed mySeed, String category, Map<String, String> attributes) {
            if (category.length() > 8) {
                throw new IllegalArgumentException("category length (" + category.length() + ") exceeds maximum (8)");
            }
            if (attributes.toString().length() > NewsDB.this.attributesMaxLength) {
                throw new IllegalArgumentException("attributes length (" + attributes.toString().length() + ") exceeds maximum (" + NewsDB.this.attributesMaxLength + ")");
            }
            this.attributes = attributes;
            this.received = null;
            if (attributes.containsKey("#")) {
                int cnt = Integer.parseInt(attributes.get("#"));
                this.created = new Date(System.currentTimeMillis() + (long)(cnt * 1000));
            } else {
                this.created = new Date();
            }
            this.category = category;
            this.distributed = 0;
            this.originator = mySeed.hash;
            this.removeStandards();
        }

        private Record(String id, String category, Date received, int distributed, Map<String, String> attributes) {
            if (category.length() > 8) {
                throw new IllegalArgumentException("category length (" + category.length() + ") exceeds maximum (8)");
            }
            if (attributes.toString().length() > NewsDB.this.attributesMaxLength) {
                throw new IllegalArgumentException("attributes length (" + attributes.toString().length() + ") exceeds maximum (" + NewsDB.this.attributesMaxLength + ")");
            }
            this.attributes = attributes;
            this.received = received;
            try {
                this.created = my_SHORT_SECOND_FORMATTER.parse(id.substring(0, "yyyyMMddHHmmss".length()), 0).getTime();
            }
            catch (ParseException e) {
                this.created = new Date();
            }
            this.category = category;
            this.distributed = distributed;
            this.originator = id.substring("yyyyMMddHHmmss".length());
            this.removeStandards();
        }

        private void removeStandards() {
            this.attributes.remove("ori");
            this.attributes.remove("cat");
            this.attributes.remove("cre");
            this.attributes.remove("rec");
            this.attributes.remove("dis");
            this.attributes.remove("#");
        }

        public String toString() {
            if (this.originator != null) {
                this.attributes.put("ori", this.originator);
            }
            if (this.category != null) {
                this.attributes.put("cat", this.category);
            }
            if (this.created != null) {
                this.attributes.put("cre", my_SHORT_SECOND_FORMATTER.format(this.created));
            }
            if (this.received != null) {
                this.attributes.put("rec", my_SHORT_SECOND_FORMATTER.format(this.received));
            }
            this.attributes.put("dis", Integer.toString(this.distributed));
            String theString = this.attributes.toString();
            this.removeStandards();
            return theString;
        }

        public String id() {
            return my_SHORT_SECOND_FORMATTER.format(this.created) + this.originator;
        }

        public String originator() {
            return this.originator;
        }

        public Date created() {
            return this.created;
        }

        public Date received() {
            return this.received;
        }

        public String category() {
            return this.category;
        }

        public int distributed() {
            return this.distributed;
        }

        public void incDistribution() {
            ++this.distributed;
        }

        public Map<String, String> attributes() {
            return this.attributes;
        }

        public String attribute(String key, String dflt) {
            String s = this.attributes.get(key);
            if (s == null || s.isEmpty()) {
                return dflt;
            }
            return s;
        }
    }
}

