/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.util;

import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;

public final class MapTools {
    public static Properties s2p(String s) {
        Properties p = new Properties();
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            int pos = token.indexOf(61);
            if (pos <= 0) continue;
            p.setProperty(token.substring(0, pos).trim(), token.substring(pos + 1).trim());
        }
        return p;
    }

    public static ConcurrentHashMap<String, String> string2map(String string, String separator) {
        if (string == null) {
            return null;
        }
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        int pos = string.indexOf(123);
        if (pos >= 0) {
            string = string.substring(pos + 1).trim();
        }
        if ((pos = string.lastIndexOf(125)) >= 0) {
            string = string.substring(0, pos).trim();
        }
        StringTokenizer st = new StringTokenizer(string, separator);
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            pos = token.indexOf(61);
            if (pos <= 0) continue;
            map.put(token.substring(0, pos).trim(), token.substring(pos + 1).trim());
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String map2string(Map<String, String> m, String separator, boolean braces) {
        Map<String, String> map = m;
        synchronized (map) {
            StringBuilder buf = new StringBuilder(30 * m.size());
            if (braces) {
                buf.append('{');
            }
            for (int retry = 10; retry > 0; --retry) {
                try {
                    for (Map.Entry<String, String> e : m.entrySet()) {
                        if (e.getValue() == null) continue;
                        buf.append(e.getKey()).append('=').append(e.getValue()).append(separator);
                    }
                    break;
                }
                catch (ConcurrentModificationException e) {
                    buf.setLength(1);
                    buf.setLength(1);
                    continue;
                }
            }
            if (buf.length() > 1) {
                buf.setLength(buf.length() - 1);
            }
            if (braces) {
                buf.append('}');
            }
            return buf.toString();
        }
    }

    public static Set<String> string2set(String string, String separator) {
        if (string == null) {
            return null;
        }
        Set<String> set = Collections.synchronizedSet(new HashSet());
        int pos = string.indexOf(123);
        if (pos >= 0) {
            string = string.substring(pos + 1).trim();
        }
        if ((pos = string.lastIndexOf(125)) >= 0) {
            string = string.substring(0, pos).trim();
        }
        StringTokenizer st = new StringTokenizer(string, separator);
        while (st.hasMoreTokens()) {
            set.add(st.nextToken().trim());
        }
        return set;
    }

    public static String set2string(Set<String> s, String separator, boolean braces) {
        StringBuilder buf = new StringBuilder(s.size() * 40 + 1);
        if (braces) {
            buf.append('{');
        }
        Iterator<String> i = s.iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            buf.append(i.next());
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(separator);
        }
        if (braces) {
            buf.append('}');
        }
        return new String(buf);
    }
}

