/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.index.Index;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.index.RowCollection;
import net.yacy.kelondro.index.RowSet;
import net.yacy.kelondro.table.Table;
import net.yacy.kelondro.util.kelondroException;

public class OnDemandOpenFileIndex
implements Index,
Iterable<Row.Entry> {
    private final File file;
    private final Row rowdef;
    private int sizecache;
    private final boolean exceed134217727;

    public OnDemandOpenFileIndex(File file, Row rowdef, boolean exceed134217727) {
        this.file = file;
        this.rowdef = rowdef;
        this.exceed134217727 = exceed134217727;
        this.sizecache = -1;
    }

    private Index getIndex() {
        try {
            return new Table(this.file, this.rowdef, 1000, 0, false, this.exceed134217727, false);
        }
        catch (kelondroException e) {
            ConcurrentLog.logException(e);
            return null;
        }
        catch (SpaceExceededException e) {
            ConcurrentLog.logException(e);
            return null;
        }
    }

    @Override
    public synchronized byte[] smallestKey() {
        Index index2 = this.getIndex();
        if (index2 == null) {
            return null;
        }
        byte[] b = index2.smallestKey();
        index2.close();
        return b;
    }

    @Override
    public synchronized byte[] largestKey() {
        Index index2 = this.getIndex();
        if (index2 == null) {
            return null;
        }
        byte[] b = index2.largestKey();
        index2.close();
        return b;
    }

    @Override
    public synchronized void optimize() {
        Index index2 = this.getIndex();
        if (index2 == null) {
            return;
        }
        index2.optimize();
        index2.close();
    }

    @Override
    public synchronized long mem() {
        Index index2 = this.getIndex();
        if (index2 == null) {
            return 0L;
        }
        long l = index2.mem();
        index2.close();
        return l;
    }

    @Override
    public synchronized void addUnique(Row.Entry row) throws SpaceExceededException, IOException {
        Index index2 = this.getIndex();
        if (index2 == null) {
            return;
        }
        try {
            index2.addUnique(row);
            if (this.sizecache >= 0) {
                ++this.sizecache;
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            index2.close();
        }
    }

    @Override
    public synchronized void clear() throws IOException {
        Index index2 = this.getIndex();
        if (index2 == null) {
            return;
        }
        try {
            index2.clear();
            this.sizecache = 0;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            index2.close();
        }
    }

    @Override
    public synchronized void close() {
    }

    @Override
    public synchronized void deleteOnExit() {
        Index index2 = this.getIndex();
        index2.deleteOnExit();
        index2.close();
    }

    @Override
    public String filename() {
        return this.file.toString();
    }

    @Override
    public synchronized int size() {
        if (this.sizecache >= 0) {
            return this.sizecache;
        }
        Index index2 = this.getIndex();
        if (index2 == null) {
            return 0;
        }
        int i = index2.size();
        index2.close();
        this.sizecache = i;
        return i;
    }

    @Override
    public synchronized Row.Entry get(byte[] key, boolean forcecopy) throws IOException {
        if (this.sizecache == 0) {
            return null;
        }
        Index index2 = this.getIndex();
        if (index2 == null) {
            return null;
        }
        try {
            Row.Entry entry2 = index2.get(key, forcecopy);
            return entry2;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            index2.close();
        }
    }

    @Override
    public synchronized Map<byte[], Row.Entry> getMap(Collection<byte[]> keys, boolean forcecopy) throws IOException, InterruptedException {
        TreeMap<byte[], Row.Entry> map = new TreeMap<byte[], Row.Entry>(this.row().objectOrder);
        if (this.sizecache == 0) {
            return map;
        }
        for (byte[] key : keys) {
            Row.Entry entry2 = this.get(key, forcecopy);
            if (entry2 == null) continue;
            map.put(key, entry2);
        }
        return map;
    }

    @Override
    public synchronized List<Row.Entry> getList(Collection<byte[]> keys, boolean forcecopy) throws IOException, InterruptedException {
        ArrayList<Row.Entry> list2 = new ArrayList<Row.Entry>(keys.size());
        if (this.sizecache == 0) {
            return list2;
        }
        for (byte[] key : keys) {
            Row.Entry entry2 = this.get(key, forcecopy);
            if (entry2 == null) continue;
            list2.add(entry2);
        }
        return list2;
    }

    @Override
    public synchronized boolean has(byte[] key) {
        if (this.sizecache == 0) {
            return false;
        }
        Index index2 = this.getIndex();
        if (index2 == null) {
            return false;
        }
        boolean b = index2.has(key);
        index2.close();
        return b;
    }

    @Override
    public synchronized boolean isEmpty() {
        if (this.sizecache == 0) {
            return true;
        }
        Index index2 = this.getIndex();
        if (index2 == null) {
            return true;
        }
        boolean b = index2.isEmpty();
        if (b) {
            this.sizecache = 0;
        }
        index2.close();
        return b;
    }

    @Override
    public synchronized boolean put(Row.Entry row) throws IOException, SpaceExceededException {
        Index index2 = this.getIndex();
        if (index2 == null) {
            return false;
        }
        try {
            boolean b = index2.put(row);
            if (this.sizecache >= 0 && b) {
                ++this.sizecache;
            }
            boolean bl = b;
            return bl;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            index2.close();
        }
    }

    public synchronized void put(RowSet rowset) throws IOException, SpaceExceededException {
        Index index2 = this.getIndex();
        if (index2 == null) {
            return;
        }
        try {
            for (Row.Entry row : rowset) {
                boolean b = index2.put(row);
                if (this.sizecache < 0 || !b) continue;
                ++this.sizecache;
            }
            return;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            index2.close();
        }
    }

    @Override
    public synchronized Row.Entry remove(byte[] key) throws IOException {
        Index index2 = this.getIndex();
        if (index2 == null) {
            return null;
        }
        try {
            Row.Entry e = index2.remove(key);
            if (this.sizecache >= 0 && e != null) {
                --this.sizecache;
            }
            Row.Entry entry2 = e;
            return entry2;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            index2.close();
        }
    }

    @Override
    public synchronized boolean delete(byte[] key) throws IOException {
        Index index2 = this.getIndex();
        if (index2 == null) {
            return false;
        }
        try {
            boolean b = index2.delete(key);
            if (this.sizecache >= 0 && b) {
                --this.sizecache;
            }
            boolean bl = b;
            return bl;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            index2.close();
        }
    }

    @Override
    public synchronized List<RowCollection> removeDoubles() throws IOException, SpaceExceededException {
        Index index2 = this.getIndex();
        if (index2 == null) {
            return null;
        }
        try {
            List<RowCollection> l = index2.removeDoubles();
            this.sizecache = index2.size();
            List<RowCollection> list2 = l;
            return list2;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            index2.close();
        }
    }

    @Override
    public synchronized List<Row.Entry> top(int count) throws IOException {
        Index index2 = this.getIndex();
        if (index2 == null) {
            return null;
        }
        try {
            List<Row.Entry> list2 = index2.top(count);
            return list2;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            index2.close();
        }
    }

    @Override
    public synchronized List<Row.Entry> random(int count) throws IOException {
        Index index2 = this.getIndex();
        if (index2 == null) {
            return null;
        }
        try {
            List<Row.Entry> list2 = index2.random(count);
            return list2;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            index2.close();
        }
    }

    @Override
    public synchronized Row.Entry removeOne() throws IOException {
        Index index2 = this.getIndex();
        if (index2 == null) {
            return null;
        }
        try {
            Row.Entry e = index2.removeOne();
            if (this.sizecache >= 0 && e != null) {
                --this.sizecache;
            }
            Row.Entry entry2 = e;
            return entry2;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            index2.close();
        }
    }

    @Override
    public synchronized Row.Entry replace(Row.Entry row) throws SpaceExceededException, IOException {
        Index index2 = this.getIndex();
        if (index2 == null) {
            return null;
        }
        try {
            Row.Entry e = index2.replace(row);
            if (this.sizecache >= 0 && e == null) {
                ++this.sizecache;
            }
            Row.Entry entry2 = e;
            return entry2;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            index2.close();
        }
    }

    @Override
    public Row row() {
        return this.rowdef;
    }

    @Override
    public synchronized CloneableIterator<byte[]> keys(boolean up, byte[] firstKey) throws IOException {
        Index index2 = this.getIndex();
        if (index2 == null) {
            return null;
        }
        try {
            CloneableIterator<byte[]> cloneableIterator = index2.keys(up, firstKey);
            return cloneableIterator;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            index2.close();
        }
    }

    @Override
    public synchronized Iterator<Row.Entry> iterator() {
        Index index2 = this.getIndex();
        if (index2 == null) {
            return null;
        }
        ArrayList<Row.Entry> list2 = new ArrayList<Row.Entry>();
        Iterator<Row.Entry> i = index2.iterator();
        while (i.hasNext()) {
            list2.add(i.next());
        }
        index2.close();
        return list2.iterator();
    }

    @Override
    public synchronized CloneableIterator<Row.Entry> rows(boolean up, byte[] firstKey) throws IOException {
        Index index2 = this.getIndex();
        if (index2 == null) {
            return null;
        }
        ArrayList<Row.Entry> list2 = new ArrayList<Row.Entry>();
        CloneableIterator<Row.Entry> i = index2.rows(up, firstKey);
        while (i.hasNext()) {
            list2.add((Row.Entry)i.next());
        }
        index2.close();
        final Iterator li = list2.iterator();
        return new CloneableIterator<Row.Entry>(this){
            final /* synthetic */ OnDemandOpenFileIndex this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() {
                return li.hasNext();
            }

            @Override
            public Row.Entry next() {
                return (Row.Entry)li.next();
            }

            @Override
            public void remove() {
                li.remove();
            }

            @Override
            public CloneableIterator<Row.Entry> clone(Object modifier) {
                return null;
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public synchronized CloneableIterator<Row.Entry> rows() throws IOException {
        Index index2 = this.getIndex();
        if (index2 == null) {
            return null;
        }
        ArrayList<Row.Entry> list2 = new ArrayList<Row.Entry>();
        CloneableIterator<Row.Entry> i = index2.rows();
        while (i.hasNext()) {
            list2.add((Row.Entry)i.next());
        }
        index2.close();
        final Iterator li = list2.iterator();
        return new CloneableIterator<Row.Entry>(this){
            final /* synthetic */ OnDemandOpenFileIndex this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() {
                return li.hasNext();
            }

            @Override
            public Row.Entry next() {
                return (Row.Entry)li.next();
            }

            @Override
            public void remove() {
                li.remove();
            }

            @Override
            public CloneableIterator<Row.Entry> clone(Object modifier) {
                return null;
            }

            @Override
            public void close() {
            }
        };
    }
}

