/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.yacy;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.peers.DHTSelection;
import net.yacy.peers.Network;
import net.yacy.peers.Protocol;
import net.yacy.peers.Seed;
import net.yacy.peers.graphics.ProfilingGraph;
import net.yacy.search.EventTracker;
import net.yacy.search.Switchboard;
import net.yacy.server.serverCore;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public final class hello {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Seed remoteSeed;
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        long start = System.currentTimeMillis();
        prop.put("message", "none");
        String clientip = header.getRemoteAddr();
        InetAddress ias = Domains.dnsResolve(clientip);
        long time = System.currentTimeMillis();
        long time_dnsResolve = System.currentTimeMillis() - time;
        if (ias == null) {
            if (clientip == null) {
                clientip = "<unknown>";
            }
            Network.log.info("hello/server: failed contacting seed; clientip not resolvable (clientip=" + clientip + ", time_dnsResolve=" + time_dnsResolve + ")");
            prop.put("message", "cannot resolve your IP from your reported location " + clientip);
            return prop;
        }
        prop.put("yourip", ias.getHostAddress());
        prop.put("yourtype", "virgin");
        prop.put("seedlist", "");
        if (post == null || env == null) {
            prop.put("message", "no post or no enviroment");
            return prop;
        }
        if (!Protocol.authentifyRequest(post, env)) {
            prop.put("message", "not in my network");
            return prop;
        }
        String key = post.get("key", "");
        String seed = post.get("seed", "");
        int count = post.getInt("count", 0);
        if (seed.length() > 16000) {
            Network.log.info("hello/server: rejected contacting seed; too large (" + seed.length() + " > 16000, time_dnsResolve=" + time_dnsResolve + ")");
            prop.put("message", "your seed is too long (" + seed.length() + ")");
            return prop;
        }
        try {
            remoteSeed = Seed.genRemoteSeed(seed, true, ias.getHostAddress());
        }
        catch (IOException e) {
            Network.log.info("hello/server: bad seed: " + e.getMessage() + ", time_dnsResolve=" + time_dnsResolve);
            prop.put("message", "bad seed: " + e.getMessage());
            return prop;
        }
        if (remoteSeed == null || remoteSeed.hash == null) {
            Network.log.info("hello/server: bad seed: null, time_dnsResolve=" + time_dnsResolve);
            prop.put("message", "cannot parse your seed");
            return prop;
        }
        String userAgent = header.get("User-Agent", "<unknown>");
        sb.peers.peerActions.setUserAgent(clientip, userAgent);
        Set<String> reportedips = remoteSeed.getIPs();
        String reportedPeerType = remoteSeed.get("PeerType", "junior");
        if (remoteSeed.getPort() == sb.peers.mySeed().getPort() && sb.peers.mySeed().clash(reportedips)) {
            prop.put("message", "I am I");
            return prop;
        }
        if (remoteSeed.hash.equals(sb.peers.mySeed().hash)) {
            prop.put("message", "You are using my peer hash");
            return prop;
        }
        if (sb.isRobinsonMode() && !sb.isPublicRobinson()) {
            prop.put("message", "I am robinson, I do not answer");
            return prop;
        }
        long[] callback = new long[]{-1L, -1L};
        long time_backping = 0L;
        Object backping_method = "none";
        boolean success = false;
        if (!serverCore.useStaticIP || !ias.isSiteLocalAddress()) {
            reportedips.add(ias.getHostAddress());
        }
        int connectedBefore = sb.peers.sizeConnected();
        boolean preferHttps = sb.getConfigBool("network.unit.protocol.https.preferred", false);
        int totalTimeout = preferHttps ? 13000 : 6500;
        int callbackRemain = Math.min(5, reportedips.size());
        long callbackStart = System.currentTimeMillis();
        if (callbackRemain > 0 && reportedips.size() > 0) {
            for (String reportedip : reportedips) {
                int partialtimeout = (int)(callbackStart + (long)totalTimeout - System.currentTimeMillis()) / callbackRemain;
                if (partialtimeout <= 0) break;
                if (!Seed.isProperIP(reportedip)) continue;
                prop.put("yourip", reportedip);
                remoteSeed.setIP(reportedip);
                time = System.currentTimeMillis();
                try {
                    MultiProtocolURL remoteBaseURL = remoteSeed.getPublicMultiprotocolURL(reportedip, preferHttps);
                    callback = Protocol.queryRWICount(remoteBaseURL, remoteSeed, partialtimeout);
                    if (callback[0] < 0L && remoteBaseURL.isHTTPS()) {
                        remoteBaseURL = remoteSeed.getPublicMultiprotocolURL(reportedip, false);
                        callback = Protocol.queryRWICount(remoteBaseURL, remoteSeed, partialtimeout);
                    }
                }
                catch (MalformedURLException e) {
                    callback = new long[]{-1L, -1L};
                }
                time_backping = System.currentTimeMillis() - time;
                backping_method = "reportedip=" + reportedip;
                if (callback[0] >= 0L) {
                    success = true;
                    break;
                }
                if (--callbackRemain > 0) continue;
                break;
            }
        }
        if (success) {
            if (remoteSeed.get("PeerType", "senior") == null) {
                prop.put("yourtype", "senior");
                remoteSeed.put("PeerType", "senior");
            } else if (remoteSeed.get("PeerType", "principal").equals("principal")) {
                prop.put("yourtype", "principal");
            } else {
                prop.put("yourtype", "senior");
                remoteSeed.put("PeerType", "senior");
            }
            Network.log.fine("hello/server: responded remote " + reportedPeerType + " peer '" + remoteSeed.getName() + "' from " + String.valueOf(reportedips) + ", time_dnsResolve=" + time_dnsResolve + ", time_backping=" + time_backping + ", method=" + (String)backping_method + ", urls=" + callback[0]);
            sb.peers.peerActions.peerArrival(remoteSeed, true);
        } else {
            prop.put("yourip", ias.getHostAddress());
            remoteSeed.setIP(ias.getHostAddress());
            prop.put("yourtype", "junior");
            remoteSeed.put("PeerType", "junior");
            Network.log.fine("hello/server: responded remote " + reportedPeerType + " peer '" + remoteSeed.getName() + "' from " + String.valueOf(reportedips) + ", time_dnsResolve=" + time_dnsResolve + ", time_backping=" + time_backping + ", method=" + (String)backping_method + ", urls=" + callback[0]);
            if (remoteSeed.hash != null && remoteSeed.isProper(false) == null) {
                sb.peers.peerActions.peerPing(remoteSeed);
            }
        }
        remoteSeed.setLastSeenUTC();
        int connectedAfter = sb.peers.sizeConnected();
        EventTracker.update(EventTracker.EClass.PEERPING, new ProfilingGraph.EventPing(remoteSeed.getName(), sb.peers.myName(), false, connectedAfter - connectedBefore), false);
        if (!prop.get("yourtype").equals(reportedPeerType)) {
            Network.log.fine("hello/server: changing remote peer '" + remoteSeed.getName() + "' " + String.valueOf(reportedips) + " peerType from '" + reportedPeerType + "' to '" + prop.get("yourtype") + "'.");
        }
        StringBuilder seeds2 = new StringBuilder(768);
        if (sb.peers.sizeConnected() > 0) {
            if (count > sb.peers.sizeConnected()) {
                count = sb.peers.sizeConnected();
            }
            if (count > 100) {
                count = 100;
            }
            ConcurrentMap<String, Seed> ySeeds = DHTSelection.seedsByAge(sb.peers, true, count);
            seeds2.append("seed0=").append(sb.peers.mySeed().genSeedStr(key)).append(serverCore.CRLF_STRING);
            count = 1;
            if (ySeeds != null) {
                seeds2.ensureCapacity((ySeeds.size() + 1) * 768);
                for (Seed s : ySeeds.values()) {
                    String seedString;
                    if (s == null || s.isProper(false) != null || (seedString = s.genSeedStr(key)) == null) continue;
                    seeds2.append("seed").append(count).append('=').append(seedString).append(serverCore.CRLF_STRING);
                    ++count;
                }
            }
        } else {
            seeds2.append("seed0=").append(sb.peers.mySeed().genSeedStr(key)).append(serverCore.CRLF_STRING);
        }
        prop.put("seedlist", seeds2.toString());
        prop.put("message", "ok " + seed.length());
        Network.log.fine("hello/server: responded remote peer '" + remoteSeed.getName() + "' " + String.valueOf(reportedips) + " in " + (System.currentTimeMillis() - start) + " milliseconds");
        return prop;
    }
}

