/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import net.yacy.cora.protocol.Domains;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.index.RAMIndex;
import net.yacy.kelondro.table.Table;
import net.yacy.kelondro.util.Formatter;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.search.Switchboard;
import net.yacy.search.query.SearchEventCache;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class PerformanceMemory_p {
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        int p;
        String filename;
        serverObjects prop = new serverObjects();
        prop.put("gc", "0");
        prop.put("autoreload.checked", "0");
        if (post != null) {
            if (post.containsKey("gc")) {
                System.gc();
                prop.put("gc", "1");
                prop.put("autoreload.checked", "1");
            } else if (post.containsKey("dummy")) {
                boolean simulatedshortmemory = post.containsKey("simulatedshortmemory");
                MemoryControl.setSimulatedShortStatus(simulatedshortmemory);
                if (simulatedshortmemory) {
                    prop.put("autoreload.checked", "1");
                }
                boolean std = post.containsKey("useStandardmemoryStrategy");
                env.setConfig("memory.standardStrategy", std);
                MemoryControl.setStandardStrategy(std);
            }
        }
        prop.put("simulatedshortmemory.checked", MemoryControl.getSimulatedShortStatus() ? 1L : 0L);
        prop.put("useStandardmemoryStrategy.checked", env.getConfigBool("memory.standardStrategy", true) ? 1L : 0L);
        prop.put("memoryStrategy", MemoryControl.getStrategyName());
        long memoryFreeAfterInitBGC = env.getConfigLong("memoryFreeAfterInitBGC", 0L);
        long memoryFreeAfterInitAGC = env.getConfigLong("memoryFreeAfterInitAGC", 0L);
        long memoryFreeAfterStartup = env.getConfigLong("memoryFreeAfterStartup", 0L);
        long memoryTotalAfterInitBGC = env.getConfigLong("memoryTotalAfterInitBGC", 0L);
        long memoryTotalAfterInitAGC = env.getConfigLong("memoryTotalAfterInitAGC", 0L);
        long memoryTotalAfterStartup = env.getConfigLong("memoryTotalAfterStartup", 0L);
        prop.putNum("memoryMax", MemoryControl.maxMemory() / 0x100000L);
        prop.putNum("memoryAvailAfterStartup", (MemoryControl.maxMemory() - memoryTotalAfterStartup + memoryFreeAfterStartup) / 0x100000L);
        prop.putNum("memoryAvailAfterInitBGC", (MemoryControl.maxMemory() - memoryTotalAfterInitBGC + memoryFreeAfterInitBGC) / 0x100000L);
        prop.putNum("memoryAvailAfterInitAGC", (MemoryControl.maxMemory() - memoryTotalAfterInitAGC + memoryFreeAfterInitAGC) / 0x100000L);
        prop.putNum("memoryAvailNow", MemoryControl.available() / 0x100000L);
        prop.putNum("memoryTotalAfterStartup", memoryTotalAfterStartup / 0x100000L);
        prop.putNum("memoryTotalAfterInitBGC", memoryTotalAfterInitBGC / 0x100000L);
        prop.putNum("memoryTotalAfterInitAGC", memoryTotalAfterInitAGC / 0x100000L);
        prop.putNum("memoryTotalNow", MemoryControl.total() / 0x100000L);
        prop.putNum("memoryFreeAfterStartup", memoryFreeAfterStartup / 0x100000L);
        prop.putNum("memoryFreeAfterInitBGC", memoryFreeAfterInitBGC / 0x100000L);
        prop.putNum("memoryFreeAfterInitAGC", memoryFreeAfterInitAGC / 0x100000L);
        prop.putNum("memoryFreeNow", MemoryControl.free() / 0x100000L);
        prop.putNum("memoryUsedAfterStartup", (memoryTotalAfterStartup - memoryFreeAfterStartup) / 0x100000L);
        prop.putNum("memoryUsedAfterInitBGC", (memoryTotalAfterInitBGC - memoryFreeAfterInitBGC) / 0x100000L);
        prop.putNum("memoryUsedAfterInitAGC", (memoryTotalAfterInitAGC - memoryFreeAfterInitAGC) / 0x100000L);
        prop.putNum("memoryUsedNow", MemoryControl.used() / 0x100000L);
        Iterator<String> i = Table.filenames();
        int c = 0;
        long totalmem = 0L;
        while (i.hasNext()) {
            filename = i.next();
            Table.TableStatistics stats = Table.memoryStats(filename);
            totalmem += stats.getTotalMem();
            prop.put("EcoList_" + c + "_tableIndexPath", (p = filename.indexOf("DATA", 0)) < 0 ? filename : filename.substring(p));
            prop.putNum("EcoList_" + c + "_tableSize", stats.getTableSize());
            prop.put("EcoList_" + c + "_tableKeyMem", Formatter.bytesToString(stats.getKeyMem()));
            prop.put("EcoList_" + c + "_tableKeyChunkSize", Formatter.bytesToString(stats.getKeyChunkSize()));
            prop.put("EcoList_" + c + "_tableValueMem", Formatter.bytesToString(stats.getValueMem()));
            prop.put("EcoList_" + c + "_tableValueChunkSize", Formatter.bytesToString(stats.getValueChunkSize()));
            ++c;
        }
        prop.put("EcoList", c);
        prop.putNum("EcoIndexTotalMem", (double)totalmem / 1048576.0);
        Iterator<Map.Entry<String, RAMIndex>> oi = RAMIndex.objects();
        c = 0;
        long totalhitmem = 0L;
        while (oi.hasNext()) {
            Map.Entry<String, RAMIndex> oie;
            try {
                oie = oi.next();
            }
            catch (ConcurrentModificationException e) {
                ConcurrentLog.logException(e);
                break;
            }
            filename = oie.getKey();
            RAMIndex cache = oie.getValue();
            p = filename.indexOf("DATA", 0);
            prop.put("indexcache_" + c + "_Name", p < 0 ? filename : filename.substring(p));
            long hitmem = cache.mem();
            totalhitmem += hitmem;
            prop.put("indexcache_" + c + "_ChunkSize", cache.row().objectsize);
            prop.putNum("indexcache_" + c + "_Count", cache.size());
            prop.put("indexcache_" + c + "_NeededMem", cache.size() * cache.row().objectsize);
            prop.put("indexcache_" + c + "_UsedMem", hitmem);
            ++c;
        }
        prop.put("indexcache", c);
        prop.putNum("indexcacheTotalMem", (double)totalhitmem / 1048576.0);
        prop.putNum("namecacheHit.size", Domains.nameCacheHitSize());
        prop.putNum("namecacheHit.Hit", Domains.cacheHit_Hit);
        prop.putNum("namecacheHit.Miss", Domains.cacheHit_Miss);
        prop.putNum("namecacheHit.Insert", Domains.cacheHit_Insert);
        prop.putNum("namecacheMiss.size", Domains.nameCacheMissSize());
        prop.putNum("namecacheMiss.Hit", Domains.cacheMiss_Hit);
        prop.putNum("namecacheMiss.Miss", Domains.cacheMiss_Miss);
        prop.putNum("namecacheMiss.Insert", Domains.cacheMiss_Insert);
        prop.putNum("namecache.noCache", Domains.nameCacheNoCachingPatternsSize());
        prop.putNum("blacklistcache.size", Switchboard.urlBlacklist.blacklistCacheSize());
        prop.putNum("searchevent.size", SearchEventCache.size());
        prop.putNum("searchevent.hit", SearchEventCache.cacheHit);
        prop.putNum("searchevent.miss", SearchEventCache.cacheMiss);
        prop.putNum("searchevent.insert", SearchEventCache.cacheInsert);
        prop.putNum("searchevent.delete", SearchEventCache.cacheDelete);
        return prop;
    }
}

