/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.awt.Color;
import java.awt.Image;
import java.util.HashMap;
import java.util.Iterator;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.kelondro.workflow.BusyThread;
import net.yacy.peers.graphics.NetworkGraph;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class PeerLoadPicture {
    public static Image respond(RequestHeader header, serverObjects post, serverSwitch env) {
        int width = 800;
        int height = 600;
        boolean showidle = true;
        if (post != null) {
            width = post.getInt("width", 800);
            height = post.getInt("height", 600);
            showidle = post.getBoolean("showidle");
        }
        NetworkGraph.CircleThreadPiece idle = new NetworkGraph.CircleThreadPiece("Idle", new Color(170, 255, 170));
        NetworkGraph.CircleThreadPiece misc = new NetworkGraph.CircleThreadPiece("Misc.", new Color(190, 50, 180));
        HashMap<String, NetworkGraph.CircleThreadPiece> pieces = new HashMap<String, NetworkGraph.CircleThreadPiece>();
        pieces.put(null, idle);
        pieces.put("20_dhtdistribution", new NetworkGraph.CircleThreadPiece("DHT-Distribution", new Color(119, 136, 153)));
        pieces.put("30_peerping", new NetworkGraph.CircleThreadPiece("YaCy Core", new Color(255, 230, 160)));
        Iterator<String> threads = env.threadNames();
        long busy_time = 0L;
        while (threads.hasNext()) {
            NetworkGraph.CircleThreadPiece piece;
            String threadname = threads.next();
            BusyThread thread = env.getThread(threadname);
            busy_time += thread.getBlockTime();
            busy_time += thread.getExecTime();
            if (showidle) {
                idle.addExecTime(thread.getSleepTime());
            }
            if ((piece = (NetworkGraph.CircleThreadPiece)pieces.get(threadname)) == null) {
                misc.addExecTime(thread.getBlockTime() + thread.getExecTime());
                continue;
            }
            piece.addExecTime(thread.getBlockTime() + thread.getExecTime());
        }
        busy_time += idle.getExecTime();
        Iterator it = pieces.values().iterator();
        while (it.hasNext()) {
            NetworkGraph.CircleThreadPiece current = (NetworkGraph.CircleThreadPiece)it.next();
            current.setFraction(busy_time);
            if (current.getAngle() != 0) continue;
            it.remove();
        }
        misc.setFraction(busy_time);
        if (width < 40) {
            width = 40;
        }
        if (width > 1920) {
            width = 1920;
        }
        if (height < 30) {
            height = 30;
        }
        if (height > 1440) {
            height = 1440;
        }
        return NetworkGraph.getPeerLoadPicture(5000L, width, height, pieces.values().toArray(new NetworkGraph.CircleThreadPiece[pieces.size()]), misc);
    }
}

