/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.Locale;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.FederateSearchManager;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.storage.Configuration;
import net.yacy.cora.storage.Files;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.robots.RobotsTxtEntry;
import net.yacy.search.Switchboard;
import net.yacy.search.schema.WebgraphSchema;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class ConfigHeuristics_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        boolean showmetafieldbutton;
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        String osderrmsg = "";
        if (post != null) {
            block39: {
                String tmpname;
                String tmpurl;
                sb.tables.recordAPICall(post, "ConfigHeuristics.html", "configuration", "heuristic settings");
                if (post.containsKey("site_on")) {
                    sb.setConfig("heuristic.site", true);
                }
                if (post.containsKey("site_off")) {
                    sb.setConfig("heuristic.site", false);
                }
                if (post.containsKey("searchresult_on")) {
                    sb.setConfig("heuristic.searchresults", true);
                }
                if (post.containsKey("searchresult_off")) {
                    sb.setConfig("heuristic.searchresults", false);
                }
                if (post.containsKey("searchresultglobal_on")) {
                    sb.setConfig("heuristic.searchresults.crawlglobal", true);
                }
                if (post.containsKey("searchresultglobal_off")) {
                    sb.setConfig("heuristic.searchresults.crawlglobal", false);
                }
                if (post.containsKey("opensearch_on")) {
                    sb.setConfig("heuristic.opensearch", true);
                    FederateSearchManager.getManager().init(sb.getDataPath().getAbsolutePath() + "DATA/SETTINGS/heuristicopensearch.conf");
                    if (FederateSearchManager.getManager().getSize() == 0) {
                        osderrmsg = "no active search targets are configured";
                    }
                }
                if (post.containsKey("opensearch_off")) {
                    sb.setConfig("heuristic.opensearch", false);
                }
                if (post.containsKey("discoverosd")) {
                    boolean metafieldavailable;
                    boolean bl = metafieldavailable = sb.index.fulltext().getWebgraphConfiguration().contains(WebgraphSchema.target_rel_s.name()) && sb.index.fulltext().getWebgraphConfiguration().contains(WebgraphSchema.target_protocol_s.name()) && sb.index.fulltext().getWebgraphConfiguration().contains(WebgraphSchema.target_urlstub_s.name());
                    osderrmsg = metafieldavailable ? (FederateSearchManager.getManager().discoverFromSolrIndex(sb) ? "started background search for target systems, refresh page after some minutes" : "Error: webgraph Solr index not enabled") : "Solr webgraph index needs to be available and fields target_rel_s, target_protocol_s, target_urlstub_s on";
                }
                if ((tmpurl = post.get("ossys_newurl")) != null && !tmpurl.isEmpty()) {
                    post.put("addnewosd", 1L);
                }
                if (post.containsKey("addnewosd") && (tmpname = post.get("ossys_newtitle")) != null && tmpurl != null) {
                    if (!tmpname.isEmpty() && !tmpurl.isEmpty() && tmpurl.toLowerCase(Locale.ROOT).contains("{searchterms}")) {
                        RobotsTxtEntry robotsEntry = null;
                        try {
                            MultiProtocolURL templateURL = new MultiProtocolURL(tmpurl);
                            if (sb.robots != null) {
                                robotsEntry = sb.robots.getEntry(templateURL, ClientIdentification.yacyInternetCrawlerAgent);
                            }
                            if (robotsEntry != null && robotsEntry.isDisallowed(templateURL)) {
                                osderrmsg = "URL template is disallowed by the host robots.xt";
                                break block39;
                            }
                            String tmpcomment = post.get("ossys_newcomment");
                            FederateSearchManager.getManager().addOpenSearchTarget(tmpname, tmpurl, false, tmpcomment);
                        }
                        catch (MalformedURLException ex) {
                            osderrmsg = "URL template is malformed.";
                        }
                    } else {
                        osderrmsg = "Url template must contain '{searchTerms}'";
                    }
                }
            }
            if (post.containsKey("setopensearch")) {
                ConfigHeuristics_p.writeopensearchcfg(sb, post);
            }
            if (post.containsKey("switchsolrfieldson")) {
                boolean metafieldavailable;
                boolean bl = metafieldavailable = sb.index.fulltext().getWebgraphConfiguration().contains(WebgraphSchema.target_rel_s.name()) && sb.index.fulltext().getWebgraphConfiguration().contains(WebgraphSchema.target_protocol_s.name()) && sb.index.fulltext().getWebgraphConfiguration().contains(WebgraphSchema.target_urlstub_s.name());
                if (!metafieldavailable) {
                    Configuration.Entry entry2 = (Configuration.Entry)sb.index.fulltext().getWebgraphConfiguration().get(WebgraphSchema.target_rel_s.name());
                    if (entry2 != null && !entry2.enabled()) {
                        entry2.setEnable(true);
                    }
                    if ((entry2 = (Configuration.Entry)sb.index.fulltext().getWebgraphConfiguration().get(WebgraphSchema.target_protocol_s.name())) != null && !entry2.enabled()) {
                        entry2.setEnable(true);
                    }
                    if ((entry2 = (Configuration.Entry)sb.index.fulltext().getWebgraphConfiguration().get(WebgraphSchema.target_urlstub_s.name())) != null && !entry2.enabled()) {
                        entry2.setEnable(true);
                    }
                    try {
                        sb.index.fulltext().getWebgraphConfiguration().commit();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    sb.setConfig("core.service.webgraph.tmp", true);
                }
            }
            if (post.containsKey("copydefaultosdconfig") || post.containsKey("resettodefaultosdlist")) {
                File osdDefaultConfig = new File(sb.getAppPath(), "defaults/heuristicopensearch.conf");
                File osdConfig = new File(sb.getDataPath(), "DATA/SETTINGS/heuristicopensearch.conf");
                if ((post.containsKey("resettodefaultosdlist") || !osdConfig.exists()) && osdDefaultConfig.exists()) {
                    try {
                        Files.copy(osdDefaultConfig, osdConfig);
                        File defdir = new File(sb.dataPath, "DATA/SETTINGS/federatecfg");
                        if (!defdir.exists()) {
                            Files.copy(new File(sb.appPath, "defaults/federatecfg"), defdir);
                        }
                    }
                    catch (IOException ex) {
                        osderrmsg = "file I/O error during copy";
                    }
                } else {
                    osderrmsg = "config file exists or default doesn't exist";
                }
            }
        }
        boolean bl = showmetafieldbutton = sb.index.fulltext().getWebgraphConfiguration().contains(WebgraphSchema.target_rel_s.name()) && sb.index.fulltext().getWebgraphConfiguration().contains(WebgraphSchema.target_protocol_s.name()) && sb.index.fulltext().getWebgraphConfiguration().contains(WebgraphSchema.target_urlstub_s.name()) && sb.getConfigBool("core.service.webgraph.tmp", false);
        if (!showmetafieldbutton) {
            prop.put("osdsolrfieldswitch", 1L);
        }
        prop.put("site.checked", sb.getConfigBool("heuristic.site", false) ? 1L : 0L);
        prop.put("searchresult.checked", sb.getConfigBool("heuristic.searchresults", false) ? 1L : 0L);
        prop.put("searchresultglobal.checked", sb.getConfigBool("heuristic.searchresults.crawlglobal", false) ? 1L : 0L);
        prop.put("opensearch.checked", sb.getConfigBool("heuristic.opensearch", false) ? 1L : 0L);
        File f = new File(sb.getDataPath(), "DATA/SETTINGS/heuristicopensearch.conf");
        try {
            Configuration p = new Configuration(f);
            int c = 0;
            boolean dark = false;
            Iterator<Configuration.Entry> i = p.entryIterator();
            while (i.hasNext()) {
                int lastpos;
                Configuration.Entry e = i.next();
                prop.put("osdcfg_" + c + "_dark", dark ? 1L : 0L);
                dark = !dark;
                prop.put("osdcfg_" + c + "_checked", e.enabled() ? 1L : 0L);
                prop.putHTML("osdcfg_" + c + "_title", e.key());
                prop.putHTML("osdcfg_" + c + "_comment", e.getComment() != null ? e.getComment() : "");
                String urlStr = e.getValue();
                prop.putHTML("osdcfg_" + c + "_url", urlStr);
                int n = lastpos = urlStr != null ? urlStr.lastIndexOf("/") : -1;
                if (lastpos > 6) {
                    urlStr = urlStr.substring(0, lastpos);
                    prop.putHTML("osdcfg_" + c + "_urlhostlink", urlStr);
                } else {
                    prop.putHTML("osdcfg_" + c + "_urlhostlink", "#");
                }
                ++c;
            }
            prop.put("osdcfg", c);
        }
        catch (IOException e1) {
            ConcurrentLog.warn("OpenSearchConnector", "file not found " + f.getAbsolutePath());
            prop.put("osdcfg", 0L);
        }
        prop.putHTML("osderrmsg", osderrmsg);
        return prop;
    }

    private static void writeopensearchcfg(Switchboard sb, serverObjects post) {
        File f = new File(sb.getDataPath(), "DATA/SETTINGS/heuristicopensearch.conf");
        try {
            Configuration cfg = new Configuration(f);
            Iterator<Configuration.Entry> cfgentries = cfg.entryIterator();
            boolean modified = false;
            while (cfgentries.hasNext()) {
                String v;
                boolean c;
                Configuration.Entry entry2 = cfgentries.next();
                String sfn = post.get("ossys_url_" + entry2.key());
                if (sfn != null && !sfn.equals(entry2.getValue())) {
                    entry2.setValue(sfn);
                    modified = true;
                }
                boolean bl = c = (v = post.get("ossys_" + entry2.key())) != null && v.equals("checked");
                if (entry2.enabled() != c) {
                    entry2.setEnable(c);
                    modified = true;
                }
                if (!(c = (v = post.get("ossys_del_" + entry2.key())) != null && v.equals("checked"))) continue;
                cfgentries.remove();
                modified = true;
            }
            if (modified) {
                try {
                    cfg.commit();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e) {
            ConcurrentLog.warn("OpenSearchConnector", "file not found " + f.getAbsolutePath());
        }
        if (sb.getConfigBool("heuristic.opensearch", true)) {
            FederateSearchManager.getManager().init(f.getAbsolutePath());
        }
    }
}

