/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.yacy.cora.document.id.Punycode;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.ListManager;
import net.yacy.document.parser.html.CharacterCoding;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.repository.Blacklist;
import net.yacy.repository.BlacklistHostAndPath;
import net.yacy.search.Switchboard;
import net.yacy.search.query.SearchEventCache;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class BlacklistCleaner_p {
    private static final String APP_NAME = "BLACKLIST-CLEANER";
    private static final String RESULTS = "results_";
    private static final String DISABLED = "disabled_";
    private static final String BLACKLISTS = "blacklists_";
    private static final String ENTRIES = "entries_";
    public static final Class<?>[] supportedBLEngines = new Class[]{Blacklist.class};

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        serverObjects prop = new serverObjects();
        String blacklistToUse = null;
        prop.put("disabled_checked", "1");
        if (post != null) {
            boolean allowRegex = post.get("allowRegex", "off").equalsIgnoreCase("on");
            prop.put("disabled_checked", allowRegex ? "1" : "0");
            if (post.containsKey("listNames") && ((blacklistToUse = post.get("listNames")).isEmpty() || !ListManager.listSetContains("listManager.listsPath", blacklistToUse))) {
                prop.put("results", "2");
            }
            BlacklistCleaner_p.putBlacklists(prop, FileUtils.getDirListing(ListManager.listsPath, "^.*\\.black$"), blacklistToUse);
            if (blacklistToUse != null) {
                prop.put("results", "1");
                if (post.containsKey("delete")) {
                    prop.put("results_modified", "1");
                    prop.put("results_modified_delCount", BlacklistCleaner_p.removeEntries(blacklistToUse, Blacklist.BlacklistType.values(), BlacklistCleaner_p.getKeysByPrefix(post, "select", true)));
                } else if (post.containsKey("alter")) {
                    prop.put("results_modified", "2");
                    prop.put("results_modified_alterCount", BlacklistCleaner_p.alterEntries(blacklistToUse, Blacklist.BlacklistType.values(), BlacklistCleaner_p.getKeysByPrefix(post, "select", false), BlacklistCleaner_p.getValuesByPrefix(post, "entry", false)));
                }
                Map<String, Blacklist.BlacklistError> illegalEntries = BlacklistCleaner_p.getIllegalEntries(blacklistToUse, allowRegex);
                prop.put("results_blList", blacklistToUse);
                prop.put("results_entries", illegalEntries.size());
                prop.putHTML("results_blEngine", Blacklist.getEngineInfo());
                prop.put("results_disabled", illegalEntries.isEmpty() ? "1" : "0");
                if (!illegalEntries.isEmpty()) {
                    prop.put("results_disabled_entries", illegalEntries.size());
                    int i = 0;
                    for (Map.Entry<String, Blacklist.BlacklistError> entry2 : illegalEntries.entrySet()) {
                        String key = entry2.getKey();
                        prop.put("results_disabled_entries_" + i + "_error", entry2.getValue().getLong());
                        prop.put("results_disabled_entries_" + i + "_entry", CharacterCoding.unicode2html(key, true));
                        ++i;
                    }
                }
            }
        } else {
            prop.put("results", "0");
            BlacklistCleaner_p.putBlacklists(prop, FileUtils.getDirListing(ListManager.listsPath, "^.*\\.black$"), blacklistToUse);
        }
        return prop;
    }

    private static void putBlacklists(serverObjects prop, List<String> lists, String selected) {
        int i;
        boolean supported = false;
        for (i = 0; i < supportedBLEngines.length && !supported; supported |= Switchboard.urlBlacklist.getClass() == supportedBLEngines[i], ++i) {
        }
        if (supported) {
            if (!lists.isEmpty()) {
                prop.put("disabled", "0");
                prop.put("disabled_blacklists", lists.size());
                int count = 0;
                for (String list2 : lists) {
                    prop.putHTML("disabled_blacklists_" + count + "_name", list2);
                    prop.put("disabled_blacklists_" + count + "_selected", list2.equals(selected) ? "1" : "0");
                    ++count;
                }
            } else {
                prop.put("disabled", "2");
            }
        } else {
            prop.put("disabled", "1");
            for (i = 0; i < supportedBLEngines.length; ++i) {
                prop.putHTML("disabled_engines_" + i + "_name", supportedBLEngines[i].getName());
            }
            prop.put("disabled_engines", supportedBLEngines.length);
        }
    }

    private static String[] getKeysByPrefix(serverObjects post, String prefix, boolean filterDoubles) {
        return BlacklistCleaner_p.getByPrefix(post, prefix, true, filterDoubles);
    }

    private static String[] getValuesByPrefix(serverObjects post, String prefix, boolean filterDoubles) {
        return BlacklistCleaner_p.getByPrefix(post, prefix, false, filterDoubles);
    }

    private static String[] getByPrefix(serverObjects post, String prefix, boolean useKeys, boolean useHashSet) {
        AbstractCollection r = useHashSet ? new HashSet() : new ArrayList();
        if (useKeys) {
            for (String entry2 : post.keySet()) {
                if (entry2.indexOf(prefix) != 0) continue;
                r.add(entry2.substring(prefix.length()));
            }
        } else {
            for (Map.Entry<String, String> entry3 : post.entrySet()) {
                if (entry3.getKey().indexOf(prefix) != 0) continue;
                r.add(entry3.getValue());
            }
        }
        return r.toArray(new String[r.size()]);
    }

    private static Map<String, Blacklist.BlacklistError> getIllegalEntries(String blacklistToUse, boolean allowRegex) {
        HashMap<String, Blacklist.BlacklistError> illegalEntries = new HashMap<String, Blacklist.BlacklistError>();
        HashSet<String> legalEntries = new HashSet<String>();
        ArrayList<String> list2 = FileUtils.getListArray(new File(ListManager.listsPath, blacklistToUse));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("allowRegex", String.valueOf(allowRegex));
        for (String element : list2) {
            if (legalEntries.contains(element = element.trim())) {
                illegalEntries.put(element, Blacklist.BlacklistError.DOUBLE_OCCURANCE);
                continue;
            }
            legalEntries.add(element);
            Blacklist.BlacklistError err = Blacklist.checkError(element, properties);
            if (err.getInt() <= 0) continue;
            illegalEntries.put(element, err);
        }
        return illegalEntries;
    }

    private static int removeEntries(String blacklistToUse, Blacklist.BlacklistType[] supportedBlacklistTypes, String[] entries2) {
        for (String entry2 : entries2) {
            String s = entry2;
            if (s.contains("\\\\")) {
                s = s.replaceAll(Pattern.quote("\\\\"), Matcher.quoteReplacement("\\"));
            }
            for (Blacklist.BlacklistType supportedBlacklistType : supportedBlacklistTypes) {
                if (!ListManager.listSetContains(String.valueOf((Object)supportedBlacklistType) + ".BlackLists", blacklistToUse)) continue;
                String host = s.indexOf(47, 0) == -1 ? s : s.substring(0, s.indexOf(47, 0));
                String path = s.indexOf(47, 0) == -1 ? ".*" : s.substring(s.indexOf(47, 0) + 1);
                try {
                    Switchboard.urlBlacklist.remove(supportedBlacklistType, blacklistToUse, host, path);
                }
                catch (RuntimeException e) {
                    ConcurrentLog.severe(APP_NAME, e.getMessage() + ": " + host + "/" + path);
                }
            }
            SearchEventCache.cleanupEvents(true);
        }
        return entries2.length;
    }

    private static int alterEntries(String blacklistToUse, Blacklist.BlacklistType[] supportedBlacklistTypes, String[] oldEntry, String[] newEntry) {
        BlacklistCleaner_p.removeEntries(blacklistToUse, supportedBlacklistTypes, oldEntry);
        ArrayList<BlacklistHostAndPath> newEntries = new ArrayList<BlacklistHostAndPath>();
        for (String string : newEntry) {
            String path;
            String host;
            int pos = string.indexOf(47, 0);
            if (pos < 0) {
                host = string;
                path = ".*";
            } else {
                host = string.substring(0, pos);
                path = string.substring(pos + 1);
            }
            newEntries.add(new BlacklistHostAndPath(host, path));
        }
        for (Blacklist.BlacklistType blacklistType : supportedBlacklistTypes) {
            if (!ListManager.listSetContains(String.valueOf((Object)blacklistType) + ".BlackLists", blacklistToUse)) continue;
            try {
                Switchboard.urlBlacklist.add(blacklistType, blacklistToUse, newEntries);
            }
            catch (Punycode.PunycodeException e) {
                ConcurrentLog.warn(APP_NAME, "Unable to add blacklist entry to blacklist " + String.valueOf((Object)blacklistType), e);
            }
        }
        SearchEventCache.cleanupEvents(true);
        return newEntry.length;
    }
}

