/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.rtf.RTFEditorKit;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.document.AbstractParser;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.VocabularyScraper;

public class rtfParser
extends AbstractParser
implements Parser {
    public rtfParser() {
        super("Rich Text Format Parser");
        this.SUPPORTED_EXTENSIONS.add("rtf");
        this.SUPPORTED_MIME_TYPES.add("text/rtf");
        this.SUPPORTED_MIME_TYPES.add("text/richtext");
        this.SUPPORTED_MIME_TYPES.add("application/rtf");
        this.SUPPORTED_MIME_TYPES.add("application/x-rtf");
        this.SUPPORTED_MIME_TYPES.add("application/x-soffice");
    }

    @Override
    public Document[] parse(DigestURL location, String mimeType, String charset, VocabularyScraper scraper, int timezoneOffset, InputStream source) throws Parser.Failure, InterruptedException {
        try {
            DefaultStyledDocument doc = new DefaultStyledDocument();
            RTFEditorKit theRtfEditorKit = new RTFEditorKit();
            theRtfEditorKit.read(source, (javax.swing.text.Document)doc, 0);
            String bodyText = doc.getText(0, doc.getLength());
            return new Document[]{new Document(location, mimeType, StandardCharsets.UTF_8.name(), this, null, null, rtfParser.singleList((bodyText.length() > 80 ? bodyText.substring(0, 80) : bodyText.trim()).replaceAll("\r\n", " ").replaceAll("\n", " ").replaceAll("\r", " ").replaceAll("\t", " ")), null, "", null, null, 0.0, 0.0, bodyText, null, null, null, false, null)};
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            if (e instanceof Parser.Failure) {
                throw (Parser.Failure)e;
            }
            throw new Parser.Failure("Unexpected error while parsing rtf resource." + e.getMessage(), location);
        }
    }
}

