/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.yacy.cora.document.id.AnchorURL;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.document.AbstractParser;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.VocabularyScraper;

public class apkParser
extends AbstractParser
implements Parser {
    public apkParser() {
        super("Android Application Parser");
        this.SUPPORTED_EXTENSIONS.add("apk");
        this.SUPPORTED_MIME_TYPES.add("application/vnd.android.package-archive");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Document[] parse(DigestURL location, String mimeType, String charset, VocabularyScraper scraper, int timezoneOffset, InputStream source) throws Parser.Failure, InterruptedException {
        Document[] docs = null;
        File tempFile = null;
        FileOutputStream out = null;
        try {
            tempFile = File.createTempFile("apk" + System.currentTimeMillis(), "jar");
            out = new FileOutputStream(tempFile);
            int read = 0;
            byte[] data = new byte[1024];
            while ((read = source.read(data, 0, 1024)) != -1) {
                out.write(data, 0, read);
            }
            out.close();
            out = null;
            JarFile jf = new JarFile(tempFile);
            docs = this.parse(location, mimeType, charset, jf);
            return docs;
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            return docs;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
            finally {
                if (tempFile != null && !tempFile.delete()) {
                    log.warn("Could not delete temporary file " + String.valueOf(tempFile));
                }
            }
        }
    }

    public Document[] parse(DigestURL location, String mimeType, String charset, JarFile jf) {
        StringBuilder sb = new StringBuilder();
        Object title = location.getFileName();
        AndroidManifestParser manifest = null;
        try {
            InputStream is = jf.getInputStream(jf.getEntry("AndroidManifest.xml"));
            byte[] xml = new byte[is.available()];
            is.read(xml);
            manifest = new AndroidManifestParser(xml, true);
            title = location.getFileName() + " " + manifest.packageName + " " + manifest.versionName;
            sb.append((String)title).append(". ");
            for (String p : manifest.permissions) {
                sb.append(p).append(". ");
            }
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        Enumeration<JarEntry> je = jf.entries();
        while (je.hasMoreElements()) {
            String path = je.nextElement().toString();
            sb.append(path).append(". ");
        }
        ArrayList<AnchorURL> links = new ArrayList<AnchorURL>();
        try {
            InputStream is = jf.getInputStream(jf.getEntry("resources.arsc"));
            List<String> resources = apkParser.resourcesArscParser(is);
            for (String s : resources) {
                sb.append(s).append(". ");
                int p = s.indexOf("http://");
                if (p < 0) {
                    p = s.indexOf("https://");
                }
                if (p < 0) {
                    p = s.indexOf("ftp://");
                }
                if (p < 0) continue;
                int q = s.indexOf(32, p + 1);
                String link = q < 0 ? s.substring(p) : s.substring(p, q);
                try {
                    links.add(new AnchorURL(link));
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        return new Document[]{new Document(location, mimeType, charset, this, null, null, apkParser.singleList((String)title), null, manifest == null ? "" : manifest.packageName, null, null, 0.0, 0.0, sb.toString(), links, null, null, false, new Date())};
    }

    public static List<String> resourcesArscParser(InputStream arscStream) throws IOException {
        byte[] asa = new byte[arscStream.available()];
        arscStream.read(asa);
        int pos = 0;
        Charset charset = StandardCharsets.UTF_8;
        ArrayList<String> s = new ArrayList<String>();
        block0: while (pos < asa.length) {
            byte bytecount;
            byte charcount;
            while (pos < asa.length && asa[pos] != 0) {
                ++pos;
            }
            if (pos + 2 >= asa.length) break;
            if ((charcount = asa[++pos]) == 0 || (bytecount = asa[++pos]) == 0) continue;
            ++pos;
            if (bytecount < charcount) continue;
            if (pos + bytecount + 1 > asa.length) break;
            if (asa[pos + bytecount] != 0) {
                ++pos;
                continue;
            }
            for (int i = pos; i < pos + bytecount; ++i) {
                if (asa[i] != 0) continue;
                ++pos;
                continue block0;
            }
            String t = new String(asa, pos, (int)bytecount, charset);
            if (t.length() == charcount) {
                s.add(t);
            }
            pos += bytecount;
        }
        return s;
    }

    public static void main(String[] args) {
        System.out.println("apk parser test with file " + args[0]);
        System.out.println();
        System.out.println("File list:");
        try {
            JarFile jf = new JarFile(args[0]);
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                String path = e.nextElement().toString();
                System.out.println(path);
            }
            System.out.println();
            System.out.println("AndroidManifest.xml:");
            InputStream is = jf.getInputStream(jf.getEntry("AndroidManifest.xml"));
            byte[] xml = new byte[is.available()];
            is.read(xml);
            AndroidManifestParser manifest = new AndroidManifestParser(xml, true);
            System.out.println();
            System.out.println("resources.arsc:");
            is = jf.getInputStream(jf.getEntry("resources.arsc"));
            List<String> resources = apkParser.resourcesArscParser(is);
            for (String s : resources) {
                System.out.println(s);
            }
            jf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    public static class AndroidManifestParser {
        private boolean debug = false;
        public String versionCode = null;
        public String versionName = null;
        public String packageName = null;
        public String minSdkVersion = null;
        public String targetSdkVersion = null;
        public Set<String> permissions = new HashSet<String>();
        public Set<String> actions = new HashSet<String>();
        public Set<String> categories = new HashSet<String>();
        private static final int endDocTag = 0x100101;
        private static final int startTag = 0x100102;
        private static final int endTag = 0x100103;

        public AndroidManifestParser(byte[] xml, boolean debug) {
            this.debug = debug;
            this.decompressXML(xml);
        }

        private void decompressXML(byte[] xml) {
            int xmlTagOff;
            int numbStrings = this.LEW(xml, 16);
            int sitOff = 36;
            int stOff = sitOff + numbStrings * 4;
            for (int ii = xmlTagOff = this.LEW(xml, 12); ii < xml.length - 4; ii += 4) {
                if (this.LEW(xml, ii) != 0x100102) continue;
                xmlTagOff = ii;
                break;
            }
            int off = xmlTagOff;
            int indent = 0;
            while (off < xml.length) {
                int tag0 = this.LEW(xml, off);
                int nameSi = this.LEW(xml, off + 20);
                if (tag0 == 0x100102) {
                    int numbAttrs = this.LEW(xml, off + 28);
                    off += 36;
                    String name = this.compXmlString(xml, sitOff, stOff, nameSi);
                    LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
                    for (int ii = 0; ii < numbAttrs; ++ii) {
                        int attrNameSi = this.LEW(xml, off + 4);
                        int attrValueSi = this.LEW(xml, off + 8);
                        int attrResId = this.LEW(xml, off + 16);
                        off += 20;
                        String attrName = this.compXmlString(xml, sitOff, stOff, attrNameSi);
                        String attrValue = attrValueSi != -1 ? this.compXmlString(xml, sitOff, stOff, attrValueSi) : "resourceID 0x" + Integer.toHexString(attrResId);
                        attributes.put(attrName, attrValue);
                    }
                    this.evaluateTag(indent, name, attributes);
                    ++indent;
                    continue;
                }
                if (tag0 == 0x100103) {
                    off += 24;
                    String name = this.compXmlString(xml, sitOff, stOff, nameSi);
                    this.evaluateTag(--indent, name, null);
                    continue;
                }
                if (tag0 == 0x100101) break;
            }
        }

        public String compXmlString(byte[] xml, int sitOff, int stOff, int strInd) {
            if (strInd < 0) {
                return null;
            }
            int strOff = stOff + this.LEW(xml, sitOff + strInd * 4);
            return this.compXmlStringAt(xml, strOff);
        }

        public void evaluateTag(int indent, String tagName, Map<String, String> attributes) {
            if (this.debug) {
                StringBuilder sb = new StringBuilder(100);
                for (int i = 0; i < indent; ++i) {
                    sb.append("  ");
                }
                if (attributes == null) {
                    sb.append("</").append(tagName).append('>');
                } else {
                    sb.append('<').append(tagName);
                    for (Map.Entry<String, String> entry2 : attributes.entrySet()) {
                        sb.append(' ').append(entry2.getKey()).append("=\"").append(entry2.getValue()).append('\"');
                    }
                    sb.append('>');
                }
            }
            if (attributes != null) {
                String category;
                String action;
                String permission;
                if ("manifest".equals(tagName)) {
                    this.versionCode = attributes.get("versionCode");
                    this.versionName = attributes.get("versionName");
                    this.packageName = attributes.get("package");
                }
                if ("uses-sdk".equals(tagName)) {
                    this.minSdkVersion = attributes.get("minSdkVersion");
                    this.targetSdkVersion = attributes.get("targetSdkVersion");
                }
                if ("uses-permission".equals(tagName) && (permission = attributes.get("name")) != null) {
                    this.permissions.add(permission);
                }
                if ("action".equals(tagName) && (action = attributes.get("name")) != null) {
                    this.actions.add(action);
                }
                if ("category".equals(tagName) && (category = attributes.get("name")) != null) {
                    this.categories.add(category);
                }
            }
        }

        public String compXmlStringAt(byte[] arr, int strOff) {
            int p0;
            int strLen = arr[strOff + 1] << 8 & 0xFF00 | arr[strOff] & 0xFF;
            char[] chars = new char[strLen];
            for (int ii = 0; ii < strLen && (p0 = strOff + 2 + ii * 2) < arr.length - 1; ++ii) {
                chars[ii] = (char)(((arr[p0 + 1] & 0xFF) << 8) + (arr[p0] & 0xFF));
            }
            return new String(chars);
        }

        public int LEW(byte[] arr, int off) {
            return arr[off + 3] << 24 & 0xFF000000 | arr[off + 2] << 16 & 0xFF0000 | arr[off + 1] << 8 & 0xFF00 | arr[off] & 0xFF;
        }
    }
}

