/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.content.dao;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.sql.Statement;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.document.content.dao.DatabaseConnection;
import net.yacy.kelondro.util.FileUtils;

public class ImportDump {
    private final DatabaseConnection conn;

    public ImportDump(String dbType, String host, int port, String dbname, String user, String pw) throws Exception {
        this.conn = new DatabaseConnection(dbType, host, port, dbname, user, pw);
        this.conn.setAutoCommit(true);
    }

    public void imp(File dump) throws SQLException {
        Statement statement = null;
        try {
            statement = this.conn.statement();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileUtils.copy(dump, (OutputStream)baos);
            String s = UTF8.String(baos.toByteArray());
            while (!s.isEmpty()) {
                int p = s.indexOf("INSERT INTO", 1);
                int q = s.indexOf("CREATE TABLE", 1);
                if (q >= 0 && q < p) {
                    p = q;
                }
                if (p < 0) {
                    statement.executeBatch();
                    System.out.println(s);
                    statement.addBatch(s);
                    statement.executeBatch();
                    break;
                }
                String t = s.substring(0, p);
                s = s.substring(p);
                statement.executeBatch();
                System.out.println(t);
                statement.addBatch(t);
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            ConcurrentLog.logException(e);
            throw e;
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
            throw new SQLException(e.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public synchronized void close() {
        this.conn.close();
    }
}

