/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.util;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.LinkedHashMap;
import java.util.Map;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.http.YaCyHttpServer;
import net.yacy.search.Switchboard;

public class Memory {
    private static final Runtime runtime = Runtime.getRuntime();

    public static final long free() {
        return runtime.freeMemory();
    }

    public static final long available() {
        return Memory.maxMemory() - Memory.total() + Memory.free();
    }

    public static final long maxMemory() {
        return runtime.maxMemory();
    }

    public static final long total() {
        return runtime.totalMemory();
    }

    public static final long used() {
        return Memory.total() - Memory.free();
    }

    public static final long cores() {
        return runtime.availableProcessors();
    }

    public static double getSystemLoadAverage() {
        return ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
    }

    public static double getSystemCpuLoad() {
        OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        return operatingSystemMXBean.getSystemCpuLoad();
    }

    public static double getProcessCpuLoad() {
        OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        return operatingSystemMXBean.getProcessCpuLoad();
    }

    public static Map<String, Object> status() {
        Runtime runtime = Runtime.getRuntime();
        LinkedHashMap<String, Object> status = new LinkedHashMap<String, Object>();
        status.put("service", "Peer");
        status.put("assigned_memory", runtime.maxMemory());
        status.put("used_memory", runtime.totalMemory() - runtime.freeMemory());
        status.put("available_memory", runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory());
        status.put("cores", runtime.availableProcessors());
        status.put("threads", Thread.activeCount());
        status.put("deadlocks", Memory.deadlocks());
        status.put("load_system_load_average", Memory.getSystemLoadAverage());
        status.put("load_system_cpu_load", Memory.getSystemCpuLoad());
        status.put("load_process_cpu_load", Memory.getProcessCpuLoad());
        YaCyHttpServer server = Switchboard.getSwitchboard().getHttpServer();
        status.put("server_threads", server == null ? 0 : server.getServerThreads());
        return status;
    }

    public static long deadlocks() {
        long[] deadlockIDs = ManagementFactory.getThreadMXBean().findDeadlockedThreads();
        if (deadlockIDs == null) {
            return 0L;
        }
        return deadlockIDs.length;
    }

    public static void logDeadlocks() {
        ThreadInfo[] infos;
        long[] deadlockIDs = ManagementFactory.getThreadMXBean().findDeadlockedThreads();
        if (deadlockIDs == null) {
            return;
        }
        for (ThreadInfo ti : infos = ManagementFactory.getThreadMXBean().getThreadInfo(deadlockIDs, true, true)) {
            ConcurrentLog.warn("DEADLOCKREPORT", ti.toString());
        }
    }
}

