/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.util;

import java.io.StringWriter;

public class CRIgnoreWriter
extends StringWriter {
    public CRIgnoreWriter() {
    }

    public CRIgnoreWriter(int initialSize) {
        super(initialSize);
    }

    @Override
    public void write(int c) {
        if (c >= 32) {
            super.write(c);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int p = off;
        for (int i = 0; i < len; ++i) {
            char c = cbuf[p];
            if (c >= ' ') {
                super.write(c);
            }
            ++p;
        }
    }

    @Override
    public void write(String str) {
        if (str == null) {
            return;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c < ' ') continue;
            super.write(c);
        }
    }

    @Override
    public void write(String str, int off, int len) {
        int p = off;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(p);
            if (c >= ' ') {
                super.write(c);
            }
            ++p;
        }
    }

    @Override
    public CRIgnoreWriter append(CharSequence csq) {
        this.write(csq == null ? "null" : csq.toString());
        return this;
    }

    @Override
    public CRIgnoreWriter append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public CRIgnoreWriter append(char c) {
        if (c >= ' ') {
            this.write(c);
        }
        return this;
    }
}

