/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.yacy;

import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.Base64Order;

public class Distribution {
    private final int verticalPartitionExponent;
    private final int shiftLength;
    private final int partitionCount;
    private final long partitionSize;
    private final long partitionMask;

    public Distribution(int verticalPartitionExponent) {
        this.verticalPartitionExponent = verticalPartitionExponent;
        this.partitionCount = 1 << this.verticalPartitionExponent;
        this.shiftLength = 63 - this.verticalPartitionExponent;
        this.partitionSize = 1L << this.shiftLength;
        this.partitionMask = this.partitionSize - 1L;
    }

    public int verticalPartitions() {
        return this.partitionCount;
    }

    public static final long horizontalDHTPosition(byte[] wordHash) {
        assert (wordHash != null);
        assert (wordHash[2] != 64);
        return Base64Order.enhancedCoder.cardinal(wordHash);
    }

    public static final long horizontalDHTDistance(byte[] from, byte[] to) {
        long toPos = Distribution.horizontalDHTPosition(to);
        long fromPos = Distribution.horizontalDHTPosition(from);
        return Distribution.horizontalDHTDistance(fromPos, toPos);
    }

    public static final long horizontalDHTDistance(long fromPos, long toPos) {
        return toPos >= fromPos ? toPos - fromPos : Long.MAX_VALUE - fromPos + toPos + 1L;
    }

    public static final byte[] positionToHash(long l) {
        byte[] h = Base64Order.enhancedCoder.uncardinal(l);
        assert (h.length == 12);
        return h;
    }

    public final long verticalDHTPosition(byte[] wordHash, String urlHash) {
        return Distribution.horizontalDHTPosition(wordHash) & this.partitionMask | Distribution.horizontalDHTPosition(ASCII.getBytes(urlHash)) & (this.partitionMask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final long verticalDHTPosition(byte[] wordHash, int verticalPosition) {
        assert (verticalPosition >= 0 && verticalPosition < this.verticalPartitions());
        long verticalMask = (long)verticalPosition << this.shiftLength;
        return Distribution.horizontalDHTPosition(wordHash) & this.partitionMask | verticalMask;
    }

    public final int verticalDHTPosition(byte[] urlHash) {
        int vdp = (int)(Distribution.horizontalDHTPosition(urlHash) >> this.shiftLength);
        assert (vdp >= 0);
        assert (vdp < this.partitionCount);
        return vdp;
    }

    public static void main(String[] args) {
        byte[] wordHash = UTF8.getBytes("hHJBztzcFn76");
        int partitionExponent = 4;
        Distribution partition = new Distribution(partitionExponent);
        long dhtl = Distribution.horizontalDHTPosition(wordHash);
        System.out.println("DHT Long                = " + dhtl);
        System.out.println("DHT as b64 from Long    = " + ASCII.String(Distribution.positionToHash(dhtl)));
        System.out.println("all " + partition.verticalPartitions() + " DHT positions from long   : ");
        for (int i = 0; i < partition.verticalPartitions(); ++i) {
            long l = partition.verticalDHTPosition(wordHash, i);
            System.out.println(ASCII.String(Distribution.positionToHash(l)));
        }
        System.out.println();
        long c1 = Base64Order.enhancedCoder.cardinal("AAAAAAAAAAAA".getBytes());
        System.out.println(ASCII.String(Base64Order.enhancedCoder.uncardinal(c1)));
        long c2 = Base64Order.enhancedCoder.cardinal("____________".getBytes());
        System.out.println(ASCII.String(Base64Order.enhancedCoder.uncardinal(c2)));
    }
}

