/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import org.rrd4j.core.RrdBackend;

public abstract class RrdByteArrayBackend
extends RrdBackend {
    protected byte[] buffer;

    protected RrdByteArrayBackend(String path) {
        super(path);
    }

    @Override
    protected synchronized void write(long offset, byte[] bytes) throws IOException {
        int pos = (int)offset;
        System.arraycopy(bytes, 0, this.buffer, pos, bytes.length);
    }

    @Override
    protected synchronized void read(long offset, byte[] bytes) throws IOException {
        int pos = (int)offset;
        if (pos + bytes.length > this.buffer.length) {
            throw new IOException("Not enough bytes available in memory; RRD " + this.getPath());
        }
        System.arraycopy(this.buffer, pos, bytes, 0, bytes.length);
    }

    @Override
    public long getLength() {
        return this.buffer.length;
    }

    @Override
    protected void setLength(long length) throws IOException {
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Illegal length: " + length);
        }
        this.buffer = new byte[(int)length];
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    protected boolean isCachingAllowed() {
        return false;
    }
}

