/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.circuitbreaker;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.util.circuitbreaker.CPUCircuitBreaker;
import org.apache.solr.util.circuitbreaker.CircuitBreaker;
import org.apache.solr.util.circuitbreaker.MemoryCircuitBreaker;
import org.apache.solr.util.plugin.PluginInfoInitialized;

public class CircuitBreakerManager
implements PluginInfoInitialized {
    private final boolean enableCircuitBreakerManager;
    private final List<CircuitBreaker> circuitBreakerList = new ArrayList<CircuitBreaker>();

    public CircuitBreakerManager(boolean enableCircuitBreakerManager) {
        this.enableCircuitBreakerManager = enableCircuitBreakerManager;
    }

    @Override
    public void init(PluginInfo pluginInfo) {
        CircuitBreaker.CircuitBreakerConfig circuitBreakerConfig = CircuitBreakerManager.buildCBConfig(pluginInfo);
        MemoryCircuitBreaker memoryCircuitBreaker = new MemoryCircuitBreaker(circuitBreakerConfig);
        CPUCircuitBreaker cpuCircuitBreaker = new CPUCircuitBreaker(circuitBreakerConfig);
        this.register(memoryCircuitBreaker);
        this.register(cpuCircuitBreaker);
    }

    public void register(CircuitBreaker circuitBreaker) {
        this.circuitBreakerList.add(circuitBreaker);
    }

    public void deregisterAll() {
        this.circuitBreakerList.clear();
    }

    public List<CircuitBreaker> checkTripped() {
        ArrayList<CircuitBreaker> triggeredCircuitBreakers = null;
        if (this.enableCircuitBreakerManager) {
            for (CircuitBreaker circuitBreaker : this.circuitBreakerList) {
                if (!circuitBreaker.isEnabled() || !circuitBreaker.isTripped()) continue;
                if (triggeredCircuitBreakers == null) {
                    triggeredCircuitBreakers = new ArrayList<CircuitBreaker>();
                }
                triggeredCircuitBreakers.add(circuitBreaker);
            }
        }
        return triggeredCircuitBreakers;
    }

    public boolean checkAnyTripped() {
        if (this.enableCircuitBreakerManager) {
            for (CircuitBreaker circuitBreaker : this.circuitBreakerList) {
                if (!circuitBreaker.isEnabled() || !circuitBreaker.isTripped()) continue;
                return true;
            }
        }
        return false;
    }

    public static String toErrorMessage(List<CircuitBreaker> circuitBreakerList) {
        StringBuilder sb = new StringBuilder();
        for (CircuitBreaker circuitBreaker : circuitBreakerList) {
            sb.append(circuitBreaker.getErrorMessage());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static CircuitBreakerManager build(PluginInfo pluginInfo) {
        boolean enabled = pluginInfo == null ? false : Boolean.parseBoolean(pluginInfo.attributes.getOrDefault("enabled", "false"));
        CircuitBreakerManager circuitBreakerManager = new CircuitBreakerManager(enabled);
        circuitBreakerManager.init(pluginInfo);
        return circuitBreakerManager;
    }

    @VisibleForTesting
    public static CircuitBreaker.CircuitBreakerConfig buildCBConfig(PluginInfo pluginInfo) {
        boolean enabled = false;
        boolean cpuCBEnabled = false;
        boolean memCBEnabled = false;
        int memCBThreshold = 100;
        int cpuCBThreshold = 100;
        if (pluginInfo != null) {
            NamedList<Object> args = pluginInfo.initArgs;
            enabled = Boolean.parseBoolean(pluginInfo.attributes.getOrDefault("enabled", "false"));
            if (args != null) {
                cpuCBEnabled = Boolean.parseBoolean(args._getStr("cpuEnabled", "false"));
                memCBEnabled = Boolean.parseBoolean(args._getStr("memEnabled", "false"));
                memCBThreshold = Integer.parseInt(args._getStr("memThreshold", "100"));
                cpuCBThreshold = Integer.parseInt(args._getStr("cpuThreshold", "100"));
            }
        }
        return new CircuitBreaker.CircuitBreakerConfig(enabled, memCBEnabled, memCBThreshold, cpuCBEnabled, cpuCBThreshold);
    }

    public boolean isEnabled() {
        return this.enableCircuitBreakerManager;
    }

    @VisibleForTesting
    public List<CircuitBreaker> getRegisteredCircuitBreakers() {
        return this.circuitBreakerList;
    }
}

