/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.MapSerializable;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;

public class ConfigOverlay
implements MapSerializable {
    private final int znodeVersion;
    private final Map<String, Object> data;
    private Map<String, Object> props;
    private Map<String, Object> userProps;
    public static final String NOT_EDITABLE = "''{0}'' is not an editable property";
    public static final String RESOURCE_NAME = "configoverlay.json";
    private static Map<?, ?> editable_prop_map = (Map)Utils.fromJSONResource((String)"EditableSolrConfigAttributes.json");
    static Class<?>[] types = new Class[]{String.class, Boolean.class, Integer.class, Float.class};
    public static final String ZNODEVER = "znodeVersion";
    public static final String NAME = "overlay";

    public ConfigOverlay(Map<String, Object> jsonObj, int znodeVersion) {
        if (jsonObj == null) {
            jsonObj = Collections.emptyMap();
        }
        this.znodeVersion = znodeVersion;
        this.data = Collections.unmodifiableMap(jsonObj);
        this.props = (Map)this.data.get("props");
        if (this.props == null) {
            this.props = Collections.emptyMap();
        }
        this.userProps = (Map)this.data.get("userProps");
        if (this.userProps == null) {
            this.userProps = Collections.emptyMap();
        }
    }

    public Object getXPathProperty(String xpath) {
        return this.getXPathProperty(xpath, true);
    }

    public Object getXPathProperty(String xpath, boolean onlyPrimitive) {
        List<String> hierarchy = this.checkEditable(xpath, true, false);
        if (hierarchy == null) {
            return null;
        }
        return Utils.getObjectByPath(this.props, (boolean)onlyPrimitive, hierarchy);
    }

    public Object getXPathProperty(List<String> path) {
        ArrayList<String> hierarchy = new ArrayList<String>();
        if (ConfigOverlay.isEditable(true, hierarchy, path) == null) {
            return null;
        }
        return Utils.getObjectByPath(this.props, (boolean)true, hierarchy);
    }

    public ConfigOverlay setUserProperty(String key, Object val) {
        LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(this.userProps);
        copy.put(key, val);
        LinkedHashMap<String, Object> jsonObj = new LinkedHashMap<String, Object>(this.data);
        jsonObj.put("userProps", copy);
        return new ConfigOverlay(jsonObj, this.znodeVersion);
    }

    public ConfigOverlay unsetUserProperty(String key) {
        if (!this.userProps.containsKey(key)) {
            return this;
        }
        LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(this.userProps);
        copy.remove(key);
        LinkedHashMap<String, Object> jsonObj = new LinkedHashMap<String, Object>(this.data);
        jsonObj.put("userProps", copy);
        return new ConfigOverlay(jsonObj, this.znodeVersion);
    }

    public ConfigOverlay setProperty(String name, Object val) {
        Map deepCopy;
        List<String> hierarchy = this.checkEditable(name, false, true);
        Map obj = deepCopy = (Map)Utils.fromJSON((byte[])Utils.toJSON(this.props));
        for (int i = 0; i < hierarchy.size(); ++i) {
            String s = hierarchy.get(i);
            if (i < hierarchy.size() - 1) {
                if (obj.get(s) == null || !(obj.get(s) instanceof Map)) {
                    obj.put(s, new LinkedHashMap());
                }
                obj = (Map)obj.get(s);
                continue;
            }
            obj.put(s, val);
        }
        LinkedHashMap<String, Object> jsonObj = new LinkedHashMap<String, Object>(this.data);
        jsonObj.put("props", deepCopy);
        return new ConfigOverlay(jsonObj, this.znodeVersion);
    }

    private List<String> checkEditable(String propName, boolean isXPath, boolean failOnError) {
        LinkedList<String> hierarchy = new LinkedList<String>();
        if (!ConfigOverlay.isEditableProp(propName, isXPath, hierarchy)) {
            if (failOnError) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, StrUtils.formatString((String)NOT_EDITABLE, (Object[])new Object[]{propName}));
            }
            return null;
        }
        return hierarchy;
    }

    public ConfigOverlay unsetProperty(String name) {
        Map deepCopy;
        List<String> hierarchy = this.checkEditable(name, false, true);
        Map obj = deepCopy = (Map)Utils.fromJSON((byte[])Utils.toJSON(this.props));
        for (int i = 0; i < hierarchy.size(); ++i) {
            String s = hierarchy.get(i);
            if (i < hierarchy.size() - 1) {
                if (obj.get(s) == null || !(obj.get(s) instanceof Map)) {
                    return this;
                }
                obj = (Map)obj.get(s);
                continue;
            }
            obj.remove(s);
        }
        LinkedHashMap<String, Object> jsonObj = new LinkedHashMap<String, Object>(this.data);
        jsonObj.put("props", deepCopy);
        return new ConfigOverlay(jsonObj, this.znodeVersion);
    }

    public byte[] toByteArray() {
        return Utils.toJSON(this.data);
    }

    public int getZnodeVersion() {
        return this.znodeVersion;
    }

    public String toString() {
        return Utils.toJSONString(this.data);
    }

    public static boolean isEditableProp(String path, boolean isXpath, List<String> hierarchy) {
        return ConfigOverlay.checkEditable(path, isXpath, hierarchy) != null;
    }

    public static Class<?> checkEditable(String path, boolean isXpath, List<String> hierarchy) {
        List parts = StrUtils.splitSmart((String)path, (char)(isXpath ? (char)'/' : '.'));
        return ConfigOverlay.isEditable(isXpath, hierarchy, StrUtils.splitSmart((String)path, (char)(isXpath ? (char)'/' : '.')));
    }

    private static Class<?> isEditable(boolean isXpath, List<String> hierarchy, List<String> parts) {
        Map<Object, Object> obj = editable_prop_map;
        for (int i = 0; i < parts.size(); ++i) {
            boolean isAttr;
            String part = parts.get(i);
            boolean bl = isAttr = isXpath && part.startsWith("@");
            if (isAttr) {
                part = part.substring(1);
            }
            if (hierarchy != null) {
                hierarchy.add(part);
            }
            if (obj == null) {
                return null;
            }
            if (i == parts.size() - 1) {
                if (obj instanceof Map) {
                    Map<?, ?> map = obj;
                    Object o = map.get(part);
                    return ConfigOverlay.checkType(o, isXpath, isAttr);
                }
                return null;
            }
            obj = obj.get(part);
        }
        return null;
    }

    private static Class<?> checkType(Object o, boolean isXpath, boolean isAttr) {
        if (o instanceof Long) {
            Long aLong = (Long)o;
            int ten = aLong.intValue() / 10;
            int one = aLong.intValue() % 10;
            if (isXpath && isAttr && one != 0) {
                return null;
            }
            return types[ten];
        }
        return null;
    }

    public Map<String, Object> getEditableSubProperties(String xpath) {
        Object o = Utils.getObjectByPath(this.props, (boolean)false, (List)StrUtils.splitSmart((String)xpath, (char)'/'));
        if (o instanceof Map) {
            return (Map)o;
        }
        return null;
    }

    public Map<String, Object> getUserProps() {
        return this.userProps;
    }

    public Map<String, Object> toMap(Map<String, Object> map) {
        map.put(ZNODEVER, this.znodeVersion);
        map.putAll(this.data);
        return map;
    }

    public Map<String, Map<String, Object>> getNamedPlugins(String typ) {
        Map reqHandlers = (Map)this.data.get(typ);
        if (reqHandlers == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(reqHandlers);
    }

    boolean hasKey(String key) {
        return this.props.containsKey(key);
    }

    public ConfigOverlay addNamedPlugin(Map<String, Object> info, String typ) {
        Map dataCopy = Utils.getDeepCopy(this.data, (int)4);
        LinkedHashMap<String, Map<String, Object>> existing = (LinkedHashMap<String, Map<String, Object>>)dataCopy.get(typ);
        if (existing == null) {
            existing = new LinkedHashMap<String, Map<String, Object>>();
            dataCopy.put(typ, existing);
        }
        existing.put(info.get("name").toString(), info);
        return new ConfigOverlay(dataCopy, this.znodeVersion);
    }

    public ConfigOverlay deleteNamedPlugin(String name, String typ) {
        Map dataCopy = Utils.getDeepCopy(this.data, (int)4);
        Map reqHandler = (Map)dataCopy.get(typ);
        if (reqHandler == null) {
            return this;
        }
        reqHandler.remove(name);
        return new ConfigOverlay(dataCopy, this.znodeVersion);
    }
}

