/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.solr.api.Api;
import org.apache.solr.api.ApiBag;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.TaskManagementHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;

public class QueryCancellationHandler
extends TaskManagementHandler {
    private List<SearchComponent> components;

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        ResponseBuilder rb = QueryCancellationHandler.buildResponseBuilder(req, rsp, this.getComponentsList());
        HashMap<String, String> extraParams = null;
        rb.setCancellation(true);
        String cancellationUUID = req.getParams().get("queryUUID", null);
        if (cancellationUUID == null) {
            throw new IllegalArgumentException("Query cancellation was requested but no query UUID for cancellation was given");
        }
        if (rb.isDistrib) {
            extraParams = new HashMap<String, String>();
            extraParams.put("queryUUID", cancellationUUID);
        }
        rb.setCancellationUUID(cancellationUUID);
        this.processRequest(req, rb, extraParams);
    }

    @Override
    public String getDescription() {
        return "Cancel queries";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext ctx) {
        return PermissionNameProvider.Name.READ_PERM;
    }

    @Override
    public SolrRequestHandler getSubHandler(String path) {
        if (path.startsWith("/tasks/cancel")) {
            return this;
        }
        return null;
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    @Override
    public Collection<Api> getApis() {
        return ApiBag.wrapRequestHandlers(this, "core.tasks.cancel");
    }

    private List<SearchComponent> getComponentsList() {
        if (this.components == null) {
            this.components = QueryCancellationHandler.buildComponentsList();
        }
        return this.components;
    }
}

